/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;

public class ScpToMessageBySftp
extends ScpToMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private File localFile;
    private final String remotePath;
    private List directoryList;

    public ScpToMessageBySftp(boolean verbose, Session session, File aLocalFile, String aRemotePath) {
        this(verbose, session, aRemotePath);
        this.localFile = aLocalFile;
    }

    public ScpToMessageBySftp(boolean verbose, Session session, List aDirectoryList, String aRemotePath) {
        this(verbose, session, aRemotePath);
        this.directoryList = aDirectoryList;
    }

    private ScpToMessageBySftp(boolean verbose, Session session, String aRemotePath) {
        super(verbose, session);
        this.remotePath = aRemotePath;
    }

    public ScpToMessageBySftp(Session session, File aLocalFile, String aRemotePath) {
        this(false, session, aLocalFile, aRemotePath);
    }

    public ScpToMessageBySftp(Session session, List aDirectoryList, String aRemotePath) {
        this(false, session, aDirectoryList, aRemotePath);
    }

    public void execute() throws IOException, JSchException {
        if (this.directoryList != null) {
            this.doMultipleTransfer();
        }
        if (this.localFile != null) {
            this.doSingleTransfer();
        }
        this.log("done.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSingleTransfer() throws IOException, JSchException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.connect();
            try {
                this.sendFileToRemote(channel, this.localFile, this.remotePath);
            }
            catch (SftpException e) {
                JSchException schException = new JSchException("Could not send '" + this.localFile + "' to '" + this.remotePath + "' - " + e.toString());
                schException.initCause((Throwable)e);
                throw schException;
            }
            Object var5_4 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doMultipleTransfer() throws IOException, JSchException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.connect();
            try {
                try {
                    channel.stat(this.remotePath);
                }
                catch (SftpException e) {
                    if (e.id != 2) throw new JSchException("failed to access remote dir '" + this.remotePath + "'", (Throwable)e);
                    channel.mkdir(this.remotePath);
                    channel.chmod(this.getDirMode(), this.remotePath);
                }
                channel.cd(this.remotePath);
            }
            catch (SftpException e) {
                throw new JSchException("Could not CD to '" + this.remotePath + "' - " + e.toString(), (Throwable)e);
            }
            Directory current2 = null;
            try {
                for (Directory current2 : this.directoryList) {
                    if (this.getVerbose()) {
                        this.log("Sending directory " + current2);
                    }
                    this.sendDirectory(channel, current2);
                }
            }
            catch (SftpException e) {
                String msg = "Error sending directory";
                if (current2 == null || current2.getDirectory() == null) throw new JSchException(msg, (Throwable)e);
                msg = msg + " '" + current2.getDirectory().getName() + "'";
                throw new JSchException(msg, (Throwable)e);
            }
            Object var6_8 = null;
            if (channel == null) return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (channel == null) throw throwable;
            channel.disconnect();
            throw throwable;
        }
        channel.disconnect();
    }

    private void sendDirectory(ChannelSftp channel, Directory current) throws IOException, SftpException {
        Iterator fileIt = current.filesIterator();
        while (fileIt.hasNext()) {
            this.sendFileToRemote(channel, (File)fileIt.next(), null);
        }
        Iterator dirIt = current.directoryIterator();
        while (dirIt.hasNext()) {
            Directory dir = (Directory)dirIt.next();
            this.sendDirectoryToRemote(channel, dir);
        }
    }

    private void sendDirectoryToRemote(ChannelSftp channel, Directory directory) throws IOException, SftpException {
        String dir;
        block2: {
            dir = directory.getDirectory().getName();
            try {
                channel.stat(dir);
            }
            catch (SftpException e) {
                if (e.id != 2) break block2;
                channel.mkdir(dir);
                channel.chmod(this.getDirMode(), dir);
            }
        }
        channel.cd(dir);
        this.sendDirectory(channel, directory);
        channel.cd("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFileToRemote(ChannelSftp channel, File localFile, String remotePath) throws IOException, SftpException {
        long filesize = localFile.length();
        if (remotePath == null) {
            remotePath = localFile.getName();
        }
        long startTime = System.currentTimeMillis();
        long totalLength = filesize;
        boolean trackProgress = this.getVerbose() && filesize > 102400L;
        SftpProgressMonitor monitor = null;
        if (trackProgress) {
            monitor = this.getProgressMonitor();
        }
        try {
            if (this.getVerbose()) {
                this.log("Sending: " + localFile.getName() + " : " + filesize);
            }
            channel.put(localFile.getAbsolutePath(), remotePath, monitor);
            channel.chmod(this.getFileMode(), remotePath);
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            if (this.getVerbose()) {
                long endTime = System.currentTimeMillis();
                this.logStats(startTime, endTime, (int)totalLength);
            }
            throw throwable;
        }
        if (this.getVerbose()) {
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, (int)totalLength);
        }
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public String getRemotePath() {
        return this.remotePath;
    }
}

