/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import org.openrdf.model.URI;

public class ExtractionContext {
    public static final String ROOT_EXTRACTION_RESULT_ID = "root-extraction-result-id";
    private final String extractorName;
    private final URI documentURI;
    private String defaultLanguage;
    private final String uniqueID;

    public ExtractionContext(String extractorName, URI documentURI, String defaultLanguage, String localID) {
        this.checkNotNull(extractorName, "extractor name");
        this.checkNotNull(documentURI, "document URI");
        this.extractorName = extractorName;
        this.documentURI = documentURI;
        this.defaultLanguage = defaultLanguage;
        this.uniqueID = "urn:x-any23:" + extractorName + ":" + (localID == null ? "" : localID) + ":" + documentURI;
    }

    public ExtractionContext(String extractorName, URI documentURI, String defaultLanguage) {
        this(extractorName, documentURI, defaultLanguage, ROOT_EXTRACTION_RESULT_ID);
    }

    public ExtractionContext(String extractorName, URI documentURI) {
        this(extractorName, documentURI, null);
    }

    public ExtractionContext copy(String localID) {
        return new ExtractionContext(this.getExtractorName(), this.getDocumentURI(), this.getDefaultLanguage(), localID);
    }

    public String getExtractorName() {
        return this.extractorName;
    }

    public URI getDocumentURI() {
        return this.documentURI;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExtractionContext)) {
            return false;
        }
        return ((ExtractionContext)other).uniqueID.equals(this.uniqueID);
    }

    public String toString() {
        return "ExtractionContext(" + this.uniqueID + ")";
    }

    private void checkNotNull(Object data, String desc) {
        if (data == null) {
            throw new NullPointerException(desc + " cannot be null.");
        }
    }
}

