/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.any23.cli.Tool;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.extractor.ExtractorGroup;
import org.apache.any23.extractor.ExtractorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Any23PluginManager {
    public static final String CLI_PACKAGE = Tool.class.getPackage().getName();
    public static final String PLUGIN_DIRS_PROPERTY = "any23.plugin.dirs";
    public static final String PLUGIN_DIRS_LIST_SEPARATOR = ":";
    private static final Logger logger = LoggerFactory.getLogger(Any23PluginManager.class);
    private static final Any23PluginManager instance = new Any23PluginManager();
    private final DynamicClassLoader dynamicClassLoader = new DynamicClassLoader();

    public static synchronized Any23PluginManager getInstance() {
        return instance;
    }

    private Any23PluginManager() {
    }

    public synchronized boolean loadJAR(File jar) {
        if (jar == null) {
            throw new NullPointerException("jar file cannot be null.");
        }
        if (!jar.isFile() && !jar.exists()) {
            throw new IllegalArgumentException(String.format("Invalid JAR [%s], must be an existing file.", jar.getAbsolutePath()));
        }
        return this.dynamicClassLoader.addJAR(jar);
    }

    public synchronized Throwable[] loadJARs(File ... jars) {
        ArrayList<IllegalArgumentException> result = new ArrayList<IllegalArgumentException>();
        for (File jar : jars) {
            try {
                this.loadJAR(jar);
            }
            catch (Throwable t) {
                result.add(new IllegalArgumentException(String.format("Error while loading jar [%s]", jar.getAbsolutePath()), t));
            }
        }
        return result.toArray(new Throwable[result.size()]);
    }

    public synchronized boolean loadClassDir(File classDir) {
        if (classDir == null) {
            throw new NullPointerException("classDir cannot be null.");
        }
        if (!classDir.isDirectory() && !classDir.exists()) {
            throw new IllegalArgumentException(String.format("Invalid class dir [%s], must be an existing file.", classDir.getAbsolutePath()));
        }
        return this.dynamicClassLoader.addClassDir(classDir);
    }

    public synchronized Throwable[] loadClassDirs(File ... classDirs) {
        ArrayList<IllegalArgumentException> result = new ArrayList<IllegalArgumentException>();
        for (File classDir : classDirs) {
            try {
                this.loadClassDir(classDir);
            }
            catch (Throwable t) {
                result.add(new IllegalArgumentException(String.format("Error while loading class dir [%s]", classDir.getAbsolutePath()), t));
            }
        }
        return result.toArray(new Throwable[result.size()]);
    }

    public synchronized boolean loadJARDir(File jarDir) {
        if (jarDir == null) {
            throw new NullPointerException("JAR dir must be not null.");
        }
        if (!jarDir.exists()) {
            throw new IllegalArgumentException("Given directory doesn't exist:" + jarDir.getAbsolutePath());
        }
        if (!jarDir.isDirectory()) {
            throw new IllegalArgumentException("given file exists and it is not a directory: " + jarDir.getAbsolutePath());
        }
        boolean loaded = true;
        for (File jarFile : jarDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            loaded &= this.loadJAR(jarFile);
        }
        return loaded;
    }

    public synchronized Throwable[] loadFiles(File ... files) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (File file : files) {
            try {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    this.loadJAR(file);
                    continue;
                }
                if (file.isDirectory()) {
                    if (file.getName().endsWith("classes")) {
                        this.loadClassDir(file);
                        continue;
                    }
                    this.loadJARDir(file);
                    continue;
                }
                throw new IllegalArgumentException("Cannot handle file " + file.getAbsolutePath());
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        return errors.toArray(new Throwable[errors.size()]);
    }

    public synchronized <T> Iterator<T> getPlugins(Class<T> type) throws IOException {
        return ServiceLoader.load(type, this.dynamicClassLoader).iterator();
    }

    public synchronized Iterator<Tool> getTools() throws IOException {
        return this.getPlugins(Tool.class);
    }

    public synchronized Iterator<ExtractorFactory> getExtractors() throws IOException {
        return this.getPlugins(ExtractorFactory.class);
    }

    public synchronized String loadPlugins(File ... pluginLocations) {
        StringBuilder report = new StringBuilder();
        report.append("\nLoading plugins from locations {\n");
        for (File pluginLocation : pluginLocations) {
            report.append(pluginLocation.getAbsolutePath()).append('\n');
        }
        report.append("}\n");
        Throwable[] errors = this.loadFiles(pluginLocations);
        if (errors.length > 0) {
            report.append("The following errors occurred while loading plugins {\n");
            for (Throwable error : errors) {
                report.append(error);
                report.append("\n\n\n");
            }
            report.append("}\n");
        }
        return report.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ExtractorGroup configureExtractors(File ... pluginLocations) throws IOException, IllegalAccessException, InstantiationException {
        String pluginsReport = this.loadPlugins(pluginLocations);
        logger.info(pluginsReport);
        StringBuilder report = new StringBuilder();
        try {
            ArrayList newFactoryList = new ArrayList();
            Iterator<ExtractorFactory> extractors = this.getExtractors();
            while (extractors.hasNext()) {
                ExtractorFactory factory = extractors.next();
                report.append("\n - found plugin: ").append(factory.getExtractorName()).append("\n");
                newFactoryList.add(factory);
            }
            if (newFactoryList.isEmpty()) {
                report.append("\n=== No plugins have been found.===\n");
            }
            ExtractorGroup extractorGroup = new ExtractorGroup(newFactoryList);
            return extractorGroup;
        }
        finally {
            logger.info(report.toString());
        }
    }

    public synchronized ExtractorGroup configureExtractors(ExtractorGroup initialExtractorGroup) throws IOException, InstantiationException, IllegalAccessException {
        String pluginDirs = DefaultConfiguration.singleton().getPropertyOrFail(PLUGIN_DIRS_PROPERTY);
        File[] pluginLocations = this.getPluginLocations(pluginDirs);
        return this.configureExtractors(pluginLocations);
    }

    public synchronized ExtractorGroup getApplicableExtractors(ExtractorRegistry registry, File ... pluginLocations) throws IOException, IllegalAccessException, InstantiationException {
        return this.configureExtractors(pluginLocations);
    }

    public synchronized Iterator<Tool> getApplicableTools(File ... pluginLocations) throws IOException {
        String report = this.loadPlugins(pluginLocations);
        logger.info(report);
        return this.getTools();
    }

    private File[] getPluginLocations(String pluginDirsList) {
        String[] locationsStr = pluginDirsList.split(PLUGIN_DIRS_LIST_SEPARATOR);
        ArrayList<File> locations = new ArrayList<File>();
        for (String locationStr : locationsStr) {
            File location = new File(locationStr);
            if (!location.exists()) {
                throw new IllegalArgumentException(String.format("Plugin location '%s' cannot be found.", locationStr));
            }
            locations.add(location);
        }
        return locations.toArray(new File[locations.size()]);
    }

    private static final class DynamicClassLoader
    extends URLClassLoader {
        private final Set<String> addedURLs = new HashSet<String>();
        private final List<File> jars = new ArrayList<File>();
        private final List<File> dirs = new ArrayList<File>();

        public DynamicClassLoader(URL[] urls) {
            super(urls, Any23PluginManager.class.getClassLoader());
        }

        public DynamicClassLoader() {
            this(new URL[0]);
        }

        public boolean addClassDir(File classDir) {
            String urlPath = "file://" + classDir.getAbsolutePath() + "/";
            try {
                if (this.addURL(urlPath)) {
                    this.dirs.add(classDir);
                    return true;
                }
                return false;
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException("Invalid dir URL.", murle);
            }
        }

        public boolean addJAR(File jar) {
            String urlPath = "jar:file://" + jar.getAbsolutePath() + "!/";
            try {
                if (this.addURL(urlPath)) {
                    this.jars.add(jar);
                    return true;
                }
                return false;
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException("Invalid JAR URL.", murle);
            }
        }

        private boolean addURL(String urlPath) throws MalformedURLException {
            if (this.addedURLs.contains(urlPath)) {
                return false;
            }
            super.addURL(new URL(urlPath));
            this.addedURLs.add(urlPath);
            return true;
        }
    }
}

