/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.rdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.impl.ValueFactoryImpl;

public class Prefixes {
    public static Prefixes EMPTY = new Prefixes(Collections.<String, String>emptyMap());
    private final Map<String, String> mappings;
    private final Set<String> volatilePrefixes = new HashSet<String>();
    private Map<String, String> mapUnmodifiable = null;

    public static Prefixes create1(String prefix, String namespaceURI) {
        Prefixes result = new Prefixes();
        result.add(prefix, namespaceURI);
        return result;
    }

    public static Prefixes createFromMap(Map<String, String> prefixesToNamespaceURIs, boolean areVolatile) {
        Prefixes result = new Prefixes();
        for (Map.Entry<String, String> entry : prefixesToNamespaceURIs.entrySet()) {
            if (areVolatile) {
                result.addVolatile(entry.getKey(), entry.getValue());
                continue;
            }
            result.add(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Prefixes() {
        this(new HashMap<String, String>());
    }

    public Prefixes(Prefixes initial) {
        this();
        this.add(initial);
    }

    private Prefixes(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public URI expand(String curie) {
        String prefix = this.parsePrefix(curie);
        if (prefix == null || !this.hasPrefix(prefix)) {
            return null;
        }
        return ValueFactoryImpl.getInstance().createURI(this.getNamespaceURIFor(prefix) + this.parseLocalName(curie));
    }

    public String abbreviate(String uri) {
        for (Map.Entry<String, String> namespace : this.mappings.entrySet()) {
            if (!uri.startsWith(namespace.getValue())) continue;
            return namespace.getKey() + ":" + uri.substring(namespace.getValue().length());
        }
        return null;
    }

    public boolean canExpand(String curie) {
        String prefix = this.parsePrefix(curie);
        return prefix != null && this.hasPrefix(prefix);
    }

    public boolean canAbbreviate(String uri) {
        for (Map.Entry<String, String> namespace : this.mappings.entrySet()) {
            if (!uri.startsWith(namespace.getValue())) continue;
            return true;
        }
        return false;
    }

    public String getNamespaceURIFor(String prefix) {
        return this.mappings.get(prefix);
    }

    public boolean hasNamespaceURI(String uri) {
        return this.mappings.containsValue(uri);
    }

    public boolean hasPrefix(String prefix) {
        return this.mappings.containsKey(prefix);
    }

    public Set<String> allPrefixes() {
        return this.mappings.keySet();
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public void add(String prefix, String namespaceURI) {
        if (this.isVolatile(prefix)) {
            this.volatilePrefixes.remove(prefix);
        } else if (this.hasPrefix(prefix)) {
            if (this.getNamespaceURIFor(prefix).equals(namespaceURI)) {
                return;
            }
            throw new IllegalStateException("Attempted to re-assign prefix '" + prefix + "'; clashing values '" + this.getNamespaceURIFor(prefix) + "' and '" + namespaceURI);
        }
        this.mappings.put(prefix, namespaceURI);
    }

    public void add(Prefixes other) {
        for (String otherPrefix : other.allPrefixes()) {
            if (other.isVolatile(otherPrefix)) {
                this.addVolatile(otherPrefix, other.getNamespaceURIFor(otherPrefix));
                continue;
            }
            this.add(otherPrefix, other.getNamespaceURIFor(otherPrefix));
        }
    }

    public void removePrefix(String prefix) {
        this.mappings.remove(prefix);
        this.volatilePrefixes.remove(prefix);
    }

    public Prefixes createSubset(String ... prefixes) {
        Prefixes result = new Prefixes();
        for (String prefix : prefixes) {
            if (!this.hasPrefix(prefix)) {
                throw new IllegalArgumentException("No namespace URI declared for prefix " + prefix);
            }
            result.add(prefix, this.getNamespaceURIFor(prefix));
        }
        return result;
    }

    public void addVolatile(String prefix, String namespaceURI) {
        if (this.hasPrefix(prefix)) {
            return;
        }
        this.mappings.put(prefix, namespaceURI);
        this.volatilePrefixes.add(prefix);
    }

    public void addVolatile(Prefixes other) {
        for (String otherPrefix : other.allPrefixes()) {
            this.addVolatile(otherPrefix, other.getNamespaceURIFor(otherPrefix));
        }
    }

    public boolean isVolatile(String prefix) {
        return this.volatilePrefixes.contains(prefix);
    }

    public Map<String, String> asMap() {
        if (this.mapUnmodifiable == null) {
            this.mapUnmodifiable = Collections.unmodifiableMap(this.mappings);
        }
        return this.mapUnmodifiable;
    }

    private String parsePrefix(String curie) {
        int index = curie.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("Not a CURIE: '" + curie + "'");
        }
        return curie.substring(0, index);
    }

    private String parseLocalName(String curie) {
        int index = curie.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException("Not a CURIE: '" + curie + "'");
        }
        return curie.substring(index + 1);
    }
}

