/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.WriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WriterFactoryRegistry.class);
    private static WriterFactoryRegistry instance;
    private final List<WriterFactory> writers = new ArrayList<WriterFactory>();
    private final Map<String, List<WriterFactory>> mimeToWriter = new HashMap<String, List<WriterFactory>>();
    private final Map<String, WriterFactory> idToWriter = new HashMap<String, WriterFactory>();
    private List<String> identifiers = new ArrayList<String>();

    public WriterFactoryRegistry() {
        ServiceLoader<WriterFactory> serviceLoader = ServiceLoader.load(WriterFactory.class, this.getClass().getClassLoader());
        Iterator<WriterFactory> iterator = serviceLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    WriterFactory factory = iterator.next();
                    this.register(factory);
                }
            }
            catch (ServiceConfigurationError error) {
                LOG.error("Found error loading a WriterFactory", (Throwable)error);
                continue;
            }
            break;
        }
    }

    public static String getIdentifier(WriterFactory writerClass) {
        return writerClass.getIdentifier();
    }

    public static String getMimeType(WriterFactory writerClass) {
        return writerClass.getMimeType();
    }

    public static synchronized WriterFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new WriterFactoryRegistry();
        }
        return instance;
    }

    public synchronized void register(WriterFactory writerClass) {
        if (writerClass == null) {
            throw new NullPointerException("writerClass cannot be null.");
        }
        String id = writerClass.getIdentifier();
        String mimeType = writerClass.getMimeType();
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid identifier returned by writer " + writerClass);
        }
        if (mimeType == null || mimeType.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid MIME type returned by writer " + writerClass);
        }
        if (this.idToWriter.containsKey(id)) {
            throw new IllegalArgumentException("The writer identifier is already declared.");
        }
        this.writers.add(writerClass);
        this.identifiers.add(writerClass.getIdentifier());
        List<WriterFactory> writerClasses = this.mimeToWriter.get(mimeType);
        if (writerClasses == null) {
            writerClasses = new ArrayList<WriterFactory>();
            this.mimeToWriter.put(mimeType, writerClasses);
        }
        writerClasses.add(writerClass);
        this.idToWriter.put(id, writerClass);
    }

    public synchronized boolean hasIdentifier(String id) {
        return this.idToWriter.containsKey(id);
    }

    public synchronized List<String> getIdentifiers() {
        return Collections.unmodifiableList(this.identifiers);
    }

    public synchronized Collection<String> getMimeTypes() {
        return Collections.unmodifiableCollection(this.mimeToWriter.keySet());
    }

    public synchronized List<WriterFactory> getWriters() {
        return Collections.unmodifiableList(this.writers);
    }

    public synchronized WriterFactory getWriterByIdentifier(String id) {
        return this.idToWriter.get(id);
    }

    public synchronized Collection<WriterFactory> getWritersByMimeType(String mimeType) {
        return this.mimeToWriter.get(mimeType);
    }

    public synchronized FormatWriter getWriterInstanceByIdentifier(String id, OutputStream os) {
        WriterFactory writerClazz = this.getWriterByIdentifier(id);
        if (writerClazz == null) {
            throw new NullPointerException(String.format("Cannot find writer with id '%s' .", id));
        }
        return this.createWriter(writerClazz, os);
    }

    private FormatWriter createWriter(WriterFactory clazz, OutputStream os) {
        try {
            return clazz.getRdfWriter(os);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while initializing format writer " + clazz + " .", e);
        }
    }
}

