/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.configuration;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public abstract class Setting<V>
implements Cloneable {
    private final Key key;
    private V value;
    private static final Pattern identifierPattern = Pattern.compile("[a-z][0-9a-z]*(\\.[a-z][0-9a-z]*)*");

    protected Setting(String identifier, V defaultValue) {
        Setting.checkIdentifier(identifier);
        this.key = new Key(identifier, Setting.lookupValueType(this.getClass(), identifier), defaultValue != null);
        this.value = defaultValue;
    }

    protected Setting(String identifier, Class<V> valueType, V defaultValue) {
        this(identifier, defaultValue, valueType);
        if (valueType.isArray()) {
            throw new IllegalArgumentException(identifier + " value class must be immutable");
        }
        if (valueType.getTypeParameters().length != 0) {
            throw new IllegalArgumentException(identifier + " setting key must fill in type parameters for " + valueType.toGenericString());
        }
        if (valueType.isPrimitive()) {
            throw new IllegalArgumentException(identifier + " value class cannot be primitive");
        }
    }

    private Setting(String identifier, V defaultValue, Class<V> valueType) {
        Setting.checkIdentifier(identifier);
        this.key = new Key(identifier, valueType, defaultValue != null);
        this.value = defaultValue;
    }

    public final String getIdentifier() {
        return this.key.identifier;
    }

    protected void checkValue(V newValue) throws Exception {
        if (newValue == null && this.key.nonnull) {
            throw new NullPointerException();
        }
    }

    public final V getValue() {
        return this.value;
    }

    public final Type getValueType() {
        return this.key.valueType;
    }

    public final <S extends Setting<?>> Optional<S> as(S setting) {
        return this.key == setting.key ? Optional.of(this) : Optional.empty();
    }

    public final Setting<V> withValue(V newValue) {
        return Setting.clone(this, newValue);
    }

    protected final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Setting)) {
            return false;
        }
        Setting setting = (Setting)o;
        return this.key == setting.key && Objects.equals(this.value, setting.value);
    }

    public final int hashCode() {
        return this.key.hashCode() ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return this.key.identifier + "=" + this.value;
    }

    public static Setting<Boolean> create(String identifier, Boolean defaultValue) {
        return new Impl<Boolean>(identifier, defaultValue, Boolean.class);
    }

    public static Setting<String> create(String identifier, String defaultValue) {
        return new Impl<String>(identifier, defaultValue, String.class);
    }

    public static Setting<Integer> create(String identifier, Integer defaultValue) {
        return new Impl<Integer>(identifier, defaultValue, Integer.class);
    }

    public static Setting<Long> create(String identifier, Long defaultValue) {
        return new Impl<Long>(identifier, defaultValue, Long.class);
    }

    public static Setting<Float> create(String identifier, Float defaultValue) {
        return new Impl<Float>(identifier, defaultValue, Float.class);
    }

    public static Setting<Double> create(String identifier, Double defaultValue) {
        return new Impl<Double>(identifier, defaultValue, Double.class);
    }

    public static <V> Setting<V> create(String identifier, Class<V> valueType, V defaultValue) {
        return new Impl(identifier, valueType, defaultValue);
    }

    private static <V, S extends Setting<V>> S clone(S setting, V newValue) {
        try {
            setting.checkValue(newValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid value for key '" + setting.key.identifier + "': " + setting.value, e);
        }
        Setting s = (Setting)setting.clone();
        assert (s.key == setting.key);
        assert (s.getClass().equals(setting.getClass()));
        s.value = newValue;
        return (S)s;
    }

    private static void checkIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier cannot be null");
        }
        if (!identifierPattern.matcher(identifier).matches()) {
            throw new IllegalArgumentException("identifier does not match " + identifierPattern.pattern());
        }
    }

    private static Type lookupValueType(Class<?> rawType, String identifier) {
        HashMap mapping = new HashMap();
        assert (rawType != Setting.class);
        block0: while (true) {
            Type superclass;
            if ((superclass = rawType.getGenericSuperclass()) instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)superclass).getRawType();
                Type[] args = ((ParameterizedType)superclass).getActualTypeArguments();
                if (Setting.class.equals((Object)rawType)) {
                    Type type = args[0];
                    if ((type = mapping.getOrDefault(type, type)) instanceof Class) {
                        if (((Class)type).isArray()) {
                            throw new IllegalArgumentException(identifier + " value class must be immutable");
                        }
                        if (((Class)type).getTypeParameters().length != 0) {
                            throw new IllegalArgumentException(identifier + " setting must fill in type parameters for " + ((Class)type).toGenericString());
                        }
                    } else {
                        if (type instanceof GenericArrayType) {
                            throw new IllegalArgumentException(identifier + " value class must be immutable");
                        }
                        if (type instanceof TypeVariable) {
                            throw new IllegalArgumentException("Invalid setting type 'Key<" + type.getTypeName() + ">' for identifier " + identifier);
                        }
                        if (!(type instanceof ParameterizedType)) {
                            throw new IllegalArgumentException(identifier + " invalid type " + type + " (" + type.getClass().getName() + ")");
                        }
                    }
                    return type;
                }
                TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
                int i = 0;
                int len = vars.length;
                while (true) {
                    if (i >= len) continue block0;
                    Type t = args[i];
                    mapping.put(vars[i], t instanceof TypeVariable ? (Type)mapping.get(t) : t);
                    ++i;
                }
            }
            rawType = (Class)superclass;
            if (Setting.class.equals((Object)rawType)) break;
        }
        throw new IllegalArgumentException(rawType + " does not supply type arguments");
    }

    private static final class Key {
        final String identifier;
        final Type valueType;
        final boolean nonnull;

        Key(String identifier, Type valueType, boolean nonnull) {
            this.identifier = identifier;
            this.valueType = valueType;
            this.nonnull = nonnull;
        }
    }

    private static class Impl<V>
    extends Setting<V> {
        private Impl(String identifier, V defaultValue, Class<V> valueType) {
            super(identifier, defaultValue, valueType);
        }

        private Impl(String identifier, Class<V> valueType, V defaultValue) {
            super(identifier, valueType, defaultValue);
        }
    }
}

