/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.DAG;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityRule
implements Serializable {
    Logger LOG = LoggerFactory.getLogger(AffinityRule.class);
    private static final long serialVersionUID = 107131504929875386L;
    private List<String> operatorsList;
    private String operatorRegex;
    private DAG.Locality locality;
    private Type type;
    private boolean relaxLocality;

    public String toString() {
        return "AffinityRule {operatorsList=" + this.operatorsList + ", operatorRegex=" + this.operatorRegex + ", locality=" + (Object)((Object)this.locality) + ", type=" + (Object)((Object)this.type) + ", relaxLocality=" + this.relaxLocality + "}";
    }

    public AffinityRule() {
    }

    public AffinityRule(Type type, DAG.Locality locality, boolean relaxLocality) {
        this.type = type;
        this.locality = locality;
        this.setRelaxLocality(relaxLocality);
    }

    public AffinityRule(Type type, DAG.Locality locality, boolean relaxLocality, String firstOperator, String ... otherOperators) {
        this(type, locality, relaxLocality);
        LinkedList<String> operators = new LinkedList<String>();
        if (firstOperator != null && otherOperators.length >= 1) {
            operators.add(firstOperator);
            for (String operator : otherOperators) {
                operators.add(operator);
            }
            this.setOperatorsList(operators);
        } else {
            this.LOG.warn("Affinity rule should specify at least two operators to be applied");
        }
    }

    public AffinityRule(Type type, List<String> operatorsList, DAG.Locality locality, boolean relaxLocality) {
        this(type, locality, relaxLocality);
        this.operatorsList = operatorsList;
    }

    public AffinityRule(Type type, String operatorRegex, DAG.Locality locality, boolean relaxLocality) {
        this(type, locality, relaxLocality);
        this.operatorRegex = operatorRegex;
    }

    public DAG.Locality getLocality() {
        return this.locality;
    }

    public void setLocality(DAG.Locality locality) {
        this.locality = locality;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isRelaxLocality() {
        return this.relaxLocality;
    }

    public void setRelaxLocality(boolean relaxLocality) {
        this.relaxLocality = relaxLocality;
    }

    public List<String> getOperatorsList() {
        return this.operatorsList;
    }

    public void setOperatorsList(List<String> operatorsList) {
        this.operatorsList = operatorsList;
    }

    public String getOperatorRegex() {
        return this.operatorRegex;
    }

    public void setOperatorRegex(String operatorRegex) {
        this.operatorRegex = operatorRegex;
    }

    public static enum Type {
        AFFINITY,
        ANTI_AFFINITY;

    }
}

