/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Partitioner;
import com.datatorrent.api.StatsListener;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultPartition<T>
implements Partitioner.Partition<T> {
    private final PartitionPortMap partitionKeys;
    private final T partitionable;
    private final int loadIndicator;
    private final Attribute.AttributeMap attributes = new Attribute.AttributeMap.DefaultAttributeMap();
    private final StatsListener.BatchedOperatorStats stats;

    public DefaultPartition(T partitionable, Map<Operator.InputPort<?>, Partitioner.PartitionKeys> partitionKeys, int loadIndicator, StatsListener.BatchedOperatorStats stats) {
        this.partitionable = partitionable;
        this.partitionKeys = new PartitionPortMap();
        this.partitionKeys.putAll((Map<? extends Operator.InputPort<?>, ? extends Partitioner.PartitionKeys>)partitionKeys);
        this.partitionKeys.modified = false;
        this.loadIndicator = loadIndicator;
        this.stats = stats;
    }

    public DefaultPartition(T partitionable) {
        this(partitionable, new PartitionPortMap(), 0, null);
    }

    @Override
    public Map<Operator.InputPort<?>, Partitioner.PartitionKeys> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public int getLoad() {
        return this.loadIndicator;
    }

    @Override
    public StatsListener.BatchedOperatorStats getStats() {
        return this.stats;
    }

    @Override
    public T getPartitionedInstance() {
        return this.partitionable;
    }

    public boolean isModified() {
        return this.partitionKeys.modified;
    }

    @Override
    public Attribute.AttributeMap getAttributes() {
        return this.attributes;
    }

    public static <T> void assignPartitionKeys(Collection<Partitioner.Partition<T>> partitions, Operator.InputPort<?> inputPort) {
        if (partitions.isEmpty()) {
            throw new IllegalArgumentException("partitions collection cannot be empty");
        }
        int partitionBits = Integer.numberOfLeadingZeros(0) - Integer.numberOfLeadingZeros(partitions.size() - 1);
        int partitionMask = 0;
        if (partitionBits > 0) {
            partitionMask = -1 >>> Integer.numberOfLeadingZeros(-1) - partitionBits;
        }
        Iterator<Partitioner.Partition<T>> iterator = partitions.iterator();
        for (int i = 0; i <= partitionMask; ++i) {
            Partitioner.Partition<T> p;
            if (iterator.hasNext()) {
                p = iterator.next();
            } else {
                iterator = partitions.iterator();
                p = iterator.next();
            }
            Partitioner.PartitionKeys pks = p.getPartitionKeys().get(inputPort);
            if (pks == null) {
                p.getPartitionKeys().put(inputPort, new Partitioner.PartitionKeys(partitionMask, Sets.newHashSet((Object[])new Integer[]{i})));
                continue;
            }
            pks.partitions.add(i);
        }
    }

    public static int getRequiredPartitionCount(Partitioner.PartitioningContext context, int count) {
        return context.getParallelPartitionCount() == 0 ? count : context.getParallelPartitionCount();
    }

    public String toString() {
        return "DefaultPartition{partitionKeys=" + this.partitionKeys + ", operator=" + this.partitionable + ", loadIndicator=" + this.loadIndicator + ", attributes=" + this.attributes + ", stats=" + this.stats + '}';
    }

    public static class PartitionPortMap
    extends HashMap<Operator.InputPort<?>, Partitioner.PartitionKeys> {
        private static final long serialVersionUID = 201212131624L;
        private boolean modified;

        private boolean validateEqual(Partitioner.PartitionKeys collection1, Partitioner.PartitionKeys collection2) {
            if (collection1 == null && collection2 == null) {
                return true;
            }
            if (collection1 == null || collection2 == null) {
                return false;
            }
            if (collection1.mask != collection2.mask) {
                return false;
            }
            if (collection1.partitions.size() != collection2.partitions.size()) {
                return false;
            }
            for (Integer bb : collection1.partitions) {
                if (collection2.partitions.contains(bb)) continue;
                return false;
            }
            return true;
        }

        public boolean isModified() {
            return this.modified;
        }

        @Override
        public Partitioner.PartitionKeys put(Operator.InputPort<?> key, Partitioner.PartitionKeys value) {
            Partitioner.PartitionKeys prev = super.put(key, value);
            if (!this.modified) {
                this.modified = !this.validateEqual(prev, value);
            }
            return prev;
        }

        @Override
        public void putAll(Map<? extends Operator.InputPort<?>, ? extends Partitioner.PartitionKeys> m) {
            for (Map.Entry<Operator.InputPort<?>, Partitioner.PartitionKeys> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Partitioner.PartitionKeys remove(Object key) {
            if (this.containsKey(key)) {
                this.modified = true;
                return (Partitioner.PartitionKeys)super.remove(key);
            }
            return null;
        }

        @Override
        public void clear() {
            if (!this.isEmpty()) {
                this.modified = true;
                super.clear();
            }
        }
    }
}

