/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.api;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.StreamingApplication;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.apex.api.EmbeddedAppLauncher;
import org.apache.apex.api.YarnAppLauncher;
import org.apache.hadoop.conf.Configuration;

public abstract class Launcher<H extends AppHandle> {
    public static final String NEW_INSTANCE_METHOD = "newInstance";

    public static <L extends Launcher<?>> L getLauncher(LaunchMode<L> launchMode) {
        Launcher launcher;
        try {
            Method m = launchMode.clazz.getDeclaredMethod(NEW_INSTANCE_METHOD, new Class[0]);
            launcher = (Launcher)m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            launcher = (Launcher)Launcher.loadService(launchMode.clazz);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return (L)launcher;
    }

    public H launchApp(StreamingApplication application, Configuration configuration) throws LauncherException {
        return this.launchApp(application, configuration, null);
    }

    public abstract H launchApp(StreamingApplication var1, Configuration var2, Attribute.AttributeMap var3) throws LauncherException;

    protected static <T> T loadService(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        Iterator<T> impl = loader.iterator();
        if (!impl.hasNext()) {
            throw new RuntimeException("No implementation for " + clazz);
        }
        return impl.next();
    }

    public static class LauncherException
    extends RuntimeException {
        public LauncherException(String message) {
            super(message);
        }

        public LauncherException(Throwable cause) {
            super(cause);
        }
    }

    public static interface AppHandle {
        public boolean isFinished();

        public void shutdown(ShutdownMode var1) throws LauncherException;
    }

    public static enum ShutdownMode {
        AWAIT_TERMINATION,
        KILL;

    }

    public static class LaunchMode<L extends Launcher> {
        public static final LaunchMode<EmbeddedAppLauncher> EMBEDDED = new LaunchMode<EmbeddedAppLauncher>(EmbeddedAppLauncher.class);
        public static final LaunchMode<YarnAppLauncher> YARN = new LaunchMode<YarnAppLauncher>(YarnAppLauncher.class);
        Class<L> clazz;

        public LaunchMode(Class<L> clazz) {
            this.clazz = clazz;
        }
    }
}

