/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.internal;

import com.datatorrent.bufferserver.internal.DataListener;
import com.datatorrent.bufferserver.internal.LogicalNode;
import com.datatorrent.bufferserver.packet.BeginWindowTuple;
import com.datatorrent.bufferserver.packet.ResetWindowTuple;
import com.datatorrent.bufferserver.packet.Tuple;
import com.datatorrent.bufferserver.storage.Storage;
import com.datatorrent.bufferserver.util.BitVector;
import com.datatorrent.bufferserver.util.Codec;
import com.datatorrent.bufferserver.util.SerializedData;
import com.datatorrent.bufferserver.util.VarInt;
import com.datatorrent.netlet.AbstractClient;
import com.datatorrent.netlet.util.VarInt;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataList {
    private final int MAX_COUNT_OF_INMEM_BLOCKS;
    protected final String identifier;
    private final int blockSize;
    private final HashMap<BitVector, HashSet<DataListener>> listeners = Maps.newHashMap();
    protected final HashSet<DataListener> all_listeners = Sets.newHashSet();
    protected Block first;
    protected Block last;
    protected Storage storage;
    protected ExecutorService autoFlushExecutor;
    protected ExecutorService storageExecutor;
    protected int size;
    protected int processingOffset;
    protected long baseSeconds;
    private final Set<AbstractClient> suspendedClients = Sets.newHashSet();
    private final AtomicInteger numberOfInMemBlockPermits;
    private VarInt.MutableInt nextOffset = new VarInt.MutableInt();
    private Future<?> future;
    private static final Logger logger = LoggerFactory.getLogger(DataList.class);

    public DataList(String identifier, int blockSize, int numberOfCacheBlocks) {
        if (numberOfCacheBlocks < 1) {
            throw new IllegalArgumentException("Invalid number of Data List Memory blocks " + numberOfCacheBlocks);
        }
        this.MAX_COUNT_OF_INMEM_BLOCKS = numberOfCacheBlocks;
        this.numberOfInMemBlockPermits = new AtomicInteger(this.MAX_COUNT_OF_INMEM_BLOCKS - 1);
        this.identifier = identifier;
        this.blockSize = blockSize;
        this.first = this.last = new Block(identifier, blockSize);
    }

    public DataList(String identifier) {
        this(identifier, 0x4000000, 8);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind(int baseSeconds, int windowId) throws IOException {
        long longWindowId = (long)baseSeconds << 32 | (long)windowId;
        logger.debug("Rewinding {} from window ID {} to window ID {}", new Object[]{this, Codec.getStringWindowId(this.last.ending_window), Codec.getStringWindowId(longWindowId)});
        int numberOfInMemBlockRewound = 0;
        DataList dataList = this;
        synchronized (dataList) {
            Block temp = this.first;
            while (temp != null) {
                if (temp.starting_window >= longWindowId || temp.ending_window > longWindowId) {
                    if (temp != this.last) {
                        this.last.refCount.decrementAndGet();
                        this.last = temp;
                        do {
                            temp = temp.next;
                            temp.discard(false);
                            Block block = temp;
                            synchronized (block) {
                                if (temp.refCount.get() != 0) {
                                    logger.debug("Discarded block {} has positive reference count. Listeners: {}", (Object)temp, this.all_listeners);
                                    throw new IllegalStateException("Discarded block " + temp + " has positive reference count!");
                                }
                                if (temp.data != null) {
                                    temp.data = null;
                                    ++numberOfInMemBlockRewound;
                                }
                            }
                        } while (temp.next != null);
                        this.last.next = null;
                        this.last.acquire(true);
                    }
                    this.baseSeconds = this.last.rewind(longWindowId);
                    this.processingOffset = this.last.writingOffset;
                    this.size = 0;
                    break;
                }
                temp = temp.next;
            }
        }
        int numberOfInMemBlockPermits = this.numberOfInMemBlockPermits.addAndGet(numberOfInMemBlockRewound);
        assert (numberOfInMemBlockPermits < this.MAX_COUNT_OF_INMEM_BLOCKS) : "Number of in memory block permits " + numberOfInMemBlockPermits + " exceeded configured maximum " + this.MAX_COUNT_OF_INMEM_BLOCKS + '.';
        this.resumeSuspendedClients(numberOfInMemBlockPermits);
        logger.debug("Discarded {} in memory blocks during rewind. Number of in memory blocks permits {} after rewinding {}.", new Object[]{numberOfInMemBlockRewound, numberOfInMemBlockPermits, this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        logger.debug("Resetting {}", (Object)this);
        this.listeners.clear();
        this.all_listeners.clear();
        DataList dataList = this;
        synchronized (dataList) {
            if (this.storage != null) {
                Block temp = this.first;
                while (temp != this.last) {
                    temp.discard(false);
                    Block block = temp;
                    synchronized (block) {
                        if (temp.refCount.get() != 0) {
                            throw new IllegalStateException("Discarded block " + temp + " not zero reference count!");
                        }
                        temp.data = null;
                        temp = temp.next;
                    }
                }
            }
            this.first = this.last;
        }
        this.numberOfInMemBlockPermits.set(this.MAX_COUNT_OF_INMEM_BLOCKS - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(long windowId) {
        logger.debug("Purging {} from window ID {} to window ID {}", new Object[]{this, Codec.getStringWindowId(this.first.starting_window), Codec.getStringWindowId(windowId)});
        int numberOfInMemBlockPurged = 0;
        DataList dataList = this;
        synchronized (dataList) {
            Block prev = null;
            Block temp = this.first;
            while (temp != null && temp.starting_window <= windowId) {
                if (temp.ending_window > windowId || temp == this.last) {
                    if (prev != null) {
                        this.first = temp;
                    }
                    this.first.purge(windowId);
                    break;
                }
                temp.discard(false);
                Block block = temp;
                synchronized (block) {
                    if (temp.refCount.get() != 0) {
                        logger.debug("Discarded block {} has positive reference count. Listeners: {}", (Object)temp, this.all_listeners);
                        throw new IllegalStateException("Discarded block " + temp + " has positive reference count!");
                    }
                    if (temp.data != null) {
                        temp.data = null;
                        ++numberOfInMemBlockPurged;
                    }
                }
                prev = temp;
                temp = temp.next;
            }
        }
        int numberOfInMemBlockPermits = this.numberOfInMemBlockPermits.addAndGet(numberOfInMemBlockPurged);
        assert (numberOfInMemBlockPermits < this.MAX_COUNT_OF_INMEM_BLOCKS) : "Number of in memory block permits " + numberOfInMemBlockPermits + " exceeded configured maximum " + this.MAX_COUNT_OF_INMEM_BLOCKS + '.';
        this.resumeSuspendedClients(numberOfInMemBlockPermits);
        logger.debug("Discarded {} in memory blocks during purge. Number of in memory blocks permits {} after purging {}. ", new Object[]{numberOfInMemBlockPurged, numberOfInMemBlockPermits, this});
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void flush(int writeOffset) {
        block10: {
            while (true) {
                if (this.size == 0) {
                    this.size = VarInt.read((byte[])this.last.data, (int)this.processingOffset, (int)writeOffset, (VarInt.MutableInt)this.nextOffset);
                    if (this.nextOffset.integer > -5 && this.nextOffset.integer < 1) {
                        if (writeOffset == this.last.data.length) {
                            this.nextOffset.integer = 0;
                            this.processingOffset = 0;
                            this.size = 0;
                        }
                        break block10;
                    }
                    if (this.nextOffset.integer != -5) continue;
                    throw new RuntimeException("problemo!");
                }
                this.processingOffset = this.nextOffset.integer;
                if (this.processingOffset + this.size > writeOffset) break;
                switch (this.last.data[this.processingOffset]) {
                    case 3: {
                        Tuple bwt = Tuple.getTuple(this.last.data, this.processingOffset, this.size);
                        if (this.last.starting_window == -1L) {
                            this.last.ending_window = this.last.starting_window = this.baseSeconds | (long)bwt.getWindowId();
                            break;
                        }
                        this.last.ending_window = this.baseSeconds | (long)bwt.getWindowId();
                        break;
                    }
                    case 2: {
                        Tuple rwt = Tuple.getTuple(this.last.data, this.processingOffset, this.size);
                        this.baseSeconds = (long)rwt.getBaseSeconds() << 32;
                        break;
                    }
                }
                this.processingOffset += this.size;
                this.size = 0;
            }
            if (writeOffset == this.last.data.length) {
                this.nextOffset.integer = 0;
                this.processingOffset = 0;
                this.size = 0;
            }
        }
        this.last.writingOffset = writeOffset;
        this.notifyListeners();
    }

    public void notifyListeners() {
        if (this.future == null || this.future.isDone() || this.future.isCancelled()) {
            this.future = this.autoFlushExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    boolean atLeastOneListenerHasDataToSend = false;
                    for (DataListener dl : DataList.this.all_listeners) {
                        atLeastOneListenerHasDataToSend |= dl.addedData();
                    }
                    if (atLeastOneListenerHasDataToSend) {
                        DataList.this.future = DataList.this.autoFlushExecutor.submit(this);
                    }
                }
            });
        }
    }

    public void setAutoFlushExecutor(ExecutorService es) {
        this.autoFlushExecutor = es;
    }

    public void setSecondaryStorage(Storage storage, ExecutorService es) {
        this.storage = storage;
        this.storageExecutor = es;
    }

    protected DataListIterator getIterator(Block block) {
        return new DataListIterator(block);
    }

    private synchronized Block getNextBlock(Block block) {
        return block.next;
    }

    public DataListIterator newIterator(long windowId) {
        Block temp = this.first;
        while (temp != this.last && temp.starting_window < windowId && temp.ending_window <= windowId) {
            temp = temp.next;
        }
        return this.getIterator(temp);
    }

    public void addDataListener(DataListener dl) {
        this.all_listeners.add(dl);
        ArrayList<BitVector> partitions = new ArrayList<BitVector>();
        if (dl.getPartitions(partitions) > 0) {
            for (BitVector partition : partitions) {
                HashSet<Object> set;
                if (this.listeners.containsKey(partition)) {
                    set = this.listeners.get(partition);
                } else {
                    set = new HashSet();
                    this.listeners.put(partition, set);
                }
                set.add(dl);
            }
        } else {
            HashSet<Object> set;
            if (this.listeners.containsKey(DataListener.NULL_PARTITION)) {
                set = this.listeners.get(DataListener.NULL_PARTITION);
            } else {
                set = new HashSet();
                this.listeners.put(DataListener.NULL_PARTITION, set);
            }
            set.add(dl);
        }
    }

    public void removeDataListener(DataListener dl) {
        ArrayList<BitVector> partitions = new ArrayList<BitVector>();
        if (dl.getPartitions(partitions) > 0) {
            for (BitVector partition : partitions) {
                if (!this.listeners.containsKey(partition)) continue;
                this.listeners.get(partition).remove(dl);
            }
        } else if (this.listeners.containsKey(DataListener.NULL_PARTITION)) {
            this.listeners.get(DataListener.NULL_PARTITION).remove(dl);
        }
        this.all_listeners.remove(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendRead(AbstractClient client) {
        Set<AbstractClient> set = this.suspendedClients;
        synchronized (set) {
            return this.suspendedClients.add(client) && client.suspendReadIfResumed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeSuspendedClients(int numberOfInMemBlockPermits) {
        boolean resumedSuspendedClients = false;
        if (numberOfInMemBlockPermits > 0) {
            Set<AbstractClient> set = this.suspendedClients;
            synchronized (set) {
                for (AbstractClient client : this.suspendedClients) {
                    resumedSuspendedClients |= client.resumeReadIfSuspended();
                }
                this.suspendedClients.clear();
            }
        } else {
            logger.debug("Keeping clients: {} suspended, numberOfInMemBlockPermits={}, Listeners: {}", new Object[]{this.suspendedClients, numberOfInMemBlockPermits, this.all_listeners});
        }
        return resumedSuspendedClients;
    }

    public boolean isMemoryBlockAvailable() {
        return this.storage == null || this.numberOfInMemBlockPermits.get() > 0;
    }

    public byte[] newBuffer(int size) {
        if (size > this.blockSize) {
            logger.error("Tuple size {} exceeds buffer server current block size {}. Please decrease tuple size. Proceeding with allocating larger block that may cause out of memory exception.", (Object)size, (Object)this.blockSize);
            return new byte[size];
        }
        return new byte[this.blockSize];
    }

    public synchronized void addBuffer(byte[] array) {
        int numberOfInMemBlockPermits = this.numberOfInMemBlockPermits.decrementAndGet();
        if (numberOfInMemBlockPermits < 0) {
            logger.warn("Exceeded allowed memory block allocation by {}", (Object)(-numberOfInMemBlockPermits));
        }
        this.last.next = new Block(this.identifier, array, this.last.ending_window, this.last.ending_window);
        this.last.release(false);
        this.last = this.last.next;
    }

    public byte[] getBuffer(long windowId) {
        if (this.last.starting_window == -1L) {
            this.last.starting_window = windowId;
            this.last.ending_window = windowId;
            this.baseSeconds = windowId & 0xFFFFFFFF00000000L;
        }
        return this.last.data;
    }

    public int getPosition() {
        return this.last.writingOffset;
    }

    public Status getStatus() {
        Status status = new Status();
        Block b = this.first;
        HashMap<Block, Integer> indices = new HashMap<Block, Integer>();
        int i = 0;
        while (b != null) {
            indices.put(b, i++);
            b = b.next;
        }
        int oldestBlockIndex = Integer.MAX_VALUE;
        int oldestReadOffset = Integer.MAX_VALUE;
        for (DataListener dl : this.all_listeners) {
            LogicalNode logicalNode = (LogicalNode)dl;
            DataListIterator dli = logicalNode.getIterator();
            Integer index = (Integer)indices.get(dli.da);
            if (index == null) {
                throw new RuntimeException("problemo!");
            }
            if (index < oldestBlockIndex) {
                oldestBlockIndex = index;
                oldestReadOffset = dli.getReadOffset();
                status.slowestConsumer = logicalNode.getIdentifier();
                continue;
            }
            if (index != oldestBlockIndex || dli.getReadOffset() >= oldestReadOffset) continue;
            oldestReadOffset = dli.getReadOffset();
            status.slowestConsumer = logicalNode.getIdentifier();
        }
        b = this.first;
        i = 0;
        while (b != null) {
            status.numBytesAllocated += (long)b.data.length;
            if (oldestBlockIndex == i) {
                status.numBytesWaiting += (long)(b.writingOffset - oldestReadOffset);
            } else if (oldestBlockIndex < i) {
                status.numBytesWaiting += (long)(b.writingOffset - b.readingOffset);
            }
            b = b.next;
            ++i;
        }
        return status;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " {" + this.identifier + '}';
    }

    public class DataListIterator
    implements Iterator<SerializedData>,
    AutoCloseable {
        Block da;
        SerializedData current;
        protected byte[] buffer;
        protected int readOffset;
        VarInt.MutableInt nextOffset = new VarInt.MutableInt();
        int size;

        DataListIterator(Block da) {
            da.acquire(true);
            this.da = da;
            this.buffer = da.data;
            this.readOffset = da.readingOffset;
        }

        public int getBaseSeconds() {
            return this.da == null ? 0 : (int)(this.da.starting_window >> 32);
        }

        public int getReadOffset() {
            return this.readOffset;
        }

        protected boolean switchToNextBlock() {
            Block next = DataList.this.getNextBlock(this.da);
            if (next == null) {
                return false;
            }
            next.acquire(true);
            this.da.release(false);
            this.da = next;
            this.size = 0;
            this.buffer = this.da.data;
            this.readOffset = this.da.readingOffset;
            return true;
        }

        @Override
        public boolean hasNext() {
            while (this.size == 0) {
                this.size = VarInt.read((byte[])this.buffer, (int)this.readOffset, (int)this.da.writingOffset, (VarInt.MutableInt)this.nextOffset);
                if (this.nextOffset.integer > -5 && this.nextOffset.integer < 1) {
                    if (this.da.writingOffset == this.buffer.length && this.switchToNextBlock()) continue;
                    return false;
                }
                if (this.size != -5) continue;
                throw new RuntimeException("problemo!");
            }
            if (this.nextOffset.integer + this.size <= this.da.writingOffset) {
                this.current = new SerializedData(this.buffer, this.readOffset, this.size + this.nextOffset.integer - this.readOffset);
                this.current.dataOffset = this.nextOffset.integer;
                return true;
            }
            if (this.da.writingOffset == this.buffer.length && this.switchToNextBlock()) {
                this.nextOffset.integer = this.da.readingOffset;
                return this.hasNext();
            }
            return false;
        }

        @Override
        public SerializedData next() {
            this.readOffset = this.current.offset + this.current.length;
            this.size = 0;
            return this.current;
        }

        @Override
        public void remove() {
            this.current.buffer[this.current.dataOffset] = 0;
        }

        @Override
        public void close() {
            if (this.da != null) {
                this.da.release(false);
                this.da = null;
                this.buffer = null;
            }
        }

        void rewind(int processingOffset) {
            this.readOffset = processingOffset;
            this.size = 0;
        }

        public String toString() {
            return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "{da=" + this.da + '}';
        }
    }

    public class Block {
        final String identifier;
        byte[] data;
        int readingOffset;
        int writingOffset;
        long starting_window;
        long ending_window;
        int uniqueIdentifier;
        Block next;
        private final AtomicInteger refCount;
        private Future<?> future;

        public Block(String id, int size) {
            this(id, new byte[size]);
        }

        public Block(String id, byte[] array) {
            this(id, array, -1L, 0L);
        }

        public Block(String id, byte[] array, long starting_window, long ending_window) {
            this.identifier = id;
            this.data = array;
            this.refCount = new AtomicInteger(1);
            this.starting_window = starting_window;
            this.ending_window = ending_window;
        }

        void getNextData(SerializedData current) {
            if (current.offset < this.writingOffset) {
                VarInt.read(current);
                if (current.offset + current.length > this.writingOffset) {
                    current.length = 0;
                }
            } else {
                current.length = 0;
            }
        }

        /*
         * Unable to fully structure code
         */
        public long rewind(long windowId) {
            block22: {
                bs = this.starting_window & 0x7FFFFFFF00000000L;
                dli = DataList.this.getIterator(this);
                var6_4 = null;
                try {
                    block13: while (dli.hasNext()) {
                        sd = dli.next();
                        length = sd.length - sd.dataOffset + sd.offset;
                        switch (sd.buffer[sd.dataOffset]) {
                            case 2: {
                                rwt = (ResetWindowTuple)Tuple.getTuple(sd.buffer, sd.dataOffset, length);
                                bs = (long)rwt.getBaseSeconds() << 32;
                                if (bs > windowId) {
                                    this.writingOffset = sd.offset;
                                    ** break;
lbl15:
                                    // 1 sources

                                    break block22;
                                }
                                ** GOTO lbl23
                            }
                            case 3: {
                                bwt = (BeginWindowTuple)Tuple.getTuple(sd.buffer, sd.dataOffset, length);
                                if ((bs | (long)bwt.getWindowId()) >= windowId) {
                                    this.writingOffset = sd.offset;
                                    ** break;
lbl22:
                                    // 1 sources

                                    break block22;
                                }
                            }
lbl23:
                            // 4 sources

                            default: {
                                continue block13;
                            }
                        }
                    }
                }
                catch (Throwable var7_7) {
                    var6_4 = var7_7;
                    throw var7_7;
                }
                finally {
                    if (dli != null) {
                        if (var6_4 != null) {
                            try {
                                dli.close();
                            }
                            catch (Throwable x2) {
                                var6_4.addSuppressed(x2);
                            }
                        } else {
                            dli.close();
                        }
                    }
                }
            }
            if (this.starting_window == -1L) {
                this.starting_window = windowId;
                this.ending_window = windowId;
            } else if (windowId < this.ending_window) {
                this.ending_window = windowId;
            }
            this.discard(false);
            return bs;
        }

        /*
         * Unable to fully structure code
         */
        public void purge(long longWindowId) {
            block27: {
                found = false;
                bs = this.starting_window & -4294967296L;
                lastReset = null;
                dli = DataList.this.getIterator(this);
                var8_6 = null;
                try {
                    block13: while (dli.hasNext()) {
                        sd = dli.next();
                        length = sd.length - sd.dataOffset + sd.offset;
                        switch (sd.buffer[sd.dataOffset]) {
                            case 2: {
                                rwt = (ResetWindowTuple)Tuple.getTuple(sd.buffer, sd.dataOffset, length);
                                bs = (long)rwt.getBaseSeconds() << 32;
                                lastReset = sd;
                                ** GOTO lbl29
                            }
                            case 3: {
                                bwt = (BeginWindowTuple)Tuple.getTuple(sd.buffer, sd.dataOffset, length);
                                if ((bs | (long)bwt.getWindowId()) > longWindowId) {
                                    found = true;
                                    if (lastReset != null) {
                                        if (sd.offset >= lastReset.length) {
                                            sd.offset -= lastReset.length;
                                            if (sd.buffer != lastReset.buffer || sd.offset != lastReset.offset) {
                                                System.arraycopy(lastReset.buffer, lastReset.offset, sd.buffer, sd.offset, lastReset.length);
                                            }
                                        }
                                        this.starting_window = bs | (long)bwt.getWindowId();
                                        this.readingOffset = sd.offset;
                                        ** break;
                                    }
lbl28:
                                    // 3 sources

                                    break block27;
                                }
                            }
lbl29:
                            // 4 sources

                            default: {
                                continue block13;
                            }
                        }
                    }
                }
                catch (Throwable var9_10) {
                    var8_6 = var9_10;
                    throw var9_10;
                }
                finally {
                    if (dli != null) {
                        if (var8_6 != null) {
                            try {
                                dli.close();
                            }
                            catch (Throwable x2) {
                                var8_6.addSuppressed(x2);
                            }
                        } else {
                            dli.close();
                        }
                    }
                }
            }
            if (!found) {
                if (lastReset != null && lastReset.offset != 0) {
                    this.readingOffset = this.writingOffset - lastReset.length;
                    System.arraycopy(lastReset.buffer, lastReset.offset, this.data, this.readingOffset, lastReset.length);
                    this.starting_window = this.ending_window = bs;
                } else {
                    this.readingOffset = this.writingOffset;
                    this.starting_window = this.ending_window = longWindowId;
                }
                sd = new SerializedData(this.data, this.readingOffset, 0);
                for (i = 1; i < VarInt.getSize((int)(sd.offset - i)); ++i) {
                }
                if (i <= sd.offset) {
                    sd.length = sd.offset;
                    sd.offset = 0;
                    sd.dataOffset = VarInt.write((int)(sd.length - i), (byte[])sd.buffer, (int)sd.offset, (int)i);
                    sd.buffer[sd.dataOffset] = 0;
                } else {
                    DataList.access$200().warn("Unhandled condition while purging the data purge to offset {}", (Object)sd.offset);
                }
                this.discard(false);
            }
        }

        private Runnable getRetriever() {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    byte[] data = DataList.this.storage.retrieve(Block.this.identifier, Block.this.uniqueIdentifier);
                    Block block = Block.this;
                    synchronized (block) {
                        if (Block.this.data == null) {
                            Block.this.data = data;
                            Block.this.readingOffset = 0;
                            Block.this.writingOffset = data.length;
                            Block.this.notifyAll();
                            int numberOfInMemBlockPermits = DataList.this.numberOfInMemBlockPermits.decrementAndGet();
                            if (numberOfInMemBlockPermits < 0) {
                                logger.warn("Exceeded allowed memory block allocation by {}", (Object)(-numberOfInMemBlockPermits));
                            }
                        } else {
                            logger.debug("Block {} was already loaded into memory", (Object)Block.this);
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acquire(boolean wait) {
            Object retriever;
            int refCount = this.refCount.getAndIncrement();
            Block block = this;
            synchronized (block) {
                if (this.data != null) {
                    return;
                }
            }
            if (refCount == 0 && DataList.this.storage != null) {
                retriever = this.getRetriever();
                if (this.future != null && this.future.cancel(false)) {
                    logger.debug("Block {} future is cancelled", (Object)this);
                }
                if (wait) {
                    this.future = null;
                    retriever.run();
                } else {
                    this.future = DataList.this.storageExecutor.submit((Runnable)retriever);
                }
            } else if (wait) {
                try {
                    retriever = this;
                    synchronized (retriever) {
                        if (this.future == null) {
                            throw new IllegalStateException("No task is scheduled to retrieve block " + this);
                        }
                        while (this.data == null) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("Interrupted while waiting for data to be loaded!", ex);
                }
            }
        }

        private Runnable getStorer(final byte[] data, final int readingOffset, final int writingOffset, final Storage storage) {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Block.this.uniqueIdentifier == 0) {
                        Block.this.uniqueIdentifier = storage.store(Block.this.identifier, data, readingOffset, writingOffset);
                    }
                    if (Block.this.uniqueIdentifier == 0) {
                        logger.warn("Storage returned unexpectedly, please check the status of the spool directory!");
                    } else {
                        int numberOfInMemBlockPermits = DataList.this.numberOfInMemBlockPermits.get();
                        Block block = Block.this;
                        synchronized (block) {
                            if (Block.this.refCount.get() == 0 && Block.this.data != null) {
                                Block.this.data = null;
                                numberOfInMemBlockPermits = DataList.this.numberOfInMemBlockPermits.incrementAndGet();
                            } else {
                                logger.debug("Keeping Block {} unchanged", (Object)Block.this);
                            }
                        }
                        assert (numberOfInMemBlockPermits < DataList.this.MAX_COUNT_OF_INMEM_BLOCKS) : "Number of in memory block permits " + numberOfInMemBlockPermits + " exceeded configured maximum " + DataList.access$400(DataList.this) + '.';
                        DataList.this.resumeSuspendedClients(numberOfInMemBlockPermits);
                    }
                }
            };
        }

        protected void release(boolean wait) {
            int refCount = this.refCount.decrementAndGet();
            if (refCount == 0 && DataList.this.storage != null) {
                assert (this.next != null);
                Runnable storer = this.getStorer(this.data, this.readingOffset, this.writingOffset, DataList.this.storage);
                if (this.future != null && this.future.cancel(false)) {
                    logger.debug("Block {} future is cancelled", (Object)this);
                }
                int numberOfInMemBlockPermits = DataList.this.numberOfInMemBlockPermits.get();
                if (wait && numberOfInMemBlockPermits == 0) {
                    this.future = null;
                    storer.run();
                } else {
                    this.future = numberOfInMemBlockPermits < DataList.this.MAX_COUNT_OF_INMEM_BLOCKS / 2 ? DataList.this.storageExecutor.submit(storer) : null;
                }
            } else {
                logger.debug("Holding {} in memory due to {} references.", (Object)this, (Object)refCount);
            }
        }

        private Runnable getDiscarder() {
            return new Runnable(){

                @Override
                public void run() {
                    if (Block.this.uniqueIdentifier > 0) {
                        logger.debug("Discarding {}", (Object)Block.this);
                        DataList.this.storage.discard(Block.this.identifier, Block.this.uniqueIdentifier);
                        Block.this.uniqueIdentifier = 0;
                    }
                }
            };
        }

        protected void discard(boolean wait) {
            if (DataList.this.storage != null) {
                Runnable discarder = this.getDiscarder();
                if (this.future != null && this.future.cancel(false)) {
                    logger.debug("Block {} future is cancelled", (Object)this);
                }
                if (wait) {
                    this.future = null;
                    discarder.run();
                } else {
                    this.future = DataList.this.storageExecutor.submit(discarder);
                }
            }
        }

        public String toString() {
            String future = this.future == null ? "null" : (this.future.isDone() ? "Done" : (this.future.isCancelled() ? "Cancelled" : this.future.toString()));
            return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "{identifier=" + this.identifier + ", data=" + (this.data == null ? "null" : Integer.valueOf(this.data.length)) + ", readingOffset=" + this.readingOffset + ", writingOffset=" + this.writingOffset + ", starting_window=" + Codec.getStringWindowId(this.starting_window) + ", ending_window=" + Codec.getStringWindowId(this.ending_window) + ", refCount=" + this.refCount.get() + ", uniqueIdentifier=" + this.uniqueIdentifier + ", next=" + (this.next == null ? "null" : this.next.identifier) + ", future=" + future + '}';
        }
    }

    public static class Status {
        public long numBytesWaiting = 0L;
        public long numBytesAllocated = 0L;
        public String slowestConsumer;
    }
}

