/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.internal;

import com.datatorrent.bufferserver.internal.DataList;
import com.datatorrent.bufferserver.packet.Tuple;
import com.datatorrent.bufferserver.util.SerializedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDataList
extends DataList {
    long item;
    private static final Logger logger = LoggerFactory.getLogger(FastDataList.class);

    public FastDataList(String identifier) {
        super(identifier);
    }

    public FastDataList(String identifier, int blocksize, int numberOfCacheBlocks) {
        super(identifier, blocksize, numberOfCacheBlocks);
    }

    @Override
    public void flush(int writeOffset) {
        block10: {
            while (true) {
                if (this.size == 0) {
                    if (writeOffset - this.processingOffset >= 2) {
                        this.size = this.last.data[this.processingOffset];
                        this.size |= this.last.data[this.processingOffset + 1] << 8;
                        continue;
                    }
                    if (writeOffset == this.last.data.length) {
                        this.processingOffset = 0;
                        this.size = 0;
                    }
                    break block10;
                }
                this.processingOffset += 2;
                if (this.processingOffset + this.size > writeOffset) break;
                switch (this.last.data[this.processingOffset]) {
                    case 3: {
                        Tuple btw = Tuple.getTuple(this.last.data, this.processingOffset, this.size);
                        if (this.last.starting_window == -1L) {
                            this.last.ending_window = this.last.starting_window = this.baseSeconds | (long)btw.getWindowId();
                            break;
                        }
                        this.last.ending_window = this.baseSeconds | (long)btw.getWindowId();
                        break;
                    }
                    case 2: {
                        Tuple rwt = Tuple.getTuple(this.last.data, this.processingOffset, this.size);
                        this.baseSeconds = (long)rwt.getBaseSeconds() << 32;
                        break;
                    }
                }
                this.processingOffset += this.size;
                this.size = 0;
            }
            if (writeOffset == this.last.data.length) {
                this.processingOffset = 0;
                this.size = 0;
            }
        }
        this.last.writingOffset = writeOffset;
        this.notifyListeners();
    }

    @Override
    protected FastDataListIterator getIterator(DataList.Block block) {
        return new FastDataListIterator(block);
    }

    protected class FastDataListIterator
    extends DataList.DataListIterator {
        FastDataListIterator(DataList.Block da) {
            super(FastDataList.this, da);
        }

        @Override
        public boolean hasNext() {
            while (this.size == 0) {
                if (this.da.writingOffset - this.readOffset >= 2) {
                    this.size = this.buffer[this.readOffset];
                    this.size |= this.buffer[this.readOffset + 1] << 8;
                    continue;
                }
                if (this.da.writingOffset == this.buffer.length && this.switchToNextBlock()) continue;
                return false;
            }
            if (this.readOffset + this.size + 2 <= this.da.writingOffset) {
                this.current = new SerializedData(this.buffer, this.readOffset, this.size + 2);
                this.current.dataOffset = this.readOffset + 2;
                return true;
            }
            if (this.da.writingOffset == this.buffer.length) {
                if (!this.switchToNextBlock()) {
                    return false;
                }
                this.nextOffset.integer = this.da.readingOffset;
                return this.hasNext();
            }
            return false;
        }
    }
}

