/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.packet;

import com.datatorrent.bufferserver.packet.BeginWindowTuple;
import com.datatorrent.bufferserver.packet.DataTuple;
import com.datatorrent.bufferserver.packet.EndWindowTuple;
import com.datatorrent.bufferserver.packet.MessageType;
import com.datatorrent.bufferserver.packet.NoMessageTuple;
import com.datatorrent.bufferserver.packet.PayloadTuple;
import com.datatorrent.bufferserver.packet.PublishRequestTuple;
import com.datatorrent.bufferserver.packet.PurgeRequestTuple;
import com.datatorrent.bufferserver.packet.ResetRequestTuple;
import com.datatorrent.bufferserver.packet.ResetWindowTuple;
import com.datatorrent.bufferserver.packet.SubscribeRequestTuple;
import com.datatorrent.bufferserver.packet.WindowIdTuple;
import com.datatorrent.netlet.util.Slice;
import com.datatorrent.netlet.util.VarInt;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tuple {
    public static final String CLASSIC_VERSION = "1.0";
    public static final String FAST_VERSION = "1.1";
    public final byte[] buffer;
    public final int offset;
    public final int length;
    private static final Logger logger = LoggerFactory.getLogger(Tuple.class);

    public Tuple(byte[] array, int offset, int length) {
        this.buffer = array;
        this.offset = offset;
        this.length = length;
    }

    public static Tuple getTuple(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            logger.debug("found null buffer!");
        }
        switch (MessageType.valueOf(buffer[offset])) {
            case NO_MESSAGE: {
                return new NoMessageTuple(buffer, offset, length);
            }
            case CHECKPOINT: {
                return new WindowIdTuple(buffer, offset, length);
            }
            case CODEC_STATE: {
                return new DataTuple(buffer, offset, length);
            }
            case PAYLOAD: {
                return new PayloadTuple(buffer, offset, length);
            }
            case RESET_WINDOW: {
                return new ResetWindowTuple(buffer, offset, length);
            }
            case BEGIN_WINDOW: {
                return new BeginWindowTuple(buffer, offset, length);
            }
            case END_WINDOW: {
                return new EndWindowTuple(buffer, offset, length);
            }
            case END_STREAM: {
                return new WindowIdTuple(buffer, offset, length);
            }
            case PUBLISHER_REQUEST: {
                PublishRequestTuple prt = new PublishRequestTuple(buffer, offset, length);
                prt.parse();
                if (!prt.isValid()) {
                    logger.error("Unparseable Generic Request Tuple of type {} received!", (Object)MessageType.valueOf(buffer[offset]));
                }
                return prt;
            }
            case PURGE_REQUEST: {
                PurgeRequestTuple purgert = new PurgeRequestTuple(buffer, offset, length);
                purgert.parse();
                if (!purgert.isValid()) {
                    logger.error("Unparseable Purge Request Tuple of type {} received!", (Object)MessageType.valueOf(buffer[offset]));
                }
                return purgert;
            }
            case RESET_REQUEST: {
                ResetRequestTuple resetrt = new ResetRequestTuple(buffer, offset, length);
                resetrt.parse();
                if (!resetrt.isValid()) {
                    logger.error("Unparseable Reset Request Tuple of type {} received!", (Object)MessageType.valueOf(buffer[offset]));
                }
                return resetrt;
            }
            case SUBSCRIBER_REQUEST: {
                SubscribeRequestTuple srt = new SubscribeRequestTuple(buffer, offset, length);
                srt.parse();
                if (!srt.isValid()) {
                    logger.error("Unparseable Subscriber Request Tuple received!");
                }
                return srt;
            }
        }
        return null;
    }

    public static int writeString(String identifier, byte[] array, int offset) {
        offset = VarInt.write((int)identifier.getBytes().length, (byte[])array, (int)offset);
        System.arraycopy(identifier.getBytes(), 0, array, offset, identifier.getBytes().length);
        return offset + identifier.getBytes().length;
    }

    public int readVarInt(int offset, int limit) {
        if (offset < limit) {
            byte tmp;
            if ((tmp = this.buffer[offset++]) >= 0) {
                return tmp;
            }
            if (offset < limit) {
                int integer = tmp & 0x7F;
                if ((tmp = this.buffer[offset++]) >= 0) {
                    return integer | tmp << 7;
                }
                if (offset < limit) {
                    integer |= (tmp & 0x7F) << 7;
                    if ((tmp = this.buffer[offset++]) >= 0) {
                        return integer | tmp << 14;
                    }
                    if (offset < limit) {
                        integer |= (tmp & 0x7F) << 14;
                        if ((tmp = this.buffer[offset++]) >= 0) {
                            return integer | tmp << 21;
                        }
                        if (offset < limit) {
                            integer |= (tmp & 0x7F) << 21;
                            if ((tmp = this.buffer[offset++]) >= 0) {
                                return integer | tmp << 28;
                            }
                            throw new NumberFormatException("Invalid varint at location " + offset + " => " + Arrays.toString(Arrays.copyOfRange(this.buffer, offset, limit)));
                        }
                    }
                }
            }
        }
        throw new NumberFormatException("Invalid varint at location " + offset + " => " + Arrays.toString(Arrays.copyOfRange(this.buffer, offset, limit)));
    }

    public MessageType getType() {
        return MessageType.valueOf(this.buffer[this.offset]);
    }

    public abstract int getWindowId();

    public abstract int getPartition();

    public abstract Slice getData();

    public abstract int getBaseSeconds();

    public abstract int getWindowWidth();
}

