/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.storage;

import com.datatorrent.bufferserver.storage.Storage;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStorage
implements Storage {
    private static final Logger logger = LoggerFactory.getLogger(DiskStorage.class);
    final String basePath;
    int uniqueIdentifier;

    public DiskStorage(String baseDirectory) {
        this.basePath = baseDirectory;
        logger.info("Using {} as the basepath for spooling.", (Object)this.basePath);
    }

    public DiskStorage() throws IOException {
        File tempFile = File.createTempFile("msp", "msp");
        this.basePath = tempFile.getParent();
        tempFile.delete();
        logger.info("using {} as the basepath for spooling.", (Object)this.basePath);
    }

    @Override
    public Storage getInstance() throws IOException {
        return new DiskStorage(this.basePath);
    }

    public static String normalizeFileName(String name) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < name.length(); ++i) {
            Character c = Character.valueOf(name.charAt(i));
            if (Character.isLetterOrDigit(c.charValue())) {
                sb.append(c);
                continue;
            }
            sb.append('-');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int store(String identifier, byte[] bytes, int startingOffset, int endingOffset) {
        int lUniqueIdentifier;
        File directory;
        block14: {
            String normalizedFileName = DiskStorage.normalizeFileName(identifier);
            directory = new File(this.basePath, normalizedFileName);
            if (directory.exists()) {
                File identityFile = new File(directory, "identity");
                if (identityFile.isFile()) {
                    try {
                        byte[] stored = Files.toByteArray((File)identityFile);
                        if (Arrays.equals(stored, identifier.getBytes())) {
                            DiskStorage diskStorage = this;
                            synchronized (diskStorage) {
                                lUniqueIdentifier = ++this.uniqueIdentifier;
                                break block14;
                            }
                        }
                        throw new IllegalStateException("Collision in identifier name, please ensure that the slug for the identifiers is different");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                throw new IllegalStateException("Identity file is hijacked!");
            }
            if (directory.mkdir()) {
                File identity = new File(directory, "identity");
                try {
                    Files.write((byte[])identifier.getBytes(), (File)identity);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                throw new RuntimeException("directory " + directory.getAbsolutePath() + " could not be created!");
            }
            lUniqueIdentifier = ++this.uniqueIdentifier;
        }
        try {
            return this.writeFile(bytes, startingOffset, endingOffset, directory, lUniqueIdentifier);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void discard(String identifier, int uniqueIdentifier) {
        block7: {
            String normalizedFilename = DiskStorage.normalizeFileName(identifier);
            File directory = new File(this.basePath, normalizedFilename);
            if (directory.exists()) {
                File identityFile = new File(directory, "identity");
                if (identityFile.isFile()) {
                    try {
                        byte[] stored = Files.toByteArray((File)identityFile);
                        if (Arrays.equals(stored, identifier.getBytes())) {
                            File deletionFile = new File(directory, String.valueOf(uniqueIdentifier));
                            if (deletionFile.exists() && deletionFile.isFile()) {
                                if (!deletionFile.delete()) {
                                    throw new RuntimeException("File " + deletionFile.getPath() + " could not be deleted!");
                                }
                                break block7;
                            }
                            throw new RuntimeException("File " + deletionFile.getPath() + " either is non existent or not a file!");
                        }
                        throw new RuntimeException("Collision in the identifier name, please ensure that the slugs for the identifiers are different");
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                throw new RuntimeException(identityFile + " is not a file!");
            }
            throw new RuntimeException("directory " + directory.getPath() + " does not exist!");
        }
    }

    @Override
    public byte[] retrieve(String identifier, int uniqueIdentifier) {
        String normalizedFilename = DiskStorage.normalizeFileName(identifier);
        File directory = new File(this.basePath, normalizedFilename);
        if (directory.exists()) {
            File identityFile = new File(directory, "identity");
            if (identityFile.isFile()) {
                try {
                    byte[] stored = Files.toByteArray((File)identityFile);
                    if (Arrays.equals(stored, identifier.getBytes())) {
                        File filename = new File(directory, String.valueOf(uniqueIdentifier));
                        if (filename.exists() && filename.isFile()) {
                            return Files.toByteArray((File)filename);
                        }
                        throw new RuntimeException("File " + filename.getPath() + " either is non existent or not a file!");
                    }
                    throw new RuntimeException("Collision in the identifier name, please ensure that the slugs for the identifiers [" + identifier + "], and [" + new String(stored) + "] are different.");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            throw new RuntimeException(identityFile + " is not a file!");
        }
        throw new RuntimeException("directory " + directory.getPath() + " does not exist!");
    }

    protected int writeFile(byte[] bytes, int startingOffset, int endingOffset, File directory, int number) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(new File(directory, String.valueOf(number)));){
            stream.write(bytes, startingOffset, endingOffset - startingOffset);
        }
        return number;
    }
}

