/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.security.auth.callback;

import com.datatorrent.api.Component;
import com.datatorrent.common.security.SecurityContext;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCallbackHandler
implements CallbackHandler,
Component<SecurityContext> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCallbackHandler.class);
    protected SecurityContext context;

    public void setup(SecurityContext context) {
        this.context = context;
    }

    public void teardown() {
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            this.processCallback(callback);
        }
    }

    protected void processCallback(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof NameCallback) {
            NameCallback namecb = (NameCallback)callback;
            namecb.setName((String)this.context.getValue(SecurityContext.USER_NAME));
        } else if (callback instanceof PasswordCallback) {
            PasswordCallback passcb = (PasswordCallback)callback;
            passcb.setPassword((char[])this.context.getValue(SecurityContext.PASSWORD));
        } else if (callback instanceof RealmCallback) {
            RealmCallback realmcb = (RealmCallback)callback;
            realmcb.setText((String)this.context.getValue(SecurityContext.REALM));
        } else if (callback instanceof TextOutputCallback) {
            TextOutputCallback textcb = (TextOutputCallback)callback;
            if (textcb.getMessageType() == 0) {
                logger.info(textcb.getMessage());
            } else if (textcb.getMessageType() == 1) {
                logger.warn(textcb.getMessage());
            } else if (textcb.getMessageType() == 2) {
                logger.error(textcb.getMessage());
            } else {
                logger.debug("Auth message type {}, message {}", (Object)textcb.getMessageType(), (Object)textcb.getMessage());
            }
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

