/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import com.datatorrent.common.util.ObjectMapperString;
import java.io.IOException;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.RawSerializer;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

@Provider
@Produces(value={"application/json"})
public class JacksonObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper objectMapper;
    private final SimpleModule module = new SimpleModule("MyModule", new Version(1, 0, 0, null));

    public JacksonObjectMapperProvider() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        this.objectMapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.module.addSerializer(ObjectMapperString.class, (JsonSerializer)new RawSerializer(Object.class));
        this.module.addSerializer(JSONObject.class, (JsonSerializer)new RawSerializer(Object.class));
        this.module.addSerializer(JSONArray.class, (JsonSerializer)new RawSerializer(Object.class));
        this.objectMapper.registerModule((Module)this.module);
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }

    public <T> void addSerializer(Class<T> clazz, JsonSerializer<T> serializer) {
        this.module.addSerializer(clazz, serializer);
    }

    public <T> void addSerializer(JsonSerializer<T> serializer) {
        this.module.addSerializer(serializer);
    }

    public JSONObject toJSONObject(Object o) {
        try {
            return new JSONObject(this.getContext(null).writeValueAsString(o));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T fromJSONObject(JSONObject json, Class<T> clazz) throws IOException {
        return (T)this.getContext(null).readValue(json.toString(), clazz);
    }
}

