/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import com.datatorrent.common.util.PubSubMessage;
import java.io.IOException;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;

public class PubSubMessageCodec<T> {
    private final ObjectMapper mapper;

    public PubSubMessageCodec(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static <T> String constructPublishMessage(String topic, T data, PubSubMessageCodec<T> codec) throws IOException {
        PubSubMessage<T> pubSubMessage = new PubSubMessage<T>();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.PUBLISH);
        pubSubMessage.setTopic(topic);
        pubSubMessage.setData(data);
        return codec.formatMessage(pubSubMessage);
    }

    public static <T> String constructSubscribeMessage(String topic, PubSubMessageCodec<T> codec) throws IOException {
        PubSubMessage pubSubMessage = new PubSubMessage();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.SUBSCRIBE);
        pubSubMessage.setTopic(topic);
        return codec.formatMessage(pubSubMessage);
    }

    public static <T> String constructUnsubscribeMessage(String topic, PubSubMessageCodec<T> codec) throws IOException {
        PubSubMessage pubSubMessage = new PubSubMessage();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.UNSUBSCRIBE);
        pubSubMessage.setTopic(topic);
        return codec.formatMessage(pubSubMessage);
    }

    public static <T> String constructSubscribeNumSubscribersMessage(String topic, PubSubMessageCodec<T> codec) throws IOException {
        PubSubMessage pubSubMessage = new PubSubMessage();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.SUBSCRIBE_NUM_SUBSCRIBERS);
        pubSubMessage.setTopic(topic);
        return codec.formatMessage(pubSubMessage);
    }

    public static <T> String constructUnsubscribeNumSubscribersMessage(String topic, PubSubMessageCodec<T> codec) throws IOException {
        PubSubMessage pubSubMessage = new PubSubMessage();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.UNSUBSCRIBE_NUM_SUBSCRIBERS);
        pubSubMessage.setTopic(topic);
        return codec.formatMessage(pubSubMessage);
    }

    public String formatMessage(PubSubMessage<T> pubSubMessage) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", pubSubMessage.getType().getIdentifier());
        map.put("topic", pubSubMessage.getTopic());
        T data = pubSubMessage.getData();
        if (data != null) {
            map.put("data", (String)data);
        }
        return this.mapper.writeValueAsString(map);
    }

    public PubSubMessage<T> parseMessage(String message) throws IOException {
        HashMap map = (HashMap)this.mapper.readValue(message, HashMap.class);
        PubSubMessage pubSubMessage = new PubSubMessage();
        pubSubMessage.setType(PubSubMessage.PubSubMessageType.getPubSubMessageType((String)map.get("type")));
        pubSubMessage.setTopic((String)map.get("topic"));
        pubSubMessage.setData(map.get("data"));
        return pubSubMessage;
    }
}

