/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.stram.ResourceRequestHandler;
import com.datatorrent.stram.StreamingContainerAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistBasedResourceRequestHandler
extends ResourceRequestHandler {
    HashMap<AMRMClient.ContainerRequest, StreamingContainerAgent.ContainerStartRequest> hostSpecificRequests = new HashMap();
    HashMap<AMRMClient.ContainerRequest, StreamingContainerAgent.ContainerStartRequest> otherContainerRequests = new HashMap();
    HashMap<String, List<AMRMClient.ContainerRequest>> hostSpecificRequestsMap = new HashMap();
    List<String> blacklistedNodesForHostSpecificRequests = null;
    private static final Logger LOG = LoggerFactory.getLogger(BlacklistBasedResourceRequestHandler.class);

    @Override
    public void reissueContainerRequests(AMRMClient<AMRMClient.ContainerRequest> amRmClient, Map<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> requestedResources, int loopCounter, ResourceRequestHandler resourceRequestor, List<AMRMClient.ContainerRequest> containerRequests, List<AMRMClient.ContainerRequest> removedContainerRequests) {
        if (!this.hostSpecificRequestsMap.isEmpty() && requestedResources.isEmpty()) {
            LOG.info("Issue Host specific requests first");
            Map.Entry<String, List<AMRMClient.ContainerRequest>> set = this.hostSpecificRequestsMap.entrySet().iterator().next();
            List<AMRMClient.ContainerRequest> requests = set.getValue();
            List<String> blacklistNodes = resourceRequestor.getNodesExceptHost(requests.get(0).getNodes());
            amRmClient.updateBlacklist(blacklistNodes, requests.get(0).getNodes());
            this.blacklistedNodesForHostSpecificRequests = blacklistNodes;
            LOG.info("Sending {} request(s) after blacklisting all nodes other than {}", (Object)requests.size(), (Object)requests.get(0).getNodes());
            for (AMRMClient.ContainerRequest cr : requests) {
                StreamingContainerAgent.ContainerStartRequest csr = this.hostSpecificRequests.get(cr);
                AMRMClient.ContainerRequest newCr = new AMRMClient.ContainerRequest(cr.getCapability(), null, null, cr.getPriority());
                MutablePair pair = new MutablePair((Object)loopCounter, (Object)newCr);
                requestedResources.put(csr, (MutablePair<Integer, AMRMClient.ContainerRequest>)pair);
                containerRequests.add(newCr);
                this.hostSpecificRequests.remove(cr);
            }
            this.hostSpecificRequestsMap.remove(set.getKey());
        } else if (!requestedResources.isEmpty()) {
            this.recreateContainerRequest(requestedResources, loopCounter, resourceRequestor, removedContainerRequests);
        } else {
            if (this.blacklistedNodesForHostSpecificRequests != null) {
                LOG.debug("All requests done.. Removing nodes from blacklist {}", this.blacklistedNodesForHostSpecificRequests);
                amRmClient.updateBlacklist(null, this.blacklistedNodesForHostSpecificRequests);
                this.blacklistedNodesForHostSpecificRequests = null;
            }
            if (!this.otherContainerRequests.isEmpty()) {
                for (Map.Entry<AMRMClient.ContainerRequest, StreamingContainerAgent.ContainerStartRequest> entry : this.otherContainerRequests.entrySet()) {
                    AMRMClient.ContainerRequest cr = entry.getKey();
                    StreamingContainerAgent.ContainerStartRequest csr = entry.getValue();
                    MutablePair pair = new MutablePair((Object)loopCounter, (Object)cr);
                    requestedResources.put(csr, (MutablePair<Integer, AMRMClient.ContainerRequest>)pair);
                    containerRequests.add(cr);
                }
                this.otherContainerRequests.clear();
            }
        }
    }

    public void recreateContainerRequest(Map<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> requestedResources, int loopCounter, ResourceRequestHandler resourceRequestor, List<AMRMClient.ContainerRequest> removedContainerRequests) {
        for (Map.Entry<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> entry : requestedResources.entrySet()) {
            if (loopCounter - (Integer)entry.getValue().getKey() <= 30) continue;
            StreamingContainerAgent.ContainerStartRequest csr = entry.getKey();
            removedContainerRequests.add((AMRMClient.ContainerRequest)entry.getValue().getRight());
            AMRMClient.ContainerRequest cr = resourceRequestor.createContainerRequest(csr, false);
            if (cr.getNodes() != null && !cr.getNodes().isEmpty()) {
                this.addHostSpecificRequest(csr, cr);
                continue;
            }
            this.otherContainerRequests.put(cr, csr);
        }
    }

    @Override
    public void addContainerRequest(Map<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> requestedResources, int loopCounter, List<AMRMClient.ContainerRequest> containerRequests, StreamingContainerAgent.ContainerStartRequest csr, AMRMClient.ContainerRequest cr) {
        if (cr.getNodes() != null && !cr.getNodes().isEmpty()) {
            this.addHostSpecificRequest(csr, cr);
        } else {
            LOG.info("No node specific request ", (Object)cr);
            this.otherContainerRequests.put(cr, csr);
        }
    }

    public void addHostSpecificRequest(StreamingContainerAgent.ContainerStartRequest csr, AMRMClient.ContainerRequest cr) {
        String hostKey = StringUtils.join((Collection)cr.getNodes(), (String)":");
        List<AMRMClient.ContainerRequest> requests = this.hostSpecificRequestsMap.containsKey(hostKey) ? this.hostSpecificRequestsMap.get(hostKey) : new ArrayList<AMRMClient.ContainerRequest>();
        requests.add(cr);
        this.hostSpecificRequestsMap.put(hostKey, requests);
        LOG.info("Requesting container for node {} request = {}", (Object)cr.getNodes(), (Object)cr);
        this.hostSpecificRequests.put(cr, csr);
    }
}

