/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.stram.StreamingContainerAgent;
import com.datatorrent.stram.plan.physical.PTContainer;
import com.datatorrent.stram.plan.physical.PTOperator;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRequestHandler.class);
    private static final String INVALID_HOST = "INVALID_HOST";
    protected static final int NUMBER_MISSED_HEARTBEATS = 30;
    private final Map<String, NodeReport> nodeReportMap = Maps.newHashMap();
    private final Map<Set<PTOperator>, String> nodeLocalMapping = Maps.newHashMap();
    private final Map<String, String> nodeToRack = Maps.newHashMap();
    private final Map<PTContainer, String> antiAffinityMapping = Maps.newHashMap();

    public void reissueContainerRequests(AMRMClient<AMRMClient.ContainerRequest> amRmClient, Map<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> requestedResources, int loopCounter, ResourceRequestHandler resourceRequestor, List<AMRMClient.ContainerRequest> containerRequests, List<AMRMClient.ContainerRequest> removedContainerRequests) {
        if (!requestedResources.isEmpty()) {
            for (Map.Entry<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> entry : requestedResources.entrySet()) {
                if (loopCounter - (Integer)entry.getValue().getKey() <= 30) continue;
                StreamingContainerAgent.ContainerStartRequest csr = entry.getKey();
                removedContainerRequests.add((AMRMClient.ContainerRequest)entry.getValue().getRight());
                AMRMClient.ContainerRequest cr = resourceRequestor.createContainerRequest(csr, false);
                entry.getValue().setLeft((Object)loopCounter);
                entry.getValue().setRight((Object)cr);
                containerRequests.add(cr);
            }
        }
    }

    public void addContainerRequest(Map<StreamingContainerAgent.ContainerStartRequest, MutablePair<Integer, AMRMClient.ContainerRequest>> requestedResources, int loopCounter, List<AMRMClient.ContainerRequest> containerRequests, StreamingContainerAgent.ContainerStartRequest csr, AMRMClient.ContainerRequest cr) {
        MutablePair pair = new MutablePair((Object)loopCounter, (Object)cr);
        requestedResources.put(csr, (MutablePair<Integer, AMRMClient.ContainerRequest>)pair);
        containerRequests.add(cr);
    }

    public AMRMClient.ContainerRequest createContainerRequest(StreamingContainerAgent.ContainerStartRequest csr, boolean first) {
        int priority = csr.container.getResourceRequestPriority();
        String[] nodes = null;
        String[] racks = null;
        String host = this.getHost(csr, first);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(csr.container.getRequiredMemoryMB());
        capability.setVirtualCores(csr.container.getRequiredVCores());
        if (host == INVALID_HOST) {
            return null;
        }
        if (host != null) {
            nodes = new String[]{host};
            return new AMRMClient.ContainerRequest(capability, nodes, racks, Priority.newInstance((int)priority), false);
        }
        return new AMRMClient.ContainerRequest(capability, nodes, racks, Priority.newInstance((int)priority));
    }

    public void clearNodeMapping() {
        this.nodeLocalMapping.clear();
    }

    public void updateNodeReports(List<NodeReport> nodeReports) {
        for (NodeReport nr : nodeReports) {
            LOG.debug("Node report: rackName={}, nodeid={}, numContainers={}, capability={}, used={}, state={}", new Object[]{nr.getRackName(), nr.getNodeId(), nr.getNumContainers(), nr.getCapability(), nr.getUsed(), nr.getNodeState()});
            this.nodeReportMap.put(nr.getNodeId().getHost(), nr);
            this.nodeToRack.put(nr.getNodeId().getHost(), nr.getRackName());
        }
    }

    public List<String> getNodesExceptHost(List<String> hostNames) {
        ArrayList<String> nodesList = new ArrayList<String>();
        HashSet hostNameSet = Sets.newHashSet();
        hostNameSet.addAll(hostNames);
        for (String host : this.nodeReportMap.keySet()) {
            String[] parts = host.split(":");
            if (parts.length <= 0 || hostNameSet.contains(parts[0]) || hostNameSet.contains(host)) continue;
            nodesList.add(parts[0]);
        }
        return nodesList;
    }

    public String getHost(StreamingContainerAgent.ContainerStartRequest csr, boolean first) {
        String host = null;
        PTContainer c = csr.container;
        if (first) {
            PTOperator.HostOperatorSet grpObj;
            for (PTOperator oper : c.getOperators()) {
                grpObj = oper.getNodeLocalOperators();
                host = this.nodeLocalMapping.get(grpObj.getOperatorSet());
                if (host != null) {
                    this.antiAffinityMapping.put(c, host);
                    return host;
                }
                if (grpObj.getHost() == null) continue;
                host = grpObj.getHost();
                break;
            }
            if (host != null && this.nodeReportMap.get(host) != null) {
                for (PTOperator oper : c.getOperators()) {
                    grpObj = oper.getNodeLocalOperators();
                    Set<PTOperator> nodeLocalSet = grpObj.getOperatorSet();
                    NodeReport report = this.nodeReportMap.get(host);
                    int aggrMemory = c.getRequiredMemoryMB();
                    int vCores = c.getRequiredVCores();
                    HashSet containers = Sets.newHashSet();
                    containers.add(c);
                    for (PTOperator nodeLocalOper : nodeLocalSet) {
                        if (containers.contains(nodeLocalOper.getContainer())) continue;
                        aggrMemory += nodeLocalOper.getContainer().getRequiredMemoryMB();
                        vCores += nodeLocalOper.getContainer().getRequiredVCores();
                        containers.add(nodeLocalOper.getContainer());
                    }
                    int memAvailable = report.getCapability().getMemory() - report.getUsed().getMemory();
                    int vCoresAvailable = report.getCapability().getVirtualCores() - report.getUsed().getVirtualCores();
                    if (memAvailable < aggrMemory || vCoresAvailable < vCores) continue;
                    this.nodeLocalMapping.put(nodeLocalSet, host);
                    this.antiAffinityMapping.put(c, host);
                    return host;
                }
            }
        }
        host = null;
        ArrayList<String> antiHosts = new ArrayList<String>();
        ArrayList<String> antiPreferredHosts = new ArrayList<String>();
        if (!c.getStrictAntiPrefs().isEmpty()) {
            this.populateAntiHostList(c, antiHosts);
        }
        if (!c.getPreferredAntiPrefs().isEmpty()) {
            this.populateAntiHostList(c, antiPreferredHosts);
        }
        LOG.info("Strict anti-affinity = {} for container with operators {}", antiHosts, (Object)StringUtils.join(c.getOperators(), (String)","));
        for (PTOperator oper : c.getOperators()) {
            PTOperator.HostOperatorSet grpObj = oper.getNodeLocalOperators();
            Set<PTOperator> nodeLocalSet = grpObj.getOperatorSet();
            if (nodeLocalSet.size() <= 1 && c.getStrictAntiPrefs().isEmpty() && c.getPreferredAntiPrefs().isEmpty()) continue;
            LOG.info("Finding new host for {}", nodeLocalSet);
            int aggrMemory = c.getRequiredMemoryMB();
            int vCores = c.getRequiredVCores();
            HashSet containers = Sets.newHashSet();
            containers.add(c);
            for (PTOperator nodeLocalOper : nodeLocalSet) {
                if (containers.contains(nodeLocalOper.getContainer())) continue;
                aggrMemory += nodeLocalOper.getContainer().getRequiredMemoryMB();
                vCores += nodeLocalOper.getContainer().getRequiredVCores();
                containers.add(nodeLocalOper.getContainer());
            }
            if ((host = this.assignHost(host, antiHosts, antiPreferredHosts, grpObj, nodeLocalSet, aggrMemory, vCores)) == null && !antiPreferredHosts.isEmpty() && !antiHosts.isEmpty()) {
                antiPreferredHosts.clear();
                host = this.assignHost(host, antiHosts, antiPreferredHosts, grpObj, nodeLocalSet, aggrMemory, vCores);
            }
            if (host != null) {
                this.antiAffinityMapping.put(c, host);
                continue;
            }
            host = INVALID_HOST;
        }
        LOG.info("Found host {}", (Object)host);
        return host;
    }

    public void populateAntiHostList(PTContainer c, List<String> antiHosts) {
        for (PTContainer container : c.getStrictAntiPrefs()) {
            if (this.antiAffinityMapping.containsKey(container)) {
                antiHosts.add(this.antiAffinityMapping.get(container));
                continue;
            }
            String antiHost = this.getHostForContainer(container);
            if (antiHost == null) continue;
            antiHosts.add(antiHost);
        }
    }

    public String getHostForContainer(PTContainer container) {
        for (PTOperator oper : container.getOperators()) {
            PTOperator.HostOperatorSet grpObj = oper.getNodeLocalOperators();
            String host = this.nodeLocalMapping.get(grpObj.getOperatorSet());
            if (host != null) {
                return host;
            }
            if (grpObj.getHost() == null) continue;
            host = grpObj.getHost();
            return host;
        }
        return null;
    }

    public String assignHost(String host, List<String> antiHosts, List<String> antiPreferredHosts, PTOperator.HostOperatorSet grpObj, Set<PTOperator> nodeLocalSet, int aggrMemory, int vCores) {
        for (Map.Entry<String, NodeReport> nodeEntry : this.nodeReportMap.entrySet()) {
            if (nodeEntry.getValue().getNodeState() != NodeState.RUNNING) continue;
            int memAvailable = nodeEntry.getValue().getCapability().getMemory() - nodeEntry.getValue().getUsed().getMemory();
            int vCoresAvailable = nodeEntry.getValue().getCapability().getVirtualCores() - nodeEntry.getValue().getUsed().getVirtualCores();
            if (memAvailable < aggrMemory || vCoresAvailable < vCores || antiHosts.contains(nodeEntry.getKey()) || antiPreferredHosts.contains(nodeEntry.getKey())) continue;
            host = nodeEntry.getKey();
            grpObj.setHost(host);
            this.nodeLocalMapping.put(nodeLocalSet, host);
            return host;
        }
        return null;
    }
}

