/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.api.Context;
import com.datatorrent.api.StorageAgent;
import com.datatorrent.api.StreamCodec;
import com.datatorrent.bufferserver.server.Server;
import com.datatorrent.common.util.AsyncFSStorageAgent;
import com.datatorrent.common.util.BasicContainerOptConfigurator;
import com.datatorrent.common.util.FSStorageAgent;
import com.datatorrent.netlet.EventLoop;
import com.datatorrent.netlet.util.Slice;
import com.datatorrent.stram.FSRecoveryHandler;
import com.datatorrent.stram.LaunchContainerRunnable;
import com.datatorrent.stram.StreamingAppMaster;
import com.datatorrent.stram.StreamingContainerManager;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.engine.StreamingContainer;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.minlog.Log;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import net.engio.mbassy.bus.MBassador;
import org.apache.apex.shaded.ning19.com.ning.http.client.ws.WebSocketUpgradeHandler;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.xbean.asm5.tree.ClassNode;
import org.codehaus.jackson.annotate.JsonUnwrapped;
import org.codehaus.jackson.map.ser.std.RawSerializer;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class StramClient {
    private static final Logger LOG = LoggerFactory.getLogger(StramClient.class);
    public static final String YARN_APPLICATION_TYPE = "ApacheApex";
    @Deprecated
    public static final String YARN_APPLICATION_TYPE_DEPRECATED = "DataTorrent";
    public static final String LIB_JARS_SEP = ",";
    private final Configuration conf;
    private final YarnClient yarnClient = YarnClient.createYarnClient();
    private final int amPriority = 0;
    private ApplicationId appId;
    private final LogicalPlan dag;
    public String javaCmd = "${JAVA_HOME}/bin/java";
    private final String log4jPropFile = "";
    private long clientTimeout = 600000L;
    private String originalAppId;
    private String queueName;
    private String applicationType = "ApacheApex";
    private String archives;
    private String files;
    private LinkedHashSet<String> resources;
    private Set<String> tags = new HashSet<String>();
    private static final Class<?>[] APEX_CLASSES = new Class[]{Slice.class, EventLoop.class, Server.class, StreamingAppMaster.class, StreamCodec.class, FSStorageAgent.class, ConstraintViolationException.class, Kryo.class, ApacheValidationProvider.class, BeanValidationContext.class, ClassUtils.class, MBassador.class, WebSocketUpgradeHandler.class, JsonUnwrapped.class, RawSerializer.class, BeanUtils.class, URLEncodedUtils.class, BasicHeaderValueParser.class, Log.class, ClassNode.class, SpscArrayQueue.class};
    private static final Class<?>[] APEX_SECURITY_SPECIFIC_CLASSES = new Class[0];
    private static final Class<?>[] APEX_SECURITY_CLASSES = (Class[])ArrayUtils.addAll((Object[])APEX_CLASSES, (Object[])APEX_SECURITY_SPECIFIC_CLASSES);

    public StramClient(Configuration conf, LogicalPlan dag) throws Exception {
        this.conf = conf;
        this.dag = dag;
        dag.validate();
        this.yarnClient.init(conf);
    }

    public void start() {
        this.yarnClient.start();
    }

    public void stop() {
        this.yarnClient.stop();
    }

    public static LinkedHashSet<String> findJars(LogicalPlan dag, Class<?>[] defaultClasses) {
        ArrayList jarClasses = new ArrayList();
        for (String className : dag.getClassNames()) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                jarClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Failed to load class " + className, e);
            }
        }
        Iterator<String> i$ = Lists.newArrayList(jarClasses).iterator();
        while (i$.hasNext()) {
            Class clazz;
            for (Class c = clazz = (Class)((Object)i$.next()); c != Object.class && c != null; c = c.getSuperclass()) {
                jarClasses.add(c);
                jarClasses.addAll(Arrays.asList(c.getInterfaces()));
            }
        }
        jarClasses.addAll(Arrays.asList(defaultClasses));
        if (dag.isDebug()) {
            LOG.debug("Deploy dependencies: {}", jarClasses);
        }
        LinkedHashSet<String> localJarFiles = new LinkedHashSet<String>();
        HashMap<String, String> sourceToJar = new HashMap<String, String>();
        for (Class clazz : jarClasses) {
            if (clazz.getProtectionDomain().getCodeSource() == null) continue;
            String sourceLocation = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            String jar = (String)sourceToJar.get(sourceLocation);
            if (jar == null) {
                jar = JarFinder.getJar((Class)clazz);
                sourceToJar.put(sourceLocation, jar);
                LOG.debug("added sourceLocation {} as {}", (Object)sourceLocation, (Object)jar);
            }
            if (jar == null) {
                throw new AssertionError((Object)("Cannot resolve jar file for " + clazz));
            }
            localJarFiles.add(jar);
        }
        String libJarsPath = (String)dag.getValue(Context.DAGContext.LIBRARY_JARS);
        if (!StringUtils.isEmpty((String)libJarsPath)) {
            String[] stringArray = StringUtils.splitByWholeSeparator((String)libJarsPath, (String)LIB_JARS_SEP);
            localJarFiles.addAll(Arrays.asList(stringArray));
        }
        LOG.info("Local jar file dependencies: " + localJarFiles);
        return localJarFiles;
    }

    private String copyFromLocal(FileSystem fs, Path basePath, String[] files) throws IOException {
        StringBuilder csv = new StringBuilder(files.length * (basePath.toString().length() + 16));
        for (String localFile : files) {
            Path src = new Path(localFile);
            String filename = src.getName();
            Path dst = new Path(basePath, filename);
            URI localFileURI = null;
            try {
                localFileURI = new URI(localFile);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            if (localFileURI.getScheme() == null || localFileURI.getScheme().startsWith("file")) {
                LOG.info("Copy {} from local filesystem to {}", (Object)localFile, (Object)dst);
                fs.copyFromLocalFile(false, true, src, dst);
            } else {
                LOG.info("Copy {} from DFS to {}", (Object)localFile, (Object)dst);
                FileUtil.copy((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (boolean)false, (boolean)true, (Configuration)this.conf);
            }
            if (csv.length() > 0) {
                csv.append(LIB_JARS_SEP);
            }
            csv.append(dst.toString());
        }
        return csv.toString();
    }

    public void copyInitialState(Path origAppDir) throws IOException {
        FileStatus[] lFiles;
        String newAppDir = this.dag.assertAppPath();
        FSRecoveryHandler recoveryHandler = new FSRecoveryHandler(origAppDir.toString(), this.conf);
        Object snapshot = recoveryHandler.restore();
        if (snapshot == null) {
            throw new IllegalArgumentException("No previous application state found in " + origAppDir);
        }
        DataInputStream logIs = recoveryHandler.getLog();
        ((StreamingContainerManager.CheckpointState)snapshot).setApplicationId(this.dag, this.conf);
        Path checkpointPath = new Path(newAppDir, LogicalPlan.SUBDIR_CHECKPOINTS);
        FileSystem fs = FileSystem.newInstance((URI)origAppDir.toUri(), (Configuration)this.conf);
        fs.delete(checkpointPath, true);
        recoveryHandler = new FSRecoveryHandler(newAppDir, this.conf);
        recoveryHandler.save(snapshot);
        DataOutputStream logOs = recoveryHandler.rotateLog();
        IOUtils.copy((InputStream)logIs, (OutputStream)logOs);
        ((OutputStream)logOs).flush();
        ((OutputStream)logOs).close();
        ((InputStream)logIs).close();
        for (FileStatus f : lFiles = fs.listStatus(origAppDir)) {
            if (!f.isDirectory()) continue;
            String targetPath = f.getPath().toString().replace(origAppDir.toString(), newAppDir);
            if (!fs.exists(new Path(targetPath))) {
                LOG.debug("Copying {} to {}", (Object)f.getPath(), (Object)targetPath);
                FileUtil.copy((FileSystem)fs, (Path)f.getPath(), (FileSystem)fs, (Path)new Path(targetPath), (boolean)false, (Configuration)this.conf);
                continue;
            }
            LOG.debug("Ignoring {} as it already exists under {}", (Object)f.getPath(), (Object)targetPath);
        }
    }

    public void startApplication() throws YarnException, IOException {
        Class<?>[] defaultClasses;
        if (this.applicationType.equals(YARN_APPLICATION_TYPE)) {
            defaultClasses = UserGroupInformation.isSecurityEnabled() ? APEX_SECURITY_CLASSES : APEX_CLASSES;
        } else {
            throw new IllegalStateException(this.applicationType + " is not a valid application type.");
        }
        LinkedHashSet<String> localJarFiles = StramClient.findJars(this.dag, defaultClasses);
        if (this.resources != null) {
            localJarFiles.addAll(this.resources);
        }
        YarnClusterMetrics clusterMetrics = this.yarnClient.getYarnClusterMetrics();
        LOG.info("Got Cluster metric info from ASM, numNodeManagers={}", (Object)clusterMetrics.getNumNodeManagers());
        List listAclInfo = this.yarnClient.getQueueAclsInfo();
        for (QueueUserACLInfo aclInfo : listAclInfo) {
            for (QueueACL userAcl : aclInfo.getUserAcls()) {
                LOG.info("User ACL Info for Queue queueName={}, userAcl={}", (Object)aclInfo.getQueueName(), (Object)userAcl.name());
            }
        }
        YarnClientApplication newApp = this.yarnClient.createApplication();
        this.appId = newApp.getNewApplicationResponse().getApplicationId();
        int maxMem = newApp.getNewApplicationResponse().getMaximumResourceCapability().getMemory();
        LOG.info("Max mem capability of resources in this cluster " + maxMem);
        int amMemory = this.dag.getMasterMemoryMB();
        if (amMemory > maxMem) {
            LOG.info("AM memory specified above max threshold of cluster. Using max value, specified={}, max={}", (Object)amMemory, (Object)maxMem);
            amMemory = maxMem;
        }
        if (this.dag.getAttributes().get(LogicalPlan.APPLICATION_ID) == null) {
            this.dag.setAttribute(LogicalPlan.APPLICATION_ID, this.appId.toString());
        }
        LOG.info("Setting up application submission context for ASM");
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        appContext.setApplicationId(this.appId);
        appContext.setApplicationName((String)this.dag.getValue(LogicalPlan.APPLICATION_NAME));
        appContext.setApplicationType(this.applicationType);
        if (YARN_APPLICATION_TYPE.equals(this.applicationType)) {
            // empty if block
        }
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = this.conf.get("yarn.resourcemanager.principal");
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            try (FileSystem fs = StramClientUtils.newFileSystemInstance(this.conf);){
                Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
                if (tokens != null) {
                    for (Token token : tokens) {
                        LOG.info("Got dt for " + fs.getUri() + "; " + token);
                    }
                }
            }
            new StramClientUtils.ClientRMHelper(this.yarnClient, this.conf).addRMDelegationToken(tokenRenewer, credentials);
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(fsTokens);
        }
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        try (FileSystem fs = StramClientUtils.newFileSystemInstance(this.conf);){
            String loggersLevel;
            Path appsBasePath = new Path(StramClientUtils.getDTDFSRootDir(fs, this.conf), "apps");
            String configuredAppPath = (String)this.dag.getValue(LogicalPlan.APPLICATION_PATH);
            Path appPath = configuredAppPath == null ? new Path(appsBasePath, this.appId.toString()) : new Path(configuredAppPath);
            String libJarsCsv = this.copyFromLocal(fs, appPath, localJarFiles.toArray(new String[0]));
            LOG.info("libjars: {}", (Object)libJarsCsv);
            this.dag.getAttributes().put(Context.DAGContext.LIBRARY_JARS, (Object)libJarsCsv);
            LaunchContainerRunnable.addFilesToLocalResources(LocalResourceType.FILE, libJarsCsv, localResources, fs);
            if (this.archives != null) {
                String[] localFiles = this.archives.split(LIB_JARS_SEP);
                String archivesCsv = this.copyFromLocal(fs, appPath, localFiles);
                LOG.info("archives: {}", (Object)archivesCsv);
                this.dag.getAttributes().put(LogicalPlan.ARCHIVES, (Object)archivesCsv);
                LaunchContainerRunnable.addFilesToLocalResources(LocalResourceType.ARCHIVE, archivesCsv, localResources, fs);
            }
            if (this.files != null) {
                String[] localFiles = this.files.split(LIB_JARS_SEP);
                String filesCsv = this.copyFromLocal(fs, appPath, localFiles);
                LOG.info("files: {}", (Object)filesCsv);
                this.dag.getAttributes().put(LogicalPlan.FILES, (Object)filesCsv);
                LaunchContainerRunnable.addFilesToLocalResources(LocalResourceType.FILE, filesCsv, localResources, fs);
            }
            this.dag.getAttributes().put(LogicalPlan.APPLICATION_PATH, (Object)appPath.toString());
            StorageAgent agent = (StorageAgent)this.dag.getAttributes().get(Context.OperatorContext.STORAGE_AGENT);
            if (agent != null && agent instanceof StorageAgent.ApplicationAwareStorageAgent) {
                ((StorageAgent.ApplicationAwareStorageAgent)agent).setApplicationAttributes(this.dag.getAttributes());
            }
            if (this.dag.getAttributes().get(Context.OperatorContext.STORAGE_AGENT) == null) {
                Path checkpointPath = new Path(appPath, LogicalPlan.SUBDIR_CHECKPOINTS);
                this.dag.setAttribute(Context.OperatorContext.STORAGE_AGENT, new AsyncFSStorageAgent(checkpointPath.toString(), this.conf));
            }
            if (this.dag.getAttributes().get(LogicalPlan.CONTAINER_OPTS_CONFIGURATOR) == null) {
                this.dag.setAttribute(LogicalPlan.CONTAINER_OPTS_CONFIGURATOR, new BasicContainerOptConfigurator());
            }
            if (!"".isEmpty()) {
                Path log4jSrc = new Path("");
                Path log4jDst = new Path(appPath, "log4j.props");
                fs.copyFromLocalFile(false, true, log4jSrc, log4jDst);
                FileStatus log4jFileStatus = fs.getFileStatus(log4jDst);
                LocalResource log4jRsrc = (LocalResource)Records.newRecord(LocalResource.class);
                log4jRsrc.setType(LocalResourceType.FILE);
                log4jRsrc.setVisibility(LocalResourceVisibility.APPLICATION);
                log4jRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)log4jDst.toUri()));
                log4jRsrc.setTimestamp(log4jFileStatus.getModificationTime());
                log4jRsrc.setSize(log4jFileStatus.getLen());
                localResources.put("log4j.properties", log4jRsrc);
            }
            if (this.originalAppId != null) {
                Path origAppPath = new Path(appsBasePath, this.originalAppId);
                LOG.info("Restart from {}", (Object)origAppPath);
                this.copyInitialState(origAppPath);
            }
            Path cfgDst = new Path(appPath, "dt-conf.ser");
            FSDataOutputStream outStream = fs.create(cfgDst, true);
            LogicalPlan.write(this.dag, (OutputStream)outStream);
            outStream.close();
            Path launchConfigDst = new Path(appPath, "dt-launch-config.xml");
            outStream = fs.create(launchConfigDst, true);
            this.conf.writeXml((OutputStream)outStream);
            outStream.close();
            LaunchContainerRunnable.addFileToLocalResources("dt-conf.ser", fs.getFileStatus(cfgDst), LocalResourceType.FILE, localResources);
            amContainer.setLocalResources(localResources);
            LOG.info("Set the environment for the application master");
            HashMap<String, String> env = new HashMap<String, String>();
            StringBuilder classPathEnv = new StringBuilder("./*");
            String classpath = this.conf.get("yarn.application.classpath");
            for (String c : StringUtils.isBlank((String)classpath) ? YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH : classpath.split(LIB_JARS_SEP)) {
                if (c.equals("$HADOOP_CLIENT_CONF_DIR")) continue;
                classPathEnv.append(':');
                classPathEnv.append(c.trim());
            }
            env.put("CLASSPATH", classPathEnv.toString());
            env.put("HADOOP_USER_NAME", UserGroupInformation.getLoginUser().getUserName());
            amContainer.setEnvironment(env);
            ArrayList<String> vargs = new ArrayList<String>(30);
            LOG.info("Setting up app master command");
            vargs.add(this.javaCmd);
            if (this.dag.isDebug()) {
                vargs.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n");
            }
            if (this.dag.getMasterJVMOptions() != null) {
                vargs.add(this.dag.getMasterJVMOptions());
            }
            Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
            vargs.add("-Djava.io.tmpdir=" + tmpDir);
            vargs.add("-Xmx" + amMemory * 3 / 4 + "m");
            vargs.add("-XX:+HeapDumpOnOutOfMemoryError");
            vargs.add("-XX:HeapDumpPath=" + System.getProperty("java.io.tmpdir") + "/dt-heap-" + this.appId.getId() + ".bin");
            vargs.add("-Dhadoop.root.logger=" + (this.dag.isDebug() ? "DEBUG" : "INFO") + ",RFA");
            vargs.add("-Dhadoop.log.dir=<LOG_DIR>");
            vargs.add(String.format("-D%s=%s", StreamingContainer.PROP_APP_PATH, this.dag.assertAppPath()));
            if (this.dag.isDebug()) {
                vargs.add("-Dlog4j.debug=true");
            }
            if ((loggersLevel = this.conf.get("dt.loggers.level")) != null) {
                vargs.add(String.format("-D%s=%s", "dt.loggers.level", loggersLevel));
            }
            vargs.add(StreamingAppMaster.class.getName());
            vargs.add("1><LOG_DIR>/AppMaster.stdout");
            vargs.add("2><LOG_DIR>/AppMaster.stderr");
            StringBuilder command = new StringBuilder(9 * vargs.size());
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            LOG.info("Completed setting up app master command " + command.toString());
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(command.toString());
            amContainer.setCommands(commands);
            Resource resource = (Resource)Records.newRecord(Resource.class);
            resource.setMemory(amMemory);
            appContext.setResource(resource);
            appContext.setAMContainerSpec(amContainer);
            Priority pri = (Priority)Records.newRecord(Priority.class);
            pri.setPriority(0);
            appContext.setPriority(pri);
            appContext.setQueue(this.queueName);
            appContext.setApplicationTags(this.tags);
            String specStr = Objects.toStringHelper((String)"Submitting application: ").add("name", (Object)appContext.getApplicationName()).add("queue", (Object)appContext.getQueue()).add("user", (Object)UserGroupInformation.getLoginUser()).add("resource", (Object)appContext.getResource()).toString();
            LOG.info(specStr);
            if (this.dag.isDebug()) {
                // empty if block
            }
            this.yarnClient.submitApplication(appContext);
        }
    }

    public ApplicationReport getApplicationReport() throws YarnException, IOException {
        return this.yarnClient.getApplicationReport(this.appId);
    }

    public void killApplication() throws YarnException, IOException {
        this.yarnClient.killApplication(this.appId);
    }

    public void setClientTimeout(long timeoutMillis) {
        this.clientTimeout = timeoutMillis;
    }

    public boolean monitorApplication() throws YarnException, IOException {
        StramClientUtils.ClientRMHelper.AppStatusCallback callback = new StramClientUtils.ClientRMHelper.AppStatusCallback(){

            @Override
            public boolean exitLoop(ApplicationReport report) {
                LOG.info("Got application report from ASM for, appId={}, clientToken={}, appDiagnostics={}, appMasterHost={},appQueue={}, appMasterRpcPort={}, appStartTime={}, yarnAppState={}, distributedFinalState={}, appTrackingUrl={}, appUser={}", new Object[]{StramClient.this.appId.getId(), report.getClientToAMToken(), report.getDiagnostics(), report.getHost(), report.getQueue(), report.getRpcPort(), report.getStartTime(), report.getYarnApplicationState(), report.getFinalApplicationStatus(), report.getTrackingUrl(), report.getUser()});
                return false;
            }
        };
        StramClientUtils.ClientRMHelper rmClient = new StramClientUtils.ClientRMHelper(this.yarnClient, this.conf);
        return rmClient.waitForCompletion(this.appId, callback, this.clientTimeout);
    }

    public void setApplicationType(String type) {
        this.applicationType = type;
    }

    public void setOriginalAppId(String appId) {
        this.originalAppId = appId;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void setResources(LinkedHashSet<String> resources) {
        this.resources = resources;
    }

    public void setArchives(String archives) {
        this.archives = archives;
    }

    public void setFiles(String files) {
        this.files = files;
    }
}

