/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.api.Attribute;
import com.datatorrent.stram.util.LoggerUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StramUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StramUtils.class);
    public static final String DT_LOGGERS_LEVEL = "dt.loggers.level";

    public static <T> Class<? extends T> classForName(String className, Class<T> superClass) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className).asSubclass(superClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz, e);
        }
    }

    public static JSONObject getStackTrace() {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<Thread, StackTraceElement[]> elements : stackTraces.entrySet()) {
            JSONObject jsonThread = new JSONObject();
            Thread thread = elements.getKey();
            try {
                jsonThread.put("name", (Object)thread.getName());
                jsonThread.put("state", (Object)thread.getState());
                jsonThread.put("id", thread.getId());
                JSONArray stackTraceElements = new JSONArray();
                for (StackTraceElement stackTraceElement : elements.getValue()) {
                    stackTraceElements.put((Object)stackTraceElement.toString());
                }
                jsonThread.put("stackTraceElements", (Object)stackTraceElements);
                jsonArray.put((Object)jsonThread);
            }
            catch (Exception ex) {
                LOG.warn("Getting stack trace for the thread " + thread.getName() + " failed.");
            }
        }
        try {
            jsonObject.put("threads", (Object)jsonArray);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    public static <T> T getValueWithDefault(Attribute.AttributeMap map, Attribute<T> key) {
        Object value = map.get(key);
        if (value == null) {
            value = key.defaultValue;
        }
        return (T)value;
    }

    public static List<ApplicationReport> getApexApplicationList(YarnClient yarnClient) throws IOException, YarnException {
        return yarnClient.getApplications((Set)Sets.newHashSet((Object[])new String[]{"ApacheApex", "DataTorrent"}));
    }

    public static abstract class YarnContainerMain {
        static {
            String loggersLevel;
            Map<String, String> envs = System.getenv();
            String containerIdString = envs.get(ApplicationConstants.Environment.CONTAINER_ID.name());
            if (containerIdString != null) {
                System.setProperty("dt.cid", containerIdString);
            }
            System.setProperty("hadoop.log.file", "dt.log");
            if (envs.get("CDH_YARN_HOME") != null) {
                String[] keys;
                for (String key : keys = new String[]{"log.dir", "log.file", "root.logger"}) {
                    String v = System.getProperty("hadoop." + key);
                    if (v == null) continue;
                    System.setProperty(key, v);
                }
            }
            if (!Strings.isNullOrEmpty((String)(loggersLevel = System.getProperty(StramUtils.DT_LOGGERS_LEVEL)))) {
                String[] targets;
                HashMap targetChanges = Maps.newHashMap();
                for (String target : targets = loggersLevel.split(",")) {
                    String[] parts = target.split(":");
                    targetChanges.put(parts[0], parts[1]);
                }
                LoggerUtil.changeLoggersLevel(targetChanges);
            }
        }
    }
}

