/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram;

import com.datatorrent.stram.StramUtils;
import com.datatorrent.stram.StreamingAppMasterService;
import com.datatorrent.stram.debug.StdOutErrLog;
import com.datatorrent.stram.util.VersionInfo;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingAppMaster
extends StramUtils.YarnContainerMain {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingAppMaster.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Throwable {
        StdOutErrLog.tieSystemOutAndErrToLog();
        LOG.info("Master starting with classpath: {}", (Object)System.getProperty("java.class.path"));
        LOG.info("version: {}", (Object)VersionInfo.APEX_VERSION.getBuildVersion());
        StringWriter sw = new StringWriter();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            sw.append("\n").append(e.getKey()).append("=").append(e.getValue());
        }
        LOG.info("appmaster env:" + sw.toString());
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (cliParser.hasOption("help")) {
            new HelpFormatter().printHelp("ApplicationMaster", opts);
            return;
        }
        Map<String, String> envs = System.getenv();
        ApplicationAttemptId appAttemptID = (ApplicationAttemptId)Records.newRecord(ApplicationAttemptId.class);
        if (!envs.containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
        } else {
            ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            appAttemptID = containerId.getApplicationAttemptId();
        }
        boolean result = false;
        StreamingAppMasterService appMaster = null;
        try {
            appMaster = new StreamingAppMasterService(appAttemptID);
            LOG.info("Initializing Application Master.");
            YarnConfiguration conf = new YarnConfiguration();
            appMaster.init((Configuration)conf);
            appMaster.start();
            result = appMaster.run();
        }
        catch (Throwable t) {
            LOG.error("Exiting Application Master", t);
            System.exit(1);
        }
        finally {
            if (appMaster != null) {
                appMaster.stop();
            }
        }
        if (result) {
            LOG.info("Application Master completed.");
            System.exit(0);
            return;
        } else {
            LOG.info("Application Master failed.");
            System.exit(2);
        }
    }
}

