/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.api.StatsListener;
import com.datatorrent.stram.api.StreamingContainerUmbilicalProtocol;
import com.datatorrent.stram.engine.Node;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFactory {
    private final EnumMap<StreamingContainerUmbilicalProtocol.StramToNodeRequest.RequestType, RequestDelegate> map = new EnumMap(StreamingContainerUmbilicalProtocol.StramToNodeRequest.RequestType.class);
    private static final Logger logger = LoggerFactory.getLogger(RequestFactory.class);

    public void registerDelegate(StreamingContainerUmbilicalProtocol.StramToNodeRequest.RequestType requestType, RequestDelegate delegate) {
        RequestDelegate old = this.map.put(requestType, delegate);
        if (old != null) {
            logger.warn("Replacing delegate {} for {} by {}", new Object[]{old, requestType, delegate});
        }
    }

    public StatsListener.OperatorRequest getRequestExecutor(Node<?> node, StreamingContainerUmbilicalProtocol.StramToNodeRequest snr) {
        RequestDelegate delegate = this.map.get((Object)snr.requestType);
        if (delegate == null) {
            if (snr.cmd != null) {
                return snr.cmd;
            }
            return null;
        }
        return delegate.getRequestExecutor(node, snr);
    }

    public static interface RequestDelegate {
        public StatsListener.OperatorRequest getRequestExecutor(Node<?> var1, StreamingContainerUmbilicalProtocol.StramToNodeRequest var2);
    }
}

