/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.api.Operator;
import com.datatorrent.api.StatsListener;
import com.datatorrent.stram.api.StreamingContainerUmbilicalProtocol;
import com.datatorrent.stram.engine.OperatorResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramToNodeGetPropertyRequest
extends StreamingContainerUmbilicalProtocol.StramToNodeRequest
implements Serializable {
    private String propertyName;
    private static final Logger logger = LoggerFactory.getLogger(StramToNodeGetPropertyRequest.class);

    public StramToNodeGetPropertyRequest() {
        this.requestType = StreamingContainerUmbilicalProtocol.StramToNodeRequest.RequestType.CUSTOM;
        this.cmd = new GetPropertyRequest();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private class GetPropertyRequest
    implements StatsListener.OperatorRequest,
    Serializable {
        private GetPropertyRequest() {
        }

        public StatsListener.OperatorResponse execute(Operator operator, int operatorId, long windowId) throws IOException {
            BeanMap beanMap = new BeanMap((Object)operator);
            HashMap<String, Object> propertyValue = new HashMap<String, Object>();
            if (StramToNodeGetPropertyRequest.this.propertyName != null) {
                if (beanMap.containsKey((Object)StramToNodeGetPropertyRequest.this.propertyName)) {
                    propertyValue.put(StramToNodeGetPropertyRequest.this.propertyName, beanMap.get((Object)StramToNodeGetPropertyRequest.this.propertyName));
                }
            } else {
                Iterator entryIterator = beanMap.entryIterator();
                while (entryIterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)entryIterator.next();
                    propertyValue.put((String)entry.getKey(), entry.getValue());
                }
            }
            logger.debug("Getting property {} on operator {}", propertyValue, (Object)operator);
            OperatorResponse response = new OperatorResponse(StramToNodeGetPropertyRequest.this.requestId, propertyValue);
            return response;
        }

        public String toString() {
            return "Get Property";
        }
    }
}

