/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.api;

import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.api.StatsListener;
import com.datatorrent.stram.api.StreamingContainerUmbilicalProtocol;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramToNodeSetPropertyRequest
extends StreamingContainerUmbilicalProtocol.StramToNodeRequest
implements Serializable {
    private String propertyKey;
    private String propertyValue;
    private static final long serialVersionUID = 201405271034L;
    private static final Logger logger = LoggerFactory.getLogger(StramToNodeSetPropertyRequest.class);

    public StramToNodeSetPropertyRequest() {
        this.requestType = StreamingContainerUmbilicalProtocol.StramToNodeRequest.RequestType.CUSTOM;
        this.cmd = new SetPropertyRequest();
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    private class SetPropertyRequest
    implements StatsListener.OperatorRequest,
    Serializable {
        private SetPropertyRequest() {
        }

        public StatsListener.OperatorResponse execute(Operator operator, int operatorId, long windowId) throws IOException {
            Map<String, String> properties = Collections.singletonMap(StramToNodeSetPropertyRequest.this.propertyKey, StramToNodeSetPropertyRequest.this.propertyValue);
            logger.info("Setting property {} on operator {}", properties, (Object)operator);
            LogicalPlanConfiguration.setOperatorProperties((DAG.GenericOperator)operator, properties);
            return null;
        }

        public String toString() {
            return "Set Property";
        }
    }
}

