/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.cli;

import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.stram.StramUtils;
import com.datatorrent.stram.client.AppPackage;
import com.datatorrent.stram.client.ConfigPackage;
import com.datatorrent.stram.client.DTConfiguration;
import com.datatorrent.stram.client.RecordingsAgent;
import com.datatorrent.stram.client.StramAgent;
import com.datatorrent.stram.client.StramAppLauncher;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.codec.LogicalPlanSerializer;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.requests.AddStreamSinkRequest;
import com.datatorrent.stram.plan.logical.requests.CreateOperatorRequest;
import com.datatorrent.stram.plan.logical.requests.CreateStreamRequest;
import com.datatorrent.stram.plan.logical.requests.LogicalPlanRequest;
import com.datatorrent.stram.plan.logical.requests.RemoveOperatorRequest;
import com.datatorrent.stram.plan.logical.requests.RemoveStreamRequest;
import com.datatorrent.stram.plan.logical.requests.SetOperatorAttributeRequest;
import com.datatorrent.stram.plan.logical.requests.SetOperatorPropertyRequest;
import com.datatorrent.stram.plan.logical.requests.SetPortAttributeRequest;
import com.datatorrent.stram.plan.logical.requests.SetStreamAttributeRequest;
import com.datatorrent.stram.security.StramUserLogin;
import com.datatorrent.stram.util.JSONSerializationProvider;
import com.datatorrent.stram.util.SecurityUtils;
import com.datatorrent.stram.util.VersionInfo;
import com.datatorrent.stram.util.WebServicesClient;
import com.datatorrent.stram.webapp.OperatorDiscoverer;
import com.datatorrent.stram.webapp.TypeDiscoverer;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.client.WebResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ApexCli {
    private static final Logger LOG = LoggerFactory.getLogger(ApexCli.class);
    private Configuration conf;
    private FileSystem fs;
    private StramAgent stramAgent;
    private final YarnClient yarnClient = YarnClient.createYarnClient();
    private ApplicationReport currentApp = null;
    private boolean consolePresent;
    private String[] commandsToExecute;
    private final Map<String, CommandSpec> globalCommands = new TreeMap<String, CommandSpec>();
    private final Map<String, CommandSpec> connectedCommands = new TreeMap<String, CommandSpec>();
    private final Map<String, CommandSpec> logicalPlanChangeCommands = new TreeMap<String, CommandSpec>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, List<String>> macros = new HashMap<String, List<String>>();
    private boolean changingLogicalPlan = false;
    private final List<LogicalPlanRequest> logicalPlanRequestQueue = new ArrayList<LogicalPlanRequest>();
    private FileHistory topLevelHistory;
    private FileHistory changingLogicalPlanHistory;
    private String jsonp;
    private boolean raw = false;
    private RecordingsAgent recordingsAgent;
    private final ObjectMapper mapper = new JSONSerializationProvider().getContext(null);
    private String pagerCommand;
    private Process pagerProcess;
    private int verboseLevel = 0;
    private final Tokenizer tokenizer = new Tokenizer();
    private final Map<String, String> variableMap = new HashMap<String, String>();
    private static boolean lastCommandError = false;
    private Thread mainThread;
    private Thread commandThread;
    private String prompt;
    private String forcePrompt;
    private String kerberosPrincipal;
    private String kerberosKeyTab;
    private static String CONFIG_EXCLUSIVE = "exclusive";
    private static String CONFIG_INCLUSIVE = "inclusive";
    private static GetOperatorClassesCommandLineOptions GET_OPERATOR_CLASSES_OPTIONS = new GetOperatorClassesCommandLineOptions();
    private static GetPhysicalPropertiesCommandLineOptions GET_PHYSICAL_PROPERTY_OPTIONS = new GetPhysicalPropertiesCommandLineOptions();
    private static LaunchCommandLineOptions LAUNCH_OPTIONS = new LaunchCommandLineOptions();

    protected PrintStream suppressOutput() {
        PrintStream originalStream = System.out;
        if (this.raw) {
            PrintStream dummyStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            System.setOut(dummyStream);
        }
        return originalStream;
    }

    protected void restoreOutput(PrintStream originalStream) {
        if (this.raw) {
            System.setOut(originalStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppPackage newAppPackageInstance(File f) throws IOException, ZipException {
        PrintStream outputStream = this.suppressOutput();
        try {
            AppPackage appPackage = new AppPackage(f, true);
            return appPackage;
        }
        finally {
            this.restoreOutput(outputStream);
        }
    }

    private StramAppLauncher getStramAppLauncher(String jarfileUri, Configuration config, boolean ignorePom) throws Exception {
        URI uri = new URI(jarfileUri);
        String scheme = uri.getScheme();
        StramAppLauncher appLauncher = null;
        if (scheme == null || scheme.equals("file")) {
            File jf = new File(uri.getPath());
            appLauncher = new StramAppLauncher(jf, config);
        } else {
            try (FileSystem tmpFs = FileSystem.newInstance((URI)uri, (Configuration)this.conf);){
                Path path = new Path(uri.getPath());
                appLauncher = new StramAppLauncher(tmpFs, path, config);
            }
        }
        if (appLauncher != null) {
            if (this.verboseLevel > 0) {
                System.err.print(appLauncher.getMvnBuildClasspathOutput());
            }
            return appLauncher;
        }
        throw new CliException("Scheme " + scheme + " not supported.");
    }

    ApexCli() {
        this.globalCommands.put("help", new CommandSpec(new HelpCommand(), null, new Arg[]{new CommandArg("command")}, "Show help"));
        this.globalCommands.put("echo", new CommandSpec(new EchoCommand(), null, new Arg[]{new VarArg("arg")}, "Echo the arguments"));
        this.globalCommands.put("connect", new CommandSpec(new ConnectCommand(), new Arg[]{new Arg("app-id")}, null, "Connect to an app"));
        this.globalCommands.put("launch", new OptionsCommandSpec(new LaunchCommand(), new Arg[0], new Arg[]{new FileArg("jar-file/json-file/properties-file/app-package-file"), new Arg("matching-app-name")}, "Launch an app", ApexCli.LAUNCH_OPTIONS.options));
        this.globalCommands.put("shutdown-app", new CommandSpec(new ShutdownAppCommand(), new Arg[]{new Arg("app-id")}, new Arg[]{new VarArg("app-id")}, "Shutdown an app"));
        this.globalCommands.put("list-apps", new CommandSpec(new ListAppsCommand(), null, new Arg[]{new Arg("pattern")}, "List applications"));
        this.globalCommands.put("kill-app", new CommandSpec(new KillAppCommand(), new Arg[]{new Arg("app-id/app-name")}, new Arg[]{new VarArg("app-id/app-name")}, "Kill an app"));
        this.globalCommands.put("show-logical-plan", new OptionsCommandSpec(new ShowLogicalPlanCommand(), new Arg[]{new FileArg("jar-file/app-package-file")}, new Arg[]{new Arg("class-name")}, "List apps in a jar or show logical plan of an app class", ApexCli.getShowLogicalPlanCommandLineOptions()));
        this.globalCommands.put("get-jar-operator-classes", new OptionsCommandSpec(new GetJarOperatorClassesCommand(), new Arg[]{new FileArg("jar-files-comma-separated")}, new Arg[]{new Arg("search-term")}, "List operators in a jar list", ApexCli.GET_OPERATOR_CLASSES_OPTIONS.options));
        this.globalCommands.put("get-jar-operator-properties", new CommandSpec(new GetJarOperatorPropertiesCommand(), new Arg[]{new FileArg("jar-files-comma-separated"), new Arg("operator-class-name")}, null, "List properties in specified operator"));
        this.globalCommands.put("alias", new CommandSpec(new AliasCommand(), new Arg[]{new Arg("alias-name"), new CommandArg("command")}, null, "Create a command alias"));
        this.globalCommands.put("source", new CommandSpec(new SourceCommand(), new Arg[]{new FileArg("file")}, null, "Execute the commands in a file"));
        this.globalCommands.put("exit", new CommandSpec(new ExitCommand(), null, null, "Exit the CLI"));
        this.globalCommands.put("begin-macro", new CommandSpec(new BeginMacroCommand(), new Arg[]{new Arg("name")}, null, "Begin Macro Definition ($1...$9 to access parameters and type 'end' to end the definition)"));
        this.globalCommands.put("dump-properties-file", new CommandSpec(new DumpPropertiesFileCommand(), new Arg[]{new FileArg("out-file"), new FileArg("jar-file"), new Arg("app-name")}, null, "Dump the properties file of an app class"));
        this.globalCommands.put("get-app-info", new CommandSpec(new GetAppInfoCommand(), new Arg[]{new Arg("app-id")}, null, "Get the information of an app"));
        this.globalCommands.put("set-pager", new CommandSpec(new SetPagerCommand(), new Arg[]{new Arg("on/off")}, null, "Set the pager program for output"));
        this.globalCommands.put("get-config-parameter", new CommandSpec(new GetConfigParameterCommand(), null, new Arg[]{new FileArg("parameter-name")}, "Get the configuration parameter"));
        this.globalCommands.put("get-app-package-info", new CommandSpec(new GetAppPackageInfoCommand(), new Arg[]{new FileArg("app-package-file")}, null, "Get info on the app package file"));
        this.globalCommands.put("get-app-package-operators", new OptionsCommandSpec(new GetAppPackageOperatorsCommand(), new Arg[]{new FileArg("app-package-file")}, new Arg[]{new Arg("search-term")}, "Get operators within the given app package", ApexCli.GET_OPERATOR_CLASSES_OPTIONS.options));
        this.globalCommands.put("get-app-package-operator-properties", new CommandSpec(new GetAppPackageOperatorPropertiesCommand(), new Arg[]{new FileArg("app-package-file"), new Arg("operator-class")}, null, "Get operator properties within the given app package"));
        this.globalCommands.put("list-default-app-attributes", new CommandSpec(new ListDefaultAttributesCommand(AttributesType.APPLICATION), null, null, "Lists the default application attributes"));
        this.globalCommands.put("list-default-operator-attributes", new CommandSpec(new ListDefaultAttributesCommand(AttributesType.OPERATOR), null, null, "Lists the default operator attributes"));
        this.globalCommands.put("list-default-port-attributes", new CommandSpec(new ListDefaultAttributesCommand(AttributesType.PORT), null, null, "Lists the default port attributes"));
        this.globalCommands.put("clean-app-directories", new CommandSpec(new CleanAppDirectoriesCommand(), new Arg[]{new Arg("duration-in-millis")}, null, "Clean up data directories of applications that terminated the given milliseconds ago"));
        this.connectedCommands.put("list-containers", new CommandSpec(new ListContainersCommand(), null, null, "List containers"));
        this.connectedCommands.put("list-operators", new CommandSpec(new ListOperatorsCommand(), null, new Arg[]{new Arg("pattern")}, "List operators"));
        this.connectedCommands.put("show-physical-plan", new CommandSpec(new ShowPhysicalPlanCommand(), null, null, "Show physical plan"));
        this.connectedCommands.put("kill-container", new CommandSpec(new KillContainerCommand(), new Arg[]{new Arg("container-id")}, new Arg[]{new VarArg("container-id")}, "Kill a container"));
        this.connectedCommands.put("shutdown-app", new CommandSpec(new ShutdownAppCommand(), null, new Arg[]{new VarArg("app-id")}, "Shutdown an app"));
        this.connectedCommands.put("kill-app", new CommandSpec(new KillAppCommand(), null, new Arg[]{new VarArg("app-id/app-name")}, "Kill an app"));
        this.connectedCommands.put("wait", new CommandSpec(new WaitCommand(), new Arg[]{new Arg("timeout")}, null, "Wait for completion of current application"));
        this.connectedCommands.put("start-recording", new CommandSpec(new StartRecordingCommand(), new Arg[]{new Arg("operator-id")}, new Arg[]{new Arg("port-name"), new Arg("num-windows")}, "Start recording"));
        this.connectedCommands.put("stop-recording", new CommandSpec(new StopRecordingCommand(), new Arg[]{new Arg("operator-id")}, new Arg[]{new Arg("port-name")}, "Stop recording"));
        this.connectedCommands.put("get-operator-attributes", new CommandSpec(new GetOperatorAttributesCommand(), new Arg[]{new Arg("operator-name")}, new Arg[]{new Arg("attribute-name")}, "Get attributes of an operator"));
        this.connectedCommands.put("get-operator-properties", new CommandSpec(new GetOperatorPropertiesCommand(), new Arg[]{new Arg("operator-name")}, new Arg[]{new Arg("property-name")}, "Get properties of a logical operator"));
        this.connectedCommands.put("get-physical-operator-properties", new OptionsCommandSpec(new GetPhysicalOperatorPropertiesCommand(), new Arg[]{new Arg("operator-id")}, null, "Get properties of a physical operator", ApexCli.GET_PHYSICAL_PROPERTY_OPTIONS.options));
        this.connectedCommands.put("set-operator-property", new CommandSpec(new SetOperatorPropertyCommand(), new Arg[]{new Arg("operator-name"), new Arg("property-name"), new Arg("property-value")}, null, "Set a property of an operator"));
        this.connectedCommands.put("set-physical-operator-property", new CommandSpec(new SetPhysicalOperatorPropertyCommand(), new Arg[]{new Arg("operator-id"), new Arg("property-name"), new Arg("property-value")}, null, "Set a property of an operator"));
        this.connectedCommands.put("get-app-attributes", new CommandSpec(new GetAppAttributesCommand(), null, new Arg[]{new Arg("attribute-name")}, "Get attributes of the connected app"));
        this.connectedCommands.put("get-port-attributes", new CommandSpec(new GetPortAttributesCommand(), new Arg[]{new Arg("operator-name"), new Arg("port-name")}, new Arg[]{new Arg("attribute-name")}, "Get attributes of a port"));
        this.connectedCommands.put("begin-logical-plan-change", new CommandSpec(new BeginLogicalPlanChangeCommand(), null, null, "Begin Logical Plan Change"));
        this.connectedCommands.put("show-logical-plan", new OptionsCommandSpec(new ShowLogicalPlanCommand(), null, new Arg[]{new FileArg("jar-file/app-package-file"), new Arg("class-name")}, "Show logical plan of an app class", ApexCli.getShowLogicalPlanCommandLineOptions()));
        this.connectedCommands.put("dump-properties-file", new CommandSpec(new DumpPropertiesFileCommand(), new Arg[]{new FileArg("out-file")}, new Arg[]{new FileArg("jar-file"), new Arg("class-name")}, "Dump the properties file of an app class"));
        this.connectedCommands.put("get-app-info", new CommandSpec(new GetAppInfoCommand(), null, new Arg[]{new Arg("app-id")}, "Get the information of an app"));
        this.connectedCommands.put("get-recording-info", new CommandSpec(new GetRecordingInfoCommand(), null, new Arg[]{new Arg("operator-id"), new Arg("start-time")}, "Get tuple recording info"));
        this.connectedCommands.put("get-container-stacktrace", new CommandSpec(new GetContainerStackTrace(), null, new Arg[]{new Arg("container-id")}, "Get the stack trace for the container"));
        this.logicalPlanChangeCommands.put("help", new CommandSpec(new HelpCommand(), null, new Arg[]{new Arg("command")}, "Show help"));
        this.logicalPlanChangeCommands.put("create-operator", new CommandSpec(new CreateOperatorCommand(), new Arg[]{new Arg("operator-name"), new Arg("class-name")}, null, "Create an operator"));
        this.logicalPlanChangeCommands.put("create-stream", new CommandSpec(new CreateStreamCommand(), new Arg[]{new Arg("stream-name"), new Arg("from-operator-name"), new Arg("from-port-name"), new Arg("to-operator-name"), new Arg("to-port-name")}, null, "Create a stream"));
        this.logicalPlanChangeCommands.put("add-stream-sink", new CommandSpec(new AddStreamSinkCommand(), new Arg[]{new Arg("stream-name"), new Arg("to-operator-name"), new Arg("to-port-name")}, null, "Add a sink to an existing stream"));
        this.logicalPlanChangeCommands.put("remove-operator", new CommandSpec(new RemoveOperatorCommand(), new Arg[]{new Arg("operator-name")}, null, "Remove an operator"));
        this.logicalPlanChangeCommands.put("remove-stream", new CommandSpec(new RemoveStreamCommand(), new Arg[]{new Arg("stream-name")}, null, "Remove a stream"));
        this.logicalPlanChangeCommands.put("set-operator-property", new CommandSpec(new SetOperatorPropertyCommand(), new Arg[]{new Arg("operator-name"), new Arg("property-name"), new Arg("property-value")}, null, "Set a property of an operator"));
        this.logicalPlanChangeCommands.put("set-operator-attribute", new CommandSpec(new SetOperatorAttributeCommand(), new Arg[]{new Arg("operator-name"), new Arg("attr-name"), new Arg("attr-value")}, null, "Set an attribute of an operator"));
        this.logicalPlanChangeCommands.put("set-port-attribute", new CommandSpec(new SetPortAttributeCommand(), new Arg[]{new Arg("operator-name"), new Arg("port-name"), new Arg("attr-name"), new Arg("attr-value")}, null, "Set an attribute of a port"));
        this.logicalPlanChangeCommands.put("set-stream-attribute", new CommandSpec(new SetStreamAttributeCommand(), new Arg[]{new Arg("stream-name"), new Arg("attr-name"), new Arg("attr-value")}, null, "Set an attribute of a stream"));
        this.logicalPlanChangeCommands.put("show-queue", new CommandSpec(new ShowQueueCommand(), null, null, "Show the queue of the plan change"));
        this.logicalPlanChangeCommands.put("submit", new CommandSpec(new SubmitCommand(), null, null, "Submit the plan change"));
        this.logicalPlanChangeCommands.put("abort", new CommandSpec(new AbortCommand(), null, null, "Abort the plan change"));
    }

    private void printJson(String json) throws IOException {
        PrintStream os = this.getOutputPrintStream();
        if (this.jsonp != null) {
            os.println(this.jsonp + "(" + json + ");");
        } else {
            os.println(json);
        }
        os.flush();
        this.closeOutputPrintStream(os);
    }

    private void printJson(JSONObject json) throws JSONException, IOException {
        this.printJson(this.raw ? json.toString() : json.toString(2));
    }

    private void printJson(JSONArray jsonArray, String name) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        json.put(name, (Object)jsonArray);
        this.printJson(json);
    }

    private <K, V> void printJson(Map<K, V> map) throws IOException, JSONException {
        this.printJson(new JSONObject(this.mapper.writeValueAsString(map)));
    }

    private <T> void printJson(List<T> list, String name) throws IOException, JSONException {
        this.printJson(new JSONArray(this.mapper.writeValueAsString(list)), name);
    }

    private PrintStream getOutputPrintStream() throws IOException {
        if (this.pagerCommand == null) {
            this.pagerProcess = null;
            return System.out;
        }
        this.pagerProcess = Runtime.getRuntime().exec(new String[]{"sh", "-c", this.pagerCommand + " >/dev/tty"});
        return new PrintStream(this.pagerProcess.getOutputStream());
    }

    private void closeOutputPrintStream(PrintStream os) {
        if (os != System.out) {
            os.close();
            try {
                this.pagerProcess.waitFor();
            }
            catch (InterruptedException ex) {
                LOG.debug("Interrupted");
            }
        }
    }

    private static String expandFileName(String fileName, boolean expandWildCard) throws IOException {
        if (fileName.matches("^[a-zA-Z]+:.*")) {
            return fileName;
        }
        if (fileName.startsWith("~" + File.separator)) {
            fileName = System.getProperty("user.home") + fileName.substring(1);
        }
        fileName = new File(fileName).getCanonicalPath();
        if (expandWildCard) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{fileName});
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            if (files.length == 0) {
                throw new CliException(fileName + " does not match any file");
            }
            if (files.length > 1) {
                throw new CliException(fileName + " matches more than one file");
            }
            return files[0];
        }
        return fileName;
    }

    private static String[] expandFileNames(String fileName) throws IOException {
        if (fileName.matches("^[a-zA-Z]+:.*")) {
            return new String[]{fileName};
        }
        if (fileName.startsWith("~" + File.separator)) {
            fileName = System.getProperty("user.home") + fileName.substring(1);
        }
        fileName = new File(fileName).getCanonicalPath();
        LOG.debug("Canonical path: {}", (Object)fileName);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(new String[]{fileName});
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static String expandCommaSeparatedFiles(String filenames) throws IOException {
        String[] entries = filenames.split(",");
        StringBuilder result = new StringBuilder(filenames.length());
        for (String entry : entries) {
            for (String file : ApexCli.expandFileNames(entry)) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(file);
            }
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    protected ApplicationReport getApplicationByName(String appName) {
        if (appName == null) {
            throw new CliException("Invalid application name provided by user");
        }
        List<ApplicationReport> appList = this.getApplicationList();
        for (ApplicationReport ar : appList) {
            if (!ar.getName().equals(appName) || ar.getYarnApplicationState() == YarnApplicationState.KILLED || ar.getYarnApplicationState() == YarnApplicationState.FINISHED) continue;
            LOG.debug("Application Name: {} Application ID: {} Application State: {}", new Object[]{ar.getName(), ar.getApplicationId().toString(), YarnApplicationState.FINISHED});
            return ar;
        }
        return null;
    }

    protected ApplicationReport getApplication(String appId) {
        List<ApplicationReport> appList = this.getApplicationList();
        if (StringUtils.isNumeric((String)appId)) {
            int appSeq = Integer.parseInt(appId);
            for (ApplicationReport ar : appList) {
                if (ar.getApplicationId().getId() != appSeq) continue;
                return ar;
            }
        } else {
            for (ApplicationReport ar : appList) {
                if (!ar.getApplicationId().toString().equals(appId)) continue;
                return ar;
            }
        }
        return null;
    }

    public void preImpersonationInit(String[] args) throws IOException {
        Level logLevel;
        Signal.handle(new Signal("INT"), new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                System.out.println("^C");
                if (ApexCli.this.commandThread != null) {
                    ApexCli.this.commandThread.interrupt();
                    ApexCli.this.mainThread.interrupt();
                } else {
                    System.out.print(ApexCli.this.prompt);
                    System.out.flush();
                }
            }
        });
        this.consolePresent = System.console() != null;
        Options options = new Options();
        options.addOption("e", true, "Commands are read from the argument");
        options.addOption("v", false, "Verbose mode level 1");
        options.addOption("vv", false, "Verbose mode level 2");
        options.addOption("vvv", false, "Verbose mode level 3");
        options.addOption("vvvv", false, "Verbose mode level 4");
        options.addOption("r", false, "JSON Raw mode");
        options.addOption("p", true, "JSONP padding function");
        options.addOption("h", false, "Print this help");
        options.addOption("f", true, "Use the specified prompt at all time");
        options.addOption("kp", true, "Use the specified kerberos principal");
        options.addOption("kt", true, "Use the specified kerberos keytab");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("v")) {
                this.verboseLevel = 1;
            }
            if (cmd.hasOption("vv")) {
                this.verboseLevel = 2;
            }
            if (cmd.hasOption("vvv")) {
                this.verboseLevel = 3;
            }
            if (cmd.hasOption("vvvv")) {
                this.verboseLevel = 4;
            }
            if (cmd.hasOption("r")) {
                this.raw = true;
            }
            if (cmd.hasOption("e")) {
                this.commandsToExecute = cmd.getOptionValues("e");
                this.consolePresent = false;
            }
            if (cmd.hasOption("p")) {
                this.jsonp = cmd.getOptionValue("p");
            }
            if (cmd.hasOption("f")) {
                this.forcePrompt = cmd.getOptionValue("f");
            }
            if (cmd.hasOption("h")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp(ApexCli.class.getSimpleName(), options);
                System.exit(0);
            }
            if (cmd.hasOption("kp")) {
                this.kerberosPrincipal = cmd.getOptionValue("kp");
            }
            if (cmd.hasOption("kt")) {
                this.kerberosKeyTab = cmd.getOptionValue("kt");
            }
        }
        catch (ParseException ex) {
            System.err.println("Invalid argument: " + (Object)((Object)ex));
            System.exit(1);
        }
        if (this.kerberosPrincipal == null && this.kerberosKeyTab != null) {
            System.err.println("Kerberos key tab is specified but not the kerberos principal. Please specify it using the -kp option.");
            System.exit(1);
        }
        if (this.kerberosPrincipal != null && this.kerberosKeyTab == null) {
            System.err.println("Kerberos principal is specified but not the kerberos key tab. Please specify it using the -kt option.");
            System.exit(1);
        }
        switch (this.verboseLevel) {
            case 0: {
                logLevel = Level.OFF;
                break;
            }
            case 1: {
                logLevel = Level.ERROR;
                break;
            }
            case 2: {
                logLevel = Level.WARN;
                break;
            }
            case 3: {
                logLevel = Level.INFO;
                break;
            }
            default: {
                logLevel = Level.DEBUG;
            }
        }
        for (org.apache.log4j.Logger logger : new org.apache.log4j.Logger[]{org.apache.log4j.Logger.getRootLogger(), org.apache.log4j.Logger.getLogger(ApexCli.class)}) {
            logger.setLevel(logLevel);
            Enumeration allAppenders = logger.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender appender = (Appender)allAppenders.nextElement();
                if (!(appender instanceof ConsoleAppender)) continue;
                ((ConsoleAppender)appender).setThreshold((Priority)logLevel);
            }
        }
        if (this.commandsToExecute != null) {
            for (String string : this.commandsToExecute) {
                LOG.debug("Command to be executed: {}", (Object)string);
            }
        }
        if (this.kerberosPrincipal != null && this.kerberosKeyTab != null) {
            StramUserLogin.authenticate(this.kerberosPrincipal, this.kerberosKeyTab);
        } else {
            YarnConfiguration yarnConfiguration = new YarnConfiguration();
            StramClientUtils.addDTLocalResources((Configuration)yarnConfiguration);
            StramUserLogin.attemptAuthentication((Configuration)yarnConfiguration);
        }
    }

    public void init() throws IOException {
        int colon;
        this.conf = StramClientUtils.addDTSiteResources((Configuration)new YarnConfiguration());
        SecurityUtils.init(this.conf);
        this.fs = StramClientUtils.newFileSystemInstance(this.conf);
        this.stramAgent = new StramAgent(this.fs, this.conf);
        this.yarnClient.init(this.conf);
        this.yarnClient.start();
        LOG.debug("Yarn Client initialized and started");
        String socks = this.conf.get("hadoop.socks.server");
        if (socks != null && (colon = socks.indexOf(58)) > 0) {
            LOG.info("Using socks proxy at {}", (Object)socks);
            System.setProperty("socksProxyHost", socks.substring(0, colon));
            System.setProperty("socksProxyPort", socks.substring(colon + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSourceFile(String fileName, ConsoleReader reader) throws FileNotFoundException, IOException {
        fileName = ApexCli.expandFileName(fileName, true);
        LOG.debug("Sourcing {}", (Object)fileName);
        boolean consolePresentSaved = this.consolePresent;
        this.consolePresent = false;
        FileLineReader fr = null;
        try {
            String line;
            fr = new FileLineReader(fileName);
            while ((line = fr.readLine("")) != null) {
                this.processLine(line, fr, true);
            }
        }
        finally {
            this.consolePresent = consolePresentSaved;
            if (fr != null) {
                fr.close();
            }
        }
    }

    private List<Completer> defaultCompleters() {
        TreeMap<String, CommandSpec> commands = new TreeMap<String, CommandSpec>();
        commands.putAll(this.logicalPlanChangeCommands);
        commands.putAll(this.connectedCommands);
        commands.putAll(this.globalCommands);
        LinkedList<Completer> completers = new LinkedList<Completer>();
        for (Map.Entry entry : commands.entrySet()) {
            String command = (String)entry.getKey();
            CommandSpec cs = (CommandSpec)entry.getValue();
            LinkedList<Object> argCompleters = new LinkedList<Object>();
            argCompleters.add(new StringsCompleter(new String[]{command}));
            Arg[] args = (Arg[])ArrayUtils.addAll((Object[])cs.requiredArgs, (Object[])cs.optionalArgs);
            if (args != null) {
                if (cs instanceof OptionsCommandSpec) {
                    if (args[0] instanceof FileArg || args[0] instanceof VarArg) {
                        for (int i = 0; i < 10; ++i) {
                            argCompleters.add((Object)new MyFileNameCompleter());
                        }
                    }
                } else {
                    for (Arg arg : args) {
                        if (arg instanceof FileArg || arg instanceof VarArg) {
                            argCompleters.add((Object)new MyFileNameCompleter());
                            continue;
                        }
                        if (arg instanceof CommandArg) {
                            argCompleters.add(new StringsCompleter(commands.keySet().toArray(new String[0])));
                            continue;
                        }
                        argCompleters.add(MyNullCompleter.INSTANCE);
                    }
                }
            }
            completers.add((Completer)new ArgumentCompleter(argCompleters));
        }
        LinkedList<Object> argCompleters = new LinkedList<Object>();
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.aliases.keySet());
        set.addAll(this.macros.keySet());
        argCompleters.add(new StringsCompleter(set.toArray(new String[0])));
        for (int i = 0; i < 10; ++i) {
            argCompleters.add((Object)new MyFileNameCompleter());
        }
        completers.add((Completer)new ArgumentCompleter(argCompleters));
        return completers;
    }

    private void setupCompleter(ConsoleReader reader) {
        reader.addCompleter((Completer)new AggregateCompleter(this.defaultCompleters()));
    }

    private void updateCompleter(ConsoleReader reader) {
        ArrayList completers = new ArrayList(reader.getCompleters());
        for (Completer c : completers) {
            reader.removeCompleter(c);
        }
        this.setupCompleter(reader);
    }

    private void setupHistory(ConsoleReader reader) {
        File historyFile = new File(StramClientUtils.getUserDTDirectory(), "cli_history");
        historyFile.getParentFile().mkdirs();
        try {
            this.topLevelHistory = new FileHistory(historyFile);
            reader.setHistory((History)this.topLevelHistory);
            historyFile = new File(StramClientUtils.getUserDTDirectory(), "cli_history_clp");
            this.changingLogicalPlanHistory = new FileHistory(historyFile);
        }
        catch (IOException ex) {
            System.err.printf("Unable to open %s for writing.", historyFile);
        }
    }

    private void setupAgents() throws IOException {
        this.recordingsAgent = new RecordingsAgent(this.stramAgent);
    }

    public void run() throws IOException {
        ConsoleReader reader = new ConsoleReader();
        reader.setExpandEvents(false);
        reader.setBellEnabled(false);
        try {
            this.processSourceFile(StramClientUtils.getConfigDir() + "/clirc_system", reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.processSourceFile(StramClientUtils.getUserDTDirectory() + "/clirc", reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.consolePresent) {
            this.printWelcomeMessage();
            this.setupCompleter(reader);
            this.setupHistory(reader);
        } else {
            reader.setEchoCharacter(Character.valueOf('\u0000'));
        }
        this.setupAgents();
        PrintWriter out = new PrintWriter(System.out);
        int i = 0;
        while (true) {
            String line;
            if (this.commandsToExecute != null) {
                if (i >= this.commandsToExecute.length) break;
                line = this.commandsToExecute[i++];
            } else {
                line = this.readLine(reader);
                if (line == null) break;
            }
            this.processLine(line, reader, true);
            out.flush();
        }
        if (this.topLevelHistory != null) {
            try {
                this.topLevelHistory.flush();
            }
            catch (IOException ex) {
                LOG.warn("Cannot flush command history", (Throwable)ex);
            }
        }
        if (this.changingLogicalPlanHistory != null) {
            try {
                this.changingLogicalPlanHistory.flush();
            }
            catch (IOException ex) {
                LOG.warn("Cannot flush command history", (Throwable)ex);
            }
        }
        if (this.consolePresent) {
            System.out.println("exit");
        }
    }

    private List<String> expandMacro(List<String> lines, String[] args) {
        ArrayList<String> expandedLines = new ArrayList<String>();
        block0: for (String line : lines) {
            int previousIndex = 0;
            StringBuilder expandedLine = new StringBuilder(line.length());
            while (true) {
                int currentIndex;
                if ((currentIndex = line.indexOf(36, previousIndex)) > 0 && line.length() > currentIndex + 1) {
                    int argIndex = line.charAt(currentIndex + 1) - 48;
                    if (args.length > argIndex && argIndex >= 0) {
                        expandedLine.append(line.substring(previousIndex, currentIndex)).append(args[argIndex]);
                    } else if (argIndex >= 0 && argIndex <= 9) {
                        expandedLine.append(line.substring(previousIndex, currentIndex));
                    } else {
                        expandedLine.append(line.substring(previousIndex, currentIndex + 2));
                    }
                } else {
                    expandedLine.append(line.substring(previousIndex));
                    expandedLines.add(expandedLine.toString());
                    continue block0;
                }
                previousIndex = currentIndex += 2;
            }
        }
        return expandedLines;
    }

    private static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    private void processLine(String line, final ConsoleReader reader, boolean expandMacroAlias) {
        try {
            List<String[]> commands;
            History history;
            Thread.interrupted();
            if (reader.isHistoryEnabled() && (history = reader.getHistory()) instanceof FileHistory) {
                try {
                    ((FileHistory)history).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((commands = this.tokenizer.tokenize(line)) == null) {
                return;
            }
            for (final String[] args : commands) {
                if (args.length == 0 || StringUtils.isBlank((String)args[0])) continue;
                if (expandMacroAlias) {
                    if (this.macros.containsKey(args[0])) {
                        List<String> macroItems = this.expandMacro(this.macros.get(args[0]), args);
                        for (String macroItem : macroItems) {
                            if (this.consolePresent) {
                                System.out.println("expanded-macro> " + macroItem);
                            }
                            this.processLine(macroItem, reader, false);
                        }
                        continue;
                    }
                    if (this.aliases.containsKey(args[0])) {
                        this.processLine(this.aliases.get(args[0]), reader, false);
                        continue;
                    }
                }
                CommandSpec cs = null;
                if (this.changingLogicalPlan) {
                    cs = this.logicalPlanChangeCommands.get(args[0]);
                } else {
                    if (this.currentApp != null) {
                        cs = this.connectedCommands.get(args[0]);
                    }
                    if (cs == null) {
                        cs = this.globalCommands.get(args[0]);
                    }
                }
                if (cs == null) {
                    if (this.connectedCommands.get(args[0]) != null) {
                        System.err.println("\"" + args[0] + "\" is valid only when connected to an application. Type \"connect <appid>\" to connect to an application.");
                        lastCommandError = true;
                        continue;
                    }
                    if (this.logicalPlanChangeCommands.get(args[0]) != null) {
                        System.err.println("\"" + args[0] + "\" is valid only when changing a logical plan.  Type \"begin-logical-plan-change\" to change a logical plan");
                        lastCommandError = true;
                        continue;
                    }
                    System.err.println("Invalid command '" + args[0] + "'. Type \"help\" for list of commands");
                    lastCommandError = true;
                    continue;
                }
                try {
                    cs.verifyArguments(args);
                }
                catch (CliException ex) {
                    cs.printUsage(args[0]);
                    throw ex;
                }
                final Command command = cs.command;
                this.commandThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            command.execute(args, reader);
                            lastCommandError = false;
                        }
                        catch (Exception e) {
                            ApexCli.this.handleException(e);
                        }
                        catch (Error e) {
                            ApexCli.this.handleException(e);
                            System.err.println("Fatal error encountered");
                            System.exit(1);
                        }
                    }
                };
                this.mainThread = Thread.currentThread();
                this.commandThread.start();
                try {
                    this.commandThread.join();
                }
                catch (InterruptedException ex) {
                    System.err.println("Interrupted");
                }
                this.commandThread = null;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable e) {
        System.err.println(ExceptionUtils.getFullStackTrace((Throwable)e));
        LOG.error("Exception caught: ", e);
        lastCommandError = true;
    }

    private void printWelcomeMessage() {
        VersionInfo v = VersionInfo.APEX_VERSION;
        System.out.println("Apex CLI " + v.getVersion() + " " + v.getDate() + " " + v.getRevision());
    }

    private void printHelp(String command, CommandSpec commandSpec, PrintStream os) {
        OptionsCommandSpec ocs;
        if (this.consolePresent) {
            os.print("\u001b[0;93m");
            os.print(command);
            os.print("\u001b[0m");
        } else {
            os.print(command);
        }
        if (commandSpec instanceof OptionsCommandSpec) {
            ocs = (OptionsCommandSpec)commandSpec;
            if (ocs.options != null) {
                os.print(" [options]");
            }
        }
        if (commandSpec.requiredArgs != null) {
            for (Arg arg : commandSpec.requiredArgs) {
                if (this.consolePresent) {
                    os.print(" \u001b[3m" + arg + "\u001b[0m");
                    continue;
                }
                os.print(" <" + arg + ">");
            }
        }
        if (commandSpec.optionalArgs != null) {
            for (Arg arg : commandSpec.optionalArgs) {
                if (this.consolePresent) {
                    os.print(" [\u001b[3m" + arg + "\u001b[0m");
                } else {
                    os.print(" [<" + arg + ">");
                }
                if (arg instanceof VarArg) {
                    os.print(" ...");
                }
                os.print("]");
            }
        }
        os.println("\n\t" + commandSpec.description);
        if (commandSpec instanceof OptionsCommandSpec) {
            ocs = (OptionsCommandSpec)commandSpec;
            if (ocs.options != null) {
                os.println("\tOptions:");
                HelpFormatter formatter = new HelpFormatter();
                PrintWriter pw = new PrintWriter(os);
                formatter.printOptions(pw, 80, ocs.options, 12, 4);
                pw.flush();
            }
        }
    }

    private void printHelp(Map<String, CommandSpec> commandSpecs, PrintStream os) {
        for (Map.Entry<String, CommandSpec> entry : commandSpecs.entrySet()) {
            this.printHelp(entry.getKey(), entry.getValue(), os);
        }
    }

    private String readLine(ConsoleReader reader) throws IOException {
        String line;
        if (this.forcePrompt == null) {
            this.prompt = "";
            if (this.consolePresent) {
                this.prompt = this.changingLogicalPlan ? "logical-plan-change" : "apex";
                if (this.currentApp != null) {
                    this.prompt = this.prompt + " (";
                    this.prompt = this.prompt + this.currentApp.getApplicationId().toString();
                    this.prompt = this.prompt + ") ";
                }
                this.prompt = this.prompt + "> ";
            }
        } else {
            this.prompt = this.forcePrompt;
        }
        if ((line = reader.readLine(this.prompt, this.consolePresent ? null : Character.valueOf('\u0000'))) == null) {
            return null;
        }
        return ApexCli.ltrim(line);
    }

    private List<ApplicationReport> getApplicationList() {
        try {
            return StramUtils.getApexApplicationList(this.yarnClient);
        }
        catch (Exception e) {
            throw new CliException("Error getting application list from resource manager", e);
        }
    }

    private String getContainerLongId(String containerId) {
        JSONObject json = this.getResource("physicalPlan/containers", this.currentApp);
        int shortId = 0;
        if (StringUtils.isNumeric((String)containerId)) {
            shortId = Integer.parseInt(containerId);
        }
        try {
            JSONArray containers;
            Object containersObj = json.get("containers");
            if (containersObj instanceof JSONArray) {
                containers = (JSONArray)containersObj;
            } else {
                containers = new JSONArray();
                containers.put(containersObj);
            }
            if (containersObj != null) {
                int o = containers.length();
                while (o-- > 0) {
                    JSONObject container = containers.getJSONObject(o);
                    String id = container.getString("id");
                    if (!id.equals(containerId) && (shortId == 0 || !id.endsWith("_" + shortId) && !id.endsWith("0" + shortId))) continue;
                    return id;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private ApplicationReport assertRunningApp(ApplicationReport app) {
        ApplicationReport r;
        try {
            r = this.yarnClient.getApplicationReport(app.getApplicationId());
            if (r.getYarnApplicationState() != YarnApplicationState.RUNNING) {
                String msg = String.format("Application %s not running (status %s)", r.getApplicationId().getId(), r.getYarnApplicationState());
                throw new CliException(msg);
            }
        }
        catch (YarnException rmExc) {
            throw new CliException("Unable to determine application status", rmExc);
        }
        catch (IOException rmExc) {
            throw new CliException("Unable to determine application status", rmExc);
        }
        return r;
    }

    private JSONObject getResource(String resourcePath, ApplicationReport appReport) {
        return this.getResource(new StramAgent.StramUriSpec().path(resourcePath), appReport, new WebServicesClient.GetWebServicesHandler());
    }

    private JSONObject getResource(StramAgent.StramUriSpec uriSpec, ApplicationReport appReport) {
        return this.getResource(uriSpec, appReport, new WebServicesClient.GetWebServicesHandler());
    }

    private JSONObject getResource(StramAgent.StramUriSpec uriSpec, ApplicationReport appReport, WebServicesClient.WebServicesHandler handler) {
        if (appReport == null) {
            throw new CliException("No application selected");
        }
        if (StringUtils.isEmpty((String)appReport.getTrackingUrl()) || appReport.getFinalApplicationStatus() != FinalApplicationStatus.UNDEFINED) {
            appReport = null;
            throw new CliException("Application terminated");
        }
        WebServicesClient wsClient = new WebServicesClient();
        try {
            return this.stramAgent.issueStramWebRequest(wsClient, appReport.getApplicationId().toString(), uriSpec, handler);
        }
        catch (Exception e) {
            if (appReport == this.currentApp) {
                this.currentApp = this.assertRunningApp(appReport);
            }
            throw new CliException("Failed to request web service for appid " + appReport.getApplicationId().toString(), e);
        }
    }

    private List<StramAppLauncher.AppFactory> getMatchingAppFactories(StramAppLauncher submitApp, String matchString, boolean exactMatch) {
        try {
            List<StramAppLauncher.AppFactory> cfgList = submitApp.getBundledTopologies();
            if (cfgList.isEmpty()) {
                return null;
            }
            if (matchString == null) {
                return cfgList;
            }
            ArrayList<StramAppLauncher.AppFactory> result = new ArrayList<StramAppLauncher.AppFactory>();
            if (!exactMatch) {
                matchString = matchString.toLowerCase();
            }
            for (StramAppLauncher.AppFactory ac : cfgList) {
                String appName = ac.getName();
                String appAlias = submitApp.getLogicalPlanConfiguration().getAppAlias(appName);
                if (exactMatch) {
                    if (!matchString.equals(appName) && !matchString.equals(appAlias)) continue;
                    result.add(ac);
                    continue;
                }
                if (!appName.toLowerCase().contains(matchString) && (appAlias == null || !appAlias.toLowerCase().contains(matchString))) continue;
                result.add(ac);
            }
            return result;
        }
        catch (Exception ex) {
            LOG.warn("Caught Exception: ", (Throwable)ex);
            return null;
        }
    }

    private File copyToLocal(String[] files) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir") + "/datatorrent/" + ManagementFactory.getRuntimeMXBean().getName());
        tmpDir.mkdirs();
        for (int i = 0; i < files.length; ++i) {
            try {
                URI uri = new URI(files[i]);
                String scheme = uri.getScheme();
                if (scheme == null || scheme.equals("file")) {
                    files[i] = uri.getPath();
                    continue;
                }
                try (FileSystem tmpFs = FileSystem.newInstance((URI)uri, (Configuration)this.conf);){
                    Path srcPath = new Path(uri.getPath());
                    Path dstPath = new Path(tmpDir.getAbsolutePath(), String.valueOf(i) + srcPath.getName());
                    tmpFs.copyToLocalFile(srcPath, dstPath);
                    files[i] = dstPath.toUri().getPath();
                    continue;
                }
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return tmpDir;
    }

    private static GetOperatorClassesCommandLineInfo getGetOperatorClassesCommandLineInfo(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        GetOperatorClassesCommandLineInfo result = new GetOperatorClassesCommandLineInfo();
        CommandLine line = parser.parse(ApexCli.GET_OPERATOR_CLASSES_OPTIONS.options, args);
        result.parent = line.getOptionValue("parent");
        result.args = line.getArgs();
        return result;
    }

    private void checkConfigPackageCompatible(AppPackage ap, ConfigPackage cp) {
        if (cp == null) {
            return;
        }
        String requiredAppPackageName = cp.getAppPackageName();
        String requiredAppPackageGroupId = cp.getAppPackageGroupId();
        if (requiredAppPackageName != null && !requiredAppPackageName.equals(ap.getAppPackageName())) {
            throw new CliException("Config package requires an app package name of \"" + requiredAppPackageName + "\". The app package given has the name of \"" + ap.getAppPackageName() + "\"");
        }
        if (requiredAppPackageGroupId != null && !requiredAppPackageGroupId.equals(ap.getAppPackageGroupId())) {
            throw new CliException("Config package requires an app package group id of \"" + requiredAppPackageGroupId + "\". The app package given has the groupId of \"" + ap.getAppPackageGroupId() + "\"");
        }
        String requiredAppPackageMinVersion = cp.getAppPackageMinVersion();
        if (requiredAppPackageMinVersion != null && VersionInfo.compare(requiredAppPackageMinVersion, ap.getAppPackageVersion()) > 0) {
            throw new CliException("Config package requires an app package minimum version of \"" + requiredAppPackageMinVersion + "\". The app package given is of version \"" + ap.getAppPackageVersion() + "\"");
        }
        String requiredAppPackageMaxVersion = cp.getAppPackageMaxVersion();
        if (requiredAppPackageMaxVersion != null && VersionInfo.compare(requiredAppPackageMaxVersion, ap.getAppPackageVersion()) < 0) {
            throw new CliException("Config package requires an app package maximum version of \"" + requiredAppPackageMaxVersion + "\". The app package given is of version \"" + ap.getAppPackageVersion() + "\"");
        }
    }

    private void checkPlatformCompatible(AppPackage ap) {
        String apVersion = ap.getDtEngineVersion();
        VersionInfo actualVersion = VersionInfo.APEX_VERSION;
        if (!VersionInfo.isCompatible(actualVersion.getVersion(), apVersion)) {
            throw new CliException("This App Package is compiled with Apache Apex Core API version " + apVersion + ", which is incompatible with this Apex Core version " + actualVersion.getVersion());
        }
    }

    private void launchAppPackage(AppPackage ap, ConfigPackage cp, LaunchCommandLineInfo commandLineInfo, ConsoleReader reader) throws Exception {
        new LaunchCommand().execute(this.getLaunchAppPackageArgs(ap, cp, commandLineInfo, reader), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getLaunchAppPackageArgs(AppPackage ap, ConfigPackage cp, LaunchCommandLineInfo commandLineInfo, ConsoleReader reader) throws Exception {
        String matchAppName = null;
        if (commandLineInfo.args.length > 1) {
            matchAppName = commandLineInfo.args[1];
        }
        ArrayList<AppPackage.AppInfo> applications = new ArrayList<AppPackage.AppInfo>(this.getAppsFromPackageAndConfig(ap, cp, commandLineInfo.useConfigApps));
        if (matchAppName != null) {
            Iterator it = applications.iterator();
            while (it.hasNext()) {
                AppPackage.AppInfo ai = (AppPackage.AppInfo)it.next();
                if ((!commandLineInfo.exactMatch || ai.name.equals(matchAppName)) && ai.name.toLowerCase().matches(".*" + matchAppName.toLowerCase() + ".*")) continue;
                it.remove();
            }
        }
        AppPackage.AppInfo selectedApp = null;
        if (applications.isEmpty()) {
            throw new CliException("No applications in Application Package" + (matchAppName != null ? " matching \"" + matchAppName + "\"" : ""));
        }
        if (applications.size() == 1) {
            selectedApp = (AppPackage.AppInfo)applications.get(0);
        } else {
            String optionLine;
            TreeMap<String, Integer> appNamesInAlphabeticalOrder = new TreeMap<String, Integer>();
            for (int i = 0; i < applications.size(); ++i) {
                String appName = ((AppPackage.AppInfo)applications.get((int)i)).name;
                appNamesInAlphabeticalOrder.put(appName, i);
            }
            int index = 1;
            HashMap displayIndexToOriginalUnsortedIndexMap = new HashMap();
            for (Map.Entry entry : appNamesInAlphabeticalOrder.entrySet()) {
                displayIndexToOriginalUnsortedIndexMap.put(index, entry.getValue());
                System.out.printf("%3d. %s\n", index++, entry.getKey());
            }
            if (!this.consolePresent) {
                throw new CliException("More than one application in Application Package match '" + matchAppName + "'");
            }
            boolean useHistory = reader.isHistoryEnabled();
            reader.setHistoryEnabled(false);
            History previousHistory = reader.getHistory();
            MemoryHistory dummyHistory = new MemoryHistory();
            reader.setHistory((History)dummyHistory);
            ArrayList completers = new ArrayList(reader.getCompleters());
            for (Completer c : completers) {
                reader.removeCompleter(c);
            }
            reader.setHandleUserInterrupt(true);
            try {
                optionLine = reader.readLine("Choose application: ");
            }
            finally {
                reader.setHandleUserInterrupt(false);
                reader.setHistoryEnabled(useHistory);
                reader.setHistory(previousHistory);
                for (Completer c : completers) {
                    reader.addCompleter(c);
                }
            }
            try {
                int option = Integer.parseInt(optionLine);
                if (0 < option && option <= applications.size()) {
                    int appIndex = (Integer)displayIndexToOriginalUnsortedIndexMap.get(option);
                    selectedApp = (AppPackage.AppInfo)applications.get(appIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (selectedApp == null) {
            throw new CliException("No application selected");
        }
        DTConfiguration launchProperties = this.getLaunchAppPackageProperties(ap, cp, commandLineInfo, selectedApp.name);
        String appFile = ap.tempDirectory() + "/app/" + selectedApp.file;
        ArrayList<String> launchArgs = new ArrayList<String>();
        launchArgs.add("launch");
        launchArgs.add("-exactMatch");
        ArrayList<String> absClassPath = new ArrayList<String>(ap.getClassPath());
        for (int i = 0; i < absClassPath.size(); ++i) {
            String path = (String)absClassPath.get(i);
            if (path.startsWith("/")) continue;
            absClassPath.set(i, ap.tempDirectory() + "/" + path);
        }
        if (cp != null) {
            StringBuilder files = new StringBuilder();
            for (String file : cp.getClassPath()) {
                if (files.length() != 0) {
                    files.append(',');
                }
                files.append(cp.tempDirectory()).append(File.separatorChar).append(file);
            }
            if (!StringUtils.isBlank((String)files.toString())) {
                commandLineInfo.libjars = commandLineInfo.libjars != null ? files.toString() + "," + commandLineInfo.libjars : files.toString();
            }
            files.setLength(0);
            for (String file : cp.getFiles()) {
                if (files.length() != 0) {
                    files.append(',');
                }
                files.append(cp.tempDirectory()).append(File.separatorChar).append(file);
            }
            if (!StringUtils.isBlank((String)files.toString())) {
                commandLineInfo.files = commandLineInfo.files != null ? files.toString() + "," + commandLineInfo.files : files.toString();
            }
        }
        StringBuilder libjarsVal = new StringBuilder();
        if (!absClassPath.isEmpty() || commandLineInfo.libjars != null) {
            if (!absClassPath.isEmpty()) {
                libjarsVal.append(org.apache.commons.lang3.StringUtils.join(absClassPath, (char)','));
            }
            if (commandLineInfo.libjars != null) {
                if (libjarsVal.length() > 0) {
                    libjarsVal.append(",");
                }
                libjarsVal.append(commandLineInfo.libjars);
            }
        }
        if (appFile.endsWith(".json") || appFile.endsWith(".properties")) {
            if (libjarsVal.length() > 0) {
                libjarsVal.append(",");
            }
            libjarsVal.append(ap.tempDirectory()).append("/app/*.jar");
        }
        if (libjarsVal.length() > 0) {
            launchArgs.add("-libjars");
            launchArgs.add(libjarsVal.toString());
        }
        File launchPropertiesFile = new File(ap.tempDirectory(), "launch.xml");
        launchProperties.writeToFile(launchPropertiesFile, "");
        launchArgs.add("-conf");
        launchArgs.add(launchPropertiesFile.getCanonicalPath());
        if (commandLineInfo.localMode) {
            launchArgs.add("-local");
        }
        if (commandLineInfo.archives != null) {
            launchArgs.add("-archives");
            launchArgs.add(commandLineInfo.archives);
        }
        if (commandLineInfo.files != null) {
            launchArgs.add("-files");
            launchArgs.add(commandLineInfo.files);
        }
        if (commandLineInfo.origAppId != null) {
            launchArgs.add("-originalAppId");
            launchArgs.add(commandLineInfo.origAppId);
        }
        if (commandLineInfo.queue != null) {
            launchArgs.add("-queue");
            launchArgs.add(commandLineInfo.queue);
        }
        if (commandLineInfo.tags != null) {
            launchArgs.add("-tags");
            launchArgs.add(commandLineInfo.tags);
        }
        launchArgs.add(appFile);
        if (!appFile.endsWith(".json") && !appFile.endsWith(".properties")) {
            launchArgs.add(selectedApp.name);
        }
        LOG.debug("Launch command: {}", (Object)StringUtils.join(launchArgs, (String)" "));
        return launchArgs.toArray(new String[0]);
    }

    DTConfiguration getLaunchAppPackageProperties(AppPackage ap, ConfigPackage cp, LaunchCommandLineInfo commandLineInfo, String appName) throws Exception {
        DTConfiguration givenConfig;
        DTConfiguration launchProperties = new DTConfiguration();
        List<AppPackage.AppInfo> applications = this.getAppsFromPackageAndConfig(ap, cp, commandLineInfo.useConfigApps);
        AppPackage.AppInfo selectedApp = null;
        for (AppPackage.AppInfo app : applications) {
            if (!app.name.equals(appName)) continue;
            selectedApp = app;
            break;
        }
        Map<String, String> defaultProperties = selectedApp == null ? ap.getDefaultProperties() : selectedApp.defaultProperties;
        TreeSet<String> requiredProperties = new TreeSet<String>(selectedApp == null ? ap.getRequiredProperties() : selectedApp.requiredProperties);
        for (Map.Entry<String, String> entry : defaultProperties.entrySet()) {
            launchProperties.set(entry.getKey(), entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
            requiredProperties.remove(entry.getKey());
        }
        File confFile = new File(StramClientUtils.getUserDTDirectory(), "dt-site.xml");
        if (confFile.exists()) {
            Configuration userConf = new Configuration(false);
            userConf.addResource(new Path(confFile.toURI()));
            for (Map.Entry<String, String> entry : userConf) {
                if (!((String)entry.getKey()).startsWith("dt.")) continue;
                launchProperties.set(entry.getKey(), entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
                requiredProperties.remove(entry.getKey());
            }
        }
        if (commandLineInfo.apConfigFile != null) {
            givenConfig = new DTConfiguration();
            givenConfig.loadFile(new File(ap.tempDirectory() + "/conf/" + commandLineInfo.apConfigFile));
            for (Map.Entry<String, String> entry : givenConfig) {
                launchProperties.set(entry.getKey(), entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
                requiredProperties.remove(entry.getKey());
            }
        }
        if (cp != null) {
            Map<String, String> properties = cp.getProperties(appName);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                launchProperties.set((String)entry.getKey(), (String)entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
                requiredProperties.remove(entry.getKey());
            }
        } else if (commandLineInfo.configFile != null) {
            givenConfig = new DTConfiguration();
            givenConfig.loadFile(new File(commandLineInfo.configFile));
            for (Map.Entry<String, String> entry : givenConfig) {
                launchProperties.set(entry.getKey(), entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
                requiredProperties.remove(entry.getKey());
            }
        }
        if (commandLineInfo.overrideProperties != null) {
            for (Map.Entry<String, String> entry : commandLineInfo.overrideProperties.entrySet()) {
                launchProperties.set(entry.getKey(), entry.getValue(), DTConfiguration.Scope.TRANSIENT, null);
                requiredProperties.remove(entry.getKey());
            }
        }
        for (Map.Entry<String, String> entry : this.conf) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            requiredProperties.remove(entry.getKey());
        }
        if (!requiredProperties.isEmpty()) {
            throw new CliException("Required properties not set: " + StringUtils.join(requiredProperties, (String)", "));
        }
        return launchProperties;
    }

    private List<AppPackage.AppInfo> getAppsFromPackageAndConfig(AppPackage ap, ConfigPackage cp, String configApps) {
        if (cp == null || configApps == null || !configApps.equals(CONFIG_INCLUSIVE) && !configApps.equals(CONFIG_EXCLUSIVE)) {
            return ap.getApplications();
        }
        File src = new File(cp.tempDirectory(), "app");
        File dest = new File(ap.tempDirectory(), "app");
        if (!src.exists()) {
            return ap.getApplications();
        }
        if (configApps.equals(CONFIG_EXCLUSIVE)) {
            for (File file : dest.listFiles()) {
                if (!file.getName().endsWith(".json")) continue;
                FileUtils.deleteQuietly((File)new File(dest, file.getName()));
            }
        } else {
            for (File file : src.listFiles()) {
                FileUtils.deleteQuietly((File)new File(dest, file.getName()));
            }
        }
        for (File file : src.listFiles()) {
            try {
                FileUtils.moveFileToDirectory((File)file, (File)dest, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Application from the config file {} failed while processing.", (Object)file.getName());
            }
        }
        try {
            FileUtils.deleteDirectory((File)src);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the Config Apps folder");
        }
        ap.processAppDirectory(configApps.equals(CONFIG_EXCLUSIVE));
        return ap.getApplications();
    }

    static LaunchCommandLineInfo getLaunchCommandLineInfo(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        LaunchCommandLineInfo result = new LaunchCommandLineInfo();
        CommandLine line = parser.parse(ApexCli.LAUNCH_OPTIONS.options, args);
        result.localMode = line.hasOption(ApexCli.LAUNCH_OPTIONS.local.getOpt());
        result.configFile = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.configFile.getOpt());
        result.apConfigFile = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.apConfigFile.getOpt());
        result.ignorePom = line.hasOption(ApexCli.LAUNCH_OPTIONS.ignorePom.getOpt());
        String[] defs = line.getOptionValues(ApexCli.LAUNCH_OPTIONS.defProperty.getOpt());
        if (defs != null) {
            result.overrideProperties = new HashMap<String, String>();
            for (String def : defs) {
                int equal = def.indexOf(61);
                if (equal < 0) {
                    result.overrideProperties.put(def, null);
                    continue;
                }
                result.overrideProperties.put(def.substring(0, equal), def.substring(equal + 1));
            }
        }
        result.libjars = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.libjars.getOpt());
        result.archives = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.archives.getOpt());
        result.files = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.files.getOpt());
        result.queue = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.queue.getOpt());
        result.tags = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.tags.getOpt());
        result.args = line.getArgs();
        result.origAppId = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.originalAppID.getOpt());
        result.exactMatch = line.hasOption("exactMatch");
        result.force = line.hasOption("force");
        result.useConfigApps = line.getOptionValue(ApexCli.LAUNCH_OPTIONS.useConfigApps.getOpt());
        return result;
    }

    public static Options getShowLogicalPlanCommandLineOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"comma separated list of jars");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Specify comma separated jar/resource files to include in the classpath.");
        Option libjars = OptionBuilder.create((String)"libjars");
        Option ignorePom = new Option("ignorepom", "Do not run maven to find the dependency");
        Option exactMatch = new Option("exactMatch", "Only consider exact match for app name");
        options.addOption(libjars);
        options.addOption(ignorePom);
        options.addOption(exactMatch);
        return options;
    }

    private static ShowLogicalPlanCommandLineInfo getShowLogicalPlanCommandLineInfo(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        ShowLogicalPlanCommandLineInfo result = new ShowLogicalPlanCommandLineInfo();
        CommandLine line = parser.parse(ApexCli.getShowLogicalPlanCommandLineOptions(), args);
        result.libjars = line.getOptionValue("libjars");
        result.ignorePom = line.hasOption("ignorepom");
        result.args = line.getArgs();
        result.exactMatch = line.hasOption("exactMatch");
        return result;
    }

    public void mainHelper() throws Exception {
        this.init();
        this.run();
        System.exit(lastCommandError ? 1 : 0);
    }

    public static void main(String[] args) throws Exception {
        final ApexCli shell = new ApexCli();
        shell.preImpersonationInit(args);
        String hadoopUserName = System.getenv("HADOOP_USER_NAME");
        if (UserGroupInformation.isSecurityEnabled() && StringUtils.isNotBlank((String)hadoopUserName) && !hadoopUserName.equals(UserGroupInformation.getLoginUser().getUserName())) {
            LOG.info("You ({}) are running as user {}", (Object)UserGroupInformation.getLoginUser().getUserName(), (Object)hadoopUserName);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)hadoopUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    shell.mainHelper();
                    return null;
                }
            });
        } else {
            shell.mainHelper();
        }
    }

    static /* synthetic */ void access$7200(ApexCli x0, AppPackage x1) {
        x0.checkPlatformCompatible(x1);
    }

    static /* synthetic */ void access$7300(ApexCli x0, AppPackage x1, ConfigPackage x2) {
        x0.checkConfigPackageCompatible(x1, x2);
    }

    static /* synthetic */ void access$7400(ApexCli x0, AppPackage x1, ConfigPackage x2, LaunchCommandLineInfo x3, ConsoleReader x4) throws Exception {
        x0.launchAppPackage(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$7900(ApexCli x0, String x1) throws IOException {
        x0.printJson(x1);
    }

    private static class ShowLogicalPlanCommandLineInfo {
        String libjars;
        boolean ignorePom;
        String[] args;
        boolean exactMatch;

        private ShowLogicalPlanCommandLineInfo() {
        }
    }

    static class LaunchCommandLineInfo {
        boolean localMode;
        boolean ignorePom;
        String configFile;
        String apConfigFile;
        Map<String, String> overrideProperties;
        String libjars;
        String files;
        String queue;
        String tags;
        String archives;
        String origAppId;
        boolean exactMatch;
        boolean force;
        String[] args;
        String useConfigApps;

        LaunchCommandLineInfo() {
        }
    }

    public static class LaunchCommandLineOptions {
        final Options options = new Options();
        final Option local = this.add(new Option("local", "Run application in local mode."));
        final Option configFile;
        final Option apConfigFile;
        final Option defProperty;
        final Option libjars;
        final Option files;
        final Option archives;
        final Option ignorePom;
        final Option originalAppID;
        final Option exactMatch;
        final Option queue;
        final Option tags;
        final Option force;
        final Option useConfigApps;

        public LaunchCommandLineOptions() {
            OptionBuilder.withArgName((String)"configuration file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify an application configuration file.");
            this.configFile = this.add(OptionBuilder.create((String)"conf"));
            OptionBuilder.withArgName((String)"app package configuration file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify an application configuration file within the app package if launching an app package.");
            this.apConfigFile = this.add(OptionBuilder.create((String)"apconf"));
            OptionBuilder.withArgName((String)"property=value");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Use value for given property.");
            this.defProperty = this.add(OptionBuilder.create((String)"D"));
            OptionBuilder.withArgName((String)"comma separated list of libjars");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify comma separated jar files or other resource files to include in the classpath.");
            this.libjars = this.add(OptionBuilder.create((String)"libjars"));
            OptionBuilder.withArgName((String)"comma separated list of files");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify comma separated files to be copied on the compute machines.");
            this.files = this.add(OptionBuilder.create((String)"files"));
            OptionBuilder.withArgName((String)"comma separated list of archives");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify comma separated archives to be unarchived on the compute machines.");
            this.archives = this.add(OptionBuilder.create((String)"archives"));
            this.ignorePom = this.add(new Option("ignorepom", "Do not run maven to find the dependency"));
            OptionBuilder.withArgName((String)"application id");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify original application identifier for restart.");
            this.originalAppID = this.add(OptionBuilder.create((String)"originalAppId"));
            this.exactMatch = this.add(new Option("exactMatch", "Only consider applications with exact app name"));
            OptionBuilder.withArgName((String)"queue name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify the queue to launch the application");
            this.queue = this.add(OptionBuilder.create((String)"queue"));
            OptionBuilder.withArgName((String)"comma separated tags");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Specify the tags for the application");
            this.tags = this.add(OptionBuilder.create((String)"tags"));
            this.force = this.add(new Option("force", "Force launch the application. Do not check for compatibility"));
            OptionBuilder.withArgName((String)"inclusive or exclusive");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"\"inclusive\" - merge the apps in config and app package. \"exclusive\" - only show config package apps.");
            this.useConfigApps = this.add(OptionBuilder.create((String)"useConfigApps"));
        }

        private Option add(Option opt) {
            this.options.addOption(opt);
            return opt;
        }
    }

    public static class GetPhysicalPropertiesCommandLineOptions {
        final Options options = new Options();
        final Option propertyName;
        final Option waitTime;

        public GetPhysicalPropertiesCommandLineOptions() {
            OptionBuilder.withArgName((String)"property name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"The name of the property whose value needs to be retrieved");
            this.propertyName = this.add(OptionBuilder.create((String)"propertyName"));
            OptionBuilder.withArgName((String)"wait time");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"How long to wait to get the result");
            this.waitTime = this.add(OptionBuilder.create((String)"waitTime"));
        }

        private Option add(Option opt) {
            this.options.addOption(opt);
            return opt;
        }
    }

    private class CleanAppDirectoriesCommand
    implements Command {
        private CleanAppDirectoriesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject result = new JSONObject();
            JSONArray appArray = new JSONArray();
            List<ApplicationReport> apps = StramClientUtils.cleanAppDirectories(ApexCli.this.yarnClient, ApexCli.this.conf, ApexCli.this.fs, System.currentTimeMillis() - Long.valueOf(args[1]));
            for (ApplicationReport app : apps) {
                appArray.put((Object)app.getApplicationId().toString());
            }
            result.put("applications", (Object)appArray);
            ApexCli.this.printJson(result);
        }
    }

    private class ListDefaultAttributesCommand
    implements Command {
        private final AttributesType type;

        protected ListDefaultAttributesCommand(AttributesType type) {
            this.type = (AttributesType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject result = this.type == AttributesType.APPLICATION ? TypeDiscoverer.getAppAttributes() : (this.type == AttributesType.OPERATOR ? TypeDiscoverer.getOperatorAttributes() : TypeDiscoverer.getPortAttributes());
            ApexCli.this.printJson(result);
        }
    }

    private static enum AttributesType {
        APPLICATION,
        OPERATOR,
        PORT;

    }

    private class GetAppPackageOperatorPropertiesCommand
    implements Command {
        private GetAppPackageOperatorPropertiesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            try (AppPackage ap = ApexCli.this.newAppPackageInstance(new File(ApexCli.expandFileName(args[1], true)));){
                ArrayList<String> newArgs = new ArrayList<String>();
                ArrayList<String> jars = new ArrayList<String>();
                for (String jar : ap.getAppJars()) {
                    jars.add(ap.tempDirectory() + "/app/" + jar);
                }
                for (String libJar : ap.getClassPath()) {
                    jars.add(ap.tempDirectory() + "/" + libJar);
                }
                newArgs.add("get-jar-operator-properties");
                newArgs.add(StringUtils.join(jars, (String)","));
                newArgs.add(args[2]);
                new GetJarOperatorPropertiesCommand().execute(newArgs.toArray(new String[0]), reader);
            }
        }
    }

    private class GetAppPackageOperatorsCommand
    implements Command {
        private GetAppPackageOperatorsCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String[] tmpArgs = new String[args.length - 1];
            System.arraycopy(args, 1, tmpArgs, 0, args.length - 1);
            GetOperatorClassesCommandLineInfo commandLineInfo = ApexCli.getGetOperatorClassesCommandLineInfo(tmpArgs);
            try (AppPackage ap = ApexCli.this.newAppPackageInstance(new File(ApexCli.expandFileName(commandLineInfo.args[0], true)));){
                ArrayList<String> newArgs = new ArrayList<String>();
                ArrayList<String> jars = new ArrayList<String>();
                for (String jar : ap.getAppJars()) {
                    jars.add(ap.tempDirectory() + "/app/" + jar);
                }
                for (String libJar : ap.getClassPath()) {
                    jars.add(ap.tempDirectory() + "/" + libJar);
                }
                newArgs.add("get-jar-operator-classes");
                if (commandLineInfo.parent != null) {
                    newArgs.add("-parent");
                    newArgs.add(commandLineInfo.parent);
                }
                newArgs.add(StringUtils.join(jars, (String)","));
                for (int i = 1; i < commandLineInfo.args.length; ++i) {
                    newArgs.add(commandLineInfo.args[i]);
                }
                LOG.debug("Executing: " + newArgs);
                new GetJarOperatorClassesCommand().execute(newArgs.toArray(new String[0]), reader);
            }
        }
    }

    private class GetAppPackageInfoCommand
    implements Command {
        private GetAppPackageInfoCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            try (AppPackage ap = ApexCli.this.newAppPackageInstance(new File(ApexCli.expandFileName(args[1], true)));){
                JSONSerializationProvider jomp = new JSONSerializationProvider();
                JSONObject apInfo = new JSONObject(jomp.getContext(null).writeValueAsString((Object)ap));
                apInfo.remove("name");
                ApexCli.this.printJson(apInfo);
            }
        }
    }

    private class GetContainerStackTrace
    implements Command {
        private GetContainerStackTrace() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject response;
            String containerLongId = ApexCli.this.getContainerLongId(args[1]);
            if (containerLongId == null) {
                throw new CliException("Container " + args[1] + " not found");
            }
            try {
                response = ApexCli.this.getResource("physicalPlan/containers/" + args[1] + "/" + "stackTrace", ApexCli.this.currentApp);
            }
            catch (Exception ex) {
                throw new CliException("Webservice call to AppMaster failed.", ex);
            }
            ApexCli.this.printJson(response);
        }
    }

    private class GetAppInfoCommand
    implements Command {
        private GetAppInfoCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject response;
            ApplicationReport appReport;
            if (args.length > 1) {
                appReport = ApexCli.this.getApplication(args[1]);
                if (appReport == null) {
                    throw new CliException("Streaming application with id " + args[1] + " is not found.");
                }
            } else {
                if (ApexCli.this.currentApp == null) {
                    throw new CliException("No application selected");
                }
                ApexCli.this.currentApp = ApexCli.this.yarnClient.getApplicationReport(ApexCli.this.currentApp.getApplicationId());
                appReport = ApexCli.this.currentApp;
            }
            try {
                response = ApexCli.this.getResource("info", ApexCli.this.currentApp);
            }
            catch (Exception ex) {
                response = new JSONObject();
                response.put("startTime", appReport.getStartTime());
                response.put("id", (Object)appReport.getApplicationId().toString());
                response.put("name", (Object)appReport.getName());
                response.put("user", (Object)appReport.getUser());
            }
            response.put("state", (Object)appReport.getYarnApplicationState().name());
            response.put("trackingUrl", (Object)appReport.getTrackingUrl());
            response.put("finalStatus", (Object)appReport.getFinalApplicationStatus());
            JSONArray tags = new JSONArray();
            for (String tag : appReport.getApplicationTags()) {
                tags.put((Object)tag);
            }
            response.put("tags", (Object)tags);
            ApexCli.this.printJson(response);
        }
    }

    private class SetPagerCommand
    implements Command {
        private SetPagerCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (args[1].equals("off")) {
                ApexCli.this.pagerCommand = null;
            } else if (args[1].equals("on")) {
                if (ApexCli.this.consolePresent) {
                    ApexCli.this.pagerCommand = "less -F -X -r";
                }
            } else {
                throw new CliException("set-pager parameter is either on or off.");
            }
        }
    }

    private class BeginMacroCommand
    implements Command {
        private BeginMacroCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String name = args[1];
            if (ApexCli.this.macros.containsKey(name) || ApexCli.this.aliases.containsKey(name)) {
                System.err.println("Name '" + name + "' already exists.");
                return;
            }
            try {
                ArrayList<String> commands = new ArrayList<String>();
                while (true) {
                    String line;
                    if ((line = ApexCli.this.consolePresent ? reader.readLine("macro def (" + name + ") > ") : reader.readLine("", Character.valueOf('\u0000'))).equals("end")) {
                        ApexCli.this.macros.put(name, commands);
                        ApexCli.this.updateCompleter(reader);
                        if (ApexCli.this.consolePresent) {
                            System.out.println("Macro '" + name + "' created.");
                        }
                        return;
                    }
                    if (line.equals("abort")) {
                        System.err.println("Aborted");
                        return;
                    }
                    commands.add(line);
                }
            }
            catch (IOException ex) {
                System.err.println("Aborted");
                return;
            }
        }
    }

    private class ShowQueueCommand
    implements Command {
        private ShowQueueCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApexCli.this.printJson(ApexCli.this.logicalPlanRequestQueue, "queue");
            if (ApexCli.this.consolePresent) {
                System.out.println("Total operations in queue: " + ApexCli.this.logicalPlanRequestQueue.size());
            }
        }
    }

    private class SubmitCommand
    implements Command {
        private SubmitCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.logicalPlanRequestQueue.isEmpty()) {
                throw new CliException("Nothing to submit. Type \"abort\" to abort change");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("logicalPlan");
            try {
                HashMap<String, List> m = new HashMap<String, List>();
                ObjectMapper mapper = new ObjectMapper();
                m.put("requests", ApexCli.this.logicalPlanRequestQueue);
                final JSONObject jsonRequest = new JSONObject(mapper.writeValueAsString(m));
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp, new WebServicesClient.WebServicesHandler<JSONObject>(){

                    @Override
                    public JSONObject process(WebResource.Builder webResource, Class<JSONObject> clazz) {
                        return (JSONObject)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).post(JSONObject.class, (Object)jsonRequest);
                    }
                });
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
            ApexCli.this.logicalPlanRequestQueue.clear();
            ApexCli.this.changingLogicalPlan = false;
            reader.setHistory((History)ApexCli.this.topLevelHistory);
        }
    }

    private class AbortCommand
    implements Command {
        private AbortCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApexCli.this.logicalPlanRequestQueue.clear();
            ApexCli.this.changingLogicalPlan = false;
            reader.setHistory((History)ApexCli.this.topLevelHistory);
        }
    }

    private class SetPortAttributeCommand
    implements Command {
        private SetPortAttributeCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String operatorName = args[1];
            String attributeName = args[2];
            String attributeValue = args[3];
            SetPortAttributeRequest request = new SetPortAttributeRequest();
            request.setOperatorName(operatorName);
            request.setAttributeName(attributeName);
            request.setAttributeValue(attributeValue);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class SetStreamAttributeCommand
    implements Command {
        private SetStreamAttributeCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String streamName = args[1];
            String attributeName = args[2];
            String attributeValue = args[3];
            SetStreamAttributeRequest request = new SetStreamAttributeRequest();
            request.setStreamName(streamName);
            request.setAttributeName(attributeName);
            request.setAttributeValue(attributeValue);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class SetOperatorAttributeCommand
    implements Command {
        private SetOperatorAttributeCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String operatorName = args[1];
            String attributeName = args[2];
            String attributeValue = args[3];
            SetOperatorAttributeRequest request = new SetOperatorAttributeRequest();
            request.setOperatorName(operatorName);
            request.setAttributeName(attributeName);
            request.setAttributeValue(attributeValue);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class RemoveStreamCommand
    implements Command {
        private RemoveStreamCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String streamName = args[1];
            RemoveStreamRequest request = new RemoveStreamRequest();
            request.setStreamName(streamName);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class AddStreamSinkCommand
    implements Command {
        private AddStreamSinkCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String streamName = args[1];
            String sinkOperatorName = args[2];
            String sinkPortName = args[3];
            AddStreamSinkRequest request = new AddStreamSinkRequest();
            request.setStreamName(streamName);
            request.setSinkOperatorName(sinkOperatorName);
            request.setSinkOperatorPortName(sinkPortName);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class CreateStreamCommand
    implements Command {
        private CreateStreamCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String streamName = args[1];
            String sourceOperatorName = args[2];
            String sourcePortName = args[3];
            String sinkOperatorName = args[4];
            String sinkPortName = args[5];
            CreateStreamRequest request = new CreateStreamRequest();
            request.setStreamName(streamName);
            request.setSourceOperatorName(sourceOperatorName);
            request.setSinkOperatorName(sinkOperatorName);
            request.setSourceOperatorPortName(sourcePortName);
            request.setSinkOperatorPortName(sinkPortName);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class RemoveOperatorCommand
    implements Command {
        private RemoveOperatorCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String operatorName = args[1];
            RemoveOperatorRequest request = new RemoveOperatorRequest();
            request.setOperatorName(operatorName);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class CreateOperatorCommand
    implements Command {
        private CreateOperatorCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String operatorName = args[1];
            String className = args[2];
            CreateOperatorRequest request = new CreateOperatorRequest();
            request.setOperatorName(operatorName);
            request.setOperatorFQCN(className);
            ApexCli.this.logicalPlanRequestQueue.add(request);
        }
    }

    private class DumpPropertiesFileCommand
    implements Command {
        private DumpPropertiesFileCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String outfilename = ApexCli.expandFileName(args[1], false);
            if (args.length > 3) {
                String jarfile = args[2];
                String appName = args[3];
                Configuration config = StramClientUtils.addDTSiteResources(new Configuration());
                StramAppLauncher submitApp = ApexCli.this.getStramAppLauncher(jarfile, config, false);
                submitApp.loadDependencies();
                List matchingAppFactories = ApexCli.this.getMatchingAppFactories(submitApp, appName, true);
                if (matchingAppFactories == null || matchingAppFactories.isEmpty()) {
                    throw new CliException("No application in jar file matches '" + appName + "'");
                }
                if (matchingAppFactories.size() > 1) {
                    throw new CliException("More than one application in jar file match '" + appName + "'");
                }
                StramAppLauncher.AppFactory appFactory = (StramAppLauncher.AppFactory)matchingAppFactories.get(0);
                LogicalPlan logicalPlan = appFactory.createApp(submitApp.getLogicalPlanConfiguration());
                File file = new File(outfilename);
                if (!file.exists()) {
                    file.createNewFile();
                }
                LogicalPlanSerializer.convertToProperties(logicalPlan).save(file);
            } else {
                if (ApexCli.this.currentApp == null) {
                    throw new CliException("No application selected");
                }
                JSONObject response = ApexCli.this.getResource("logicalPlan", ApexCli.this.currentApp);
                File file = new File(outfilename);
                if (!file.exists()) {
                    file.createNewFile();
                }
                LogicalPlanSerializer.convertToProperties(response).save(file);
            }
            System.out.println("Property file is saved at " + outfilename);
        }
    }

    private class GetJarOperatorPropertiesCommand
    implements Command {
        private GetJarOperatorPropertiesCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String files = ApexCli.expandCommaSeparatedFiles(args[1]);
            if (files == null) {
                throw new CliException("File " + args[1] + " is not found");
            }
            String[] jarFiles = files.split(",");
            File tmpDir = ApexCli.this.copyToLocal(jarFiles);
            try {
                OperatorDiscoverer operatorDiscoverer = new OperatorDiscoverer(jarFiles);
                Class<? extends Operator> operatorClass = operatorDiscoverer.getOperatorClass(args[2]);
                ApexCli.this.printJson(operatorDiscoverer.describeOperator(operatorClass.getName()));
            }
            finally {
                FileUtils.deleteDirectory((File)tmpDir);
            }
        }
    }

    private class GetJarOperatorClassesCommand
    implements Command {
        private GetJarOperatorClassesCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            GetOperatorClassesCommandLineInfo commandLineInfo = ApexCli.getGetOperatorClassesCommandLineInfo(newArgs);
            String parentName = commandLineInfo.parent != null ? commandLineInfo.parent : DAG.GenericOperator.class.getName();
            String files = ApexCli.expandCommaSeparatedFiles(commandLineInfo.args[0]);
            if (files == null) {
                throw new CliException("File " + commandLineInfo.args[0] + " is not found");
            }
            String[] jarFiles = files.split(",");
            File tmpDir = ApexCli.this.copyToLocal(jarFiles);
            try {
                OperatorDiscoverer operatorDiscoverer = new OperatorDiscoverer(jarFiles);
                String searchTerm = commandLineInfo.args.length > 1 ? commandLineInfo.args[1] : null;
                Set<String> operatorClasses = operatorDiscoverer.getOperatorClasses(parentName, searchTerm);
                JSONObject json = new JSONObject();
                JSONArray arr = new JSONArray();
                JSONObject portClassHier = new JSONObject();
                JSONObject portTypesWithSchemaClasses = new JSONObject();
                JSONObject failed = new JSONObject();
                for (String clazz : operatorClasses) {
                    try {
                        JSONObject oper = operatorDiscoverer.describeOperator(clazz);
                        operatorDiscoverer.addDefaultValue(clazz, oper);
                        operatorDiscoverer.buildAdditionalPortInfo(oper, portClassHier, portTypesWithSchemaClasses);
                        Iterator portTypesIter = portTypesWithSchemaClasses.keys();
                        while (portTypesIter.hasNext()) {
                            if (portTypesWithSchemaClasses.getBoolean((String)portTypesIter.next())) continue;
                            portTypesIter.remove();
                        }
                        arr.put((Object)oper);
                    }
                    catch (Exception | NoClassDefFoundError ex) {
                        String cls = clazz;
                        failed.put(cls, (Object)ex.toString());
                    }
                }
                json.put("operatorClasses", (Object)arr);
                json.put("portClassHier", (Object)portClassHier);
                json.put("portTypesWithSchemaClasses", (Object)portTypesWithSchemaClasses);
                if (failed.length() > 0) {
                    json.put("failedOperators", (Object)failed);
                }
                ApexCli.this.printJson(json);
            }
            finally {
                FileUtils.deleteDirectory((File)tmpDir);
            }
        }
    }

    private static class GetOperatorClassesCommandLineInfo {
        String parent;
        String[] args;

        private GetOperatorClassesCommandLineInfo() {
        }
    }

    public static class GetOperatorClassesCommandLineOptions {
        final Options options = new Options();
        final Option parent = this.add(new Option("parent", "Specify the parent class for the operators"));

        private Option add(Option opt) {
            this.options.addOption(opt);
            return opt;
        }
    }

    private class ShowLogicalPlanAppPackageCommand
    implements Command {
        private ShowLogicalPlanAppPackageCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String jarfile = ApexCli.expandFileName(args[1], true);
            try (AppPackage ap = ApexCli.this.newAppPackageInstance(new File(jarfile));){
                List<AppPackage.AppInfo> applications = ap.getApplications();
                if (args.length >= 3) {
                    for (AppPackage.AppInfo appInfo : applications) {
                        if (!args[2].equals(appInfo.name)) continue;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("applicationName", appInfo.name);
                        if (appInfo.dag != null) {
                            map.put("logicalPlan", LogicalPlanSerializer.convertToMap(appInfo.dag, false));
                        }
                        if (appInfo.error != null) {
                            map.put("error", appInfo.error);
                        }
                        ApexCli.this.printJson(map);
                    }
                } else {
                    ArrayList appList = new ArrayList();
                    for (AppPackage.AppInfo appInfo : applications) {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("name", appInfo.name);
                        m.put("type", appInfo.type);
                        appList.add(m);
                    }
                    ApexCli.this.printJson(appList, "applications");
                }
            }
        }
    }

    private class ShowLogicalPlanCommand
    implements Command {
        private ShowLogicalPlanCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            ShowLogicalPlanCommandLineInfo commandLineInfo = ApexCli.getShowLogicalPlanCommandLineInfo(newArgs);
            Configuration config = StramClientUtils.addDTSiteResources(new Configuration());
            if (commandLineInfo.libjars != null) {
                commandLineInfo.libjars = ApexCli.expandCommaSeparatedFiles(commandLineInfo.libjars);
                if (commandLineInfo.libjars != null) {
                    config.set("_apex.libjars", commandLineInfo.libjars);
                }
            }
            if (commandLineInfo.args.length > 0) {
                String filename = ApexCli.expandFileName(commandLineInfo.args[0], true);
                try {
                    AppPackage ap = new AppPackage(new File(filename));
                    ap.close();
                    new ShowLogicalPlanAppPackageCommand().execute(args, reader);
                    return;
                }
                catch (Exception ap) {
                    if (commandLineInfo.args.length >= 2) {
                        String appName = commandLineInfo.args[1];
                        StramAppLauncher submitApp = ApexCli.this.getStramAppLauncher(filename, config, commandLineInfo.ignorePom);
                        submitApp.loadDependencies();
                        List matchingAppFactories = ApexCli.this.getMatchingAppFactories(submitApp, appName, commandLineInfo.exactMatch);
                        if (matchingAppFactories == null || matchingAppFactories.isEmpty()) {
                            throw new CliException("No application in jar file matches '" + appName + "'");
                        }
                        if (matchingAppFactories.size() > 1) {
                            throw new CliException("More than one application in jar file match '" + appName + "'");
                        }
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        PrintStream originalStream = System.out;
                        StramAppLauncher.AppFactory appFactory = (StramAppLauncher.AppFactory)matchingAppFactories.get(0);
                        try {
                            if (ApexCli.this.raw) {
                                PrintStream dummyStream = new PrintStream(new OutputStream(){

                                    @Override
                                    public void write(int b) {
                                    }
                                });
                                System.setOut(dummyStream);
                            }
                            LogicalPlan logicalPlan = appFactory.createApp(submitApp.getLogicalPlanConfiguration());
                            map.put("applicationName", appFactory.getName());
                            map.put("logicalPlan", LogicalPlanSerializer.convertToMap(logicalPlan, false));
                        }
                        finally {
                            if (ApexCli.this.raw) {
                                System.setOut(originalStream);
                            }
                        }
                        ApexCli.this.printJson(map);
                    }
                    if (filename.endsWith(".json")) {
                        File file = new File(filename);
                        StramAppLauncher submitApp = new StramAppLauncher(file.getName(), config);
                        StramAppLauncher.JsonFileAppFactory appFactory = new StramAppLauncher.JsonFileAppFactory(file);
                        LogicalPlan logicalPlan = appFactory.createApp(submitApp.getLogicalPlanConfiguration());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("applicationName", appFactory.getName());
                        map.put("logicalPlan", LogicalPlanSerializer.convertToMap(logicalPlan, false));
                        ApexCli.this.printJson(map);
                    }
                    if (filename.endsWith(".properties")) {
                        File file = new File(filename);
                        StramAppLauncher submitApp = new StramAppLauncher(file.getName(), config);
                        StramAppLauncher.PropertyFileAppFactory appFactory = new StramAppLauncher.PropertyFileAppFactory(file);
                        LogicalPlan logicalPlan = appFactory.createApp(submitApp.getLogicalPlanConfiguration());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("applicationName", appFactory.getName());
                        map.put("logicalPlan", LogicalPlanSerializer.convertToMap(logicalPlan, false));
                        ApexCli.this.printJson(map);
                    }
                    StramAppLauncher submitApp = ApexCli.this.getStramAppLauncher(filename, config, commandLineInfo.ignorePom);
                    submitApp.loadDependencies();
                    ArrayList appList = new ArrayList();
                    List<StramAppLauncher.AppFactory> appFactoryList = submitApp.getBundledTopologies();
                    for (StramAppLauncher.AppFactory appFactory : appFactoryList) {
                        HashMap<String, String> m = new HashMap<String, String>();
                        m.put("name", appFactory.getName());
                        appList.add(m);
                    }
                    ApexCli.this.printJson(appList, "applications");
                }
            } else {
                if (ApexCli.this.currentApp == null) {
                    throw new CliException("No application selected");
                }
                JSONObject response = ApexCli.this.getResource("logicalPlan", ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
        }
    }

    private class BeginLogicalPlanChangeCommand
    implements Command {
        private BeginLogicalPlanChangeCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApexCli.this.changingLogicalPlan = true;
            reader.setHistory((History)ApexCli.this.changingLogicalPlanHistory);
        }
    }

    private class SetPhysicalOperatorPropertyCommand
    implements Command {
        private SetPhysicalOperatorPropertyCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            if (!NumberUtils.isDigits((String)args[1])) {
                throw new CliException("Operator ID must be a number");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("physicalPlan/operators").path(args[1]).path("properties");
            final JSONObject request = new JSONObject();
            request.put(args[2], (Object)args[3]);
            JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp, new WebServicesClient.WebServicesHandler<JSONObject>(){

                @Override
                public JSONObject process(WebResource.Builder webResource, Class<JSONObject> clazz) {
                    return (JSONObject)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).post(JSONObject.class, (Object)request);
                }
            });
            ApexCli.this.printJson(response);
        }
    }

    private class SetOperatorPropertyCommand
    implements Command {
        private SetOperatorPropertyCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            if (ApexCli.this.changingLogicalPlan) {
                String operatorName = args[1];
                String propertyName = args[2];
                String propertyValue = args[3];
                SetOperatorPropertyRequest request = new SetOperatorPropertyRequest();
                request.setOperatorName(operatorName);
                request.setPropertyName(propertyName);
                request.setPropertyValue(propertyValue);
                ApexCli.this.logicalPlanRequestQueue.add(request);
            } else {
                StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
                uriSpec = uriSpec.path("logicalPlan/operators").path(URLEncoder.encode(args[1], "UTF-8")).path("properties");
                final JSONObject request = new JSONObject();
                request.put(args[2], (Object)args[3]);
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp, new WebServicesClient.WebServicesHandler<JSONObject>(){

                    @Override
                    public JSONObject process(WebResource.Builder webResource, Class<JSONObject> clazz) {
                        return (JSONObject)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).post(JSONObject.class, (Object)request);
                    }
                });
                ApexCli.this.printJson(response);
            }
        }
    }

    private class GetPhysicalOperatorPropertiesCommand
    implements Command {
        private GetPhysicalOperatorPropertiesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            if (!NumberUtils.isDigits((String)args[1])) {
                throw new CliException("Operator ID must be a number");
            }
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            PosixParser parser = new PosixParser();
            CommandLine line = parser.parse(GET_PHYSICAL_PROPERTY_OPTIONS.options, newArgs);
            String waitTime = line.getOptionValue(GET_PHYSICAL_PROPERTY_OPTIONS.waitTime.getOpt());
            String propertyName = line.getOptionValue(GET_PHYSICAL_PROPERTY_OPTIONS.propertyName.getOpt());
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("physicalPlan/operators").path(args[1]).path("properties");
            if (propertyName != null) {
                uriSpec = uriSpec.queryParam("propertyName", propertyName);
            }
            if (waitTime != null) {
                uriSpec = uriSpec.queryParam("waitTime", waitTime);
            }
            try {
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class GetOperatorPropertiesCommand
    implements Command {
        private GetOperatorPropertiesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("logicalPlan/operators").path(URLEncoder.encode(args[1], "UTF-8")).path("properties");
            if (args.length > 2) {
                uriSpec = uriSpec.queryParam("propertyName", args[2]);
            }
            try {
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class GetPortAttributesCommand
    implements Command {
        private GetPortAttributesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("logicalPlan/operators").path(URLEncoder.encode(args[1], "UTF-8")).path("ports").path(URLEncoder.encode(args[2], "UTF-8")).path("attributes");
            if (args.length > 3) {
                uriSpec = uriSpec.queryParam("attributeName", args[3]);
            }
            try {
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class GetOperatorAttributesCommand
    implements Command {
        private GetOperatorAttributesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("logicalPlan/operators").path(URLEncoder.encode(args[1], "UTF-8")).path("attributes");
            if (args.length > 2) {
                uriSpec = uriSpec.queryParam("attributeName", args[2]);
            }
            try {
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class GetAppAttributesCommand
    implements Command {
        private GetAppAttributesCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
            uriSpec = uriSpec.path("logicalPlan").path("attributes");
            if (args.length > 1) {
                uriSpec = uriSpec.queryParam("attributeName", args[1]);
            }
            try {
                JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp);
                ApexCli.this.printJson(response);
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class GetRecordingInfoCommand
    implements Command {
        private GetRecordingInfoCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (args.length <= 1) {
                List<RecordingsAgent.RecordingInfo> recordingInfo = ApexCli.this.recordingsAgent.getRecordingInfo(ApexCli.this.currentApp.getApplicationId().toString());
                ApexCli.this.printJson(recordingInfo, "recordings");
            } else if (args.length <= 2) {
                String opId = args[1];
                List<RecordingsAgent.RecordingInfo> recordingInfo = ApexCli.this.recordingsAgent.getRecordingInfo(ApexCli.this.currentApp.getApplicationId().toString(), opId);
                ApexCli.this.printJson(recordingInfo, "recordings");
            } else {
                String opId = args[1];
                String id = args[2];
                RecordingsAgent.RecordingInfo recordingInfo = ApexCli.this.recordingsAgent.getRecordingInfo(ApexCli.this.currentApp.getApplicationId().toString(), opId, id);
                ApexCli.this.printJson(new JSONObject(ApexCli.this.mapper.writeValueAsString((Object)recordingInfo)));
            }
        }
    }

    private class StopRecordingCommand
    implements Command {
        private StopRecordingCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String opId = args[1];
            String port = null;
            if (args.length == 3) {
                port = args[2];
            }
            ApexCli.this.printJson(ApexCli.this.recordingsAgent.stopRecording(ApexCli.this.currentApp.getApplicationId().toString(), opId, port));
        }
    }

    private class StartRecordingCommand
    implements Command {
        private StartRecordingCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            String opId = args[1];
            String port = null;
            long numWindows = 0L;
            if (args.length >= 3) {
                port = args[2];
            }
            if (args.length >= 4) {
                numWindows = Long.valueOf(args[3]);
            }
            ApexCli.this.printJson(ApexCli.this.recordingsAgent.startRecording(ApexCli.this.currentApp.getApplicationId().toString(), opId, port, numWindows));
        }
    }

    private class WaitCommand
    implements Command {
        private WaitCommand() {
        }

        @Override
        public void execute(String[] args, final ConsoleReader reader) throws Exception {
            if (ApexCli.this.currentApp == null) {
                throw new CliException("No application selected");
            }
            int timeout = Integer.valueOf(args[1]);
            StramClientUtils.ClientRMHelper.AppStatusCallback cb = new StramClientUtils.ClientRMHelper.AppStatusCallback(){

                @Override
                public boolean exitLoop(ApplicationReport report) {
                    System.out.println("current status is: " + report.getYarnApplicationState());
                    try {
                        if (reader.getInput().available() > 0) {
                            return true;
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Error checking for input.", (Throwable)e);
                    }
                    return false;
                }
            };
            try {
                StramClientUtils.ClientRMHelper clientRMHelper = new StramClientUtils.ClientRMHelper(ApexCli.this.yarnClient, ApexCli.this.conf);
                boolean result = clientRMHelper.waitForCompletion(ApexCli.this.currentApp.getApplicationId(), cb, timeout * 1000);
                if (!result) {
                    System.err.println("Application terminated unsuccessfully.");
                }
            }
            catch (YarnException e) {
                throw new CliException("Failed to kill " + ApexCli.this.currentApp.getApplicationId(), e);
            }
        }
    }

    private class KillContainerCommand
    implements Command {
        private KillContainerCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            for (int i = 1; i < args.length; ++i) {
                String containerLongId = ApexCli.this.getContainerLongId(args[i]);
                if (containerLongId == null) {
                    throw new CliException("Container " + args[i] + " not found");
                }
                try {
                    StramAgent.StramUriSpec uriSpec = new StramAgent.StramUriSpec();
                    uriSpec = uriSpec.path("physicalPlan/containers").path(URLEncoder.encode(containerLongId, "UTF-8")).path("kill");
                    JSONObject response = ApexCli.this.getResource(uriSpec, ApexCli.this.currentApp, new WebServicesClient.WebServicesHandler<JSONObject>(){

                        @Override
                        public JSONObject process(WebResource.Builder webResource, Class<JSONObject> clazz) {
                            return (JSONObject)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).post(clazz, (Object)new JSONObject());
                        }
                    });
                    if (!ApexCli.this.consolePresent) continue;
                    System.out.println("Kill container requested: " + response);
                    continue;
                }
                catch (Exception e) {
                    throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
                }
            }
        }
    }

    private class ShowPhysicalPlanCommand
    implements Command {
        private ShowPhysicalPlanCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            try {
                ApexCli.this.printJson(ApexCli.this.getResource("physicalPlan", ApexCli.this.currentApp));
            }
            catch (Exception e) {
                throw new CliException("Failed web service request for appid " + ApexCli.this.currentApp.getApplicationId().toString(), e);
            }
        }
    }

    private class ListOperatorsCommand
    implements Command {
        private ListOperatorsCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject json = ApexCli.this.getResource("physicalPlan/operators", ApexCli.this.currentApp);
            if (args.length > 1) {
                JSONArray arr;
                String singleKey = "" + json.keys().next();
                JSONArray matches = new JSONArray();
                Object obj = json.get(singleKey);
                if (obj instanceof JSONArray) {
                    arr = (JSONArray)obj;
                } else {
                    arr = new JSONArray();
                    arr.put(obj);
                }
                block0: for (int i = 0; i < arr.length(); ++i) {
                    JSONObject oper = arr.getJSONObject(i);
                    if (StringUtils.isNumeric((String)args[1])) {
                        if (!oper.getString("id").equals(args[1])) continue;
                        matches.put((Object)oper);
                        break;
                    }
                    Iterator keys = oper.keys();
                    while (keys.hasNext()) {
                        if (!oper.get((String)keys.next()).toString().toLowerCase().contains(args[1].toLowerCase())) continue;
                        matches.put((Object)oper);
                        continue block0;
                    }
                }
                json.put(singleKey, (Object)matches);
            }
            ApexCli.this.printJson(json);
        }
    }

    private class ListContainersCommand
    implements Command {
        private ListContainersCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            JSONObject json = ApexCli.this.getResource("physicalPlan/containers", ApexCli.this.currentApp);
            if (args.length == 1) {
                ApexCli.this.printJson(json);
            } else {
                JSONArray containers;
                Object containersObj = json.get("containers");
                if (containersObj instanceof JSONArray) {
                    containers = (JSONArray)containersObj;
                } else {
                    containers = new JSONArray();
                    containers.put(containersObj);
                }
                if (containersObj == null) {
                    System.out.println("No containers found!");
                } else {
                    JSONArray resultContainers = new JSONArray();
                    int o = containers.length();
                    while (o-- > 0) {
                        JSONObject container = containers.getJSONObject(o);
                        String id = container.getString("id");
                        if (id == null || id.isEmpty()) continue;
                        int argc = args.length;
                        while (argc-- > 1) {
                            String s1 = "0" + args[argc];
                            String s2 = "_" + args[argc];
                            if (!id.equals(args[argc]) && !id.endsWith(s1) && !id.endsWith(s2)) continue;
                            resultContainers.put((Object)container);
                        }
                    }
                    ApexCli.this.printJson(resultContainers, "containers");
                }
            }
        }
    }

    private class ExitCommand
    implements Command {
        private ExitCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (ApexCli.this.topLevelHistory != null) {
                try {
                    ApexCli.this.topLevelHistory.flush();
                }
                catch (IOException ex) {
                    LOG.warn("Cannot flush command history");
                }
            }
            if (ApexCli.this.changingLogicalPlanHistory != null) {
                try {
                    ApexCli.this.changingLogicalPlanHistory.flush();
                }
                catch (IOException ex) {
                    LOG.warn("Cannot flush command history");
                }
            }
            System.exit(0);
        }
    }

    private class SourceCommand
    implements Command {
        private SourceCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApexCli.this.processSourceFile(args[1], reader);
            if (ApexCli.this.consolePresent) {
                System.out.println("File " + args[1] + " sourced.");
            }
        }
    }

    private class AliasCommand
    implements Command {
        private AliasCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (args[1].equals(args[2])) {
                throw new CliException("Alias to itself!");
            }
            ApexCli.this.aliases.put(args[1], args[2]);
            if (ApexCli.this.consolePresent) {
                System.out.println("Alias " + args[1] + " created.");
            }
            ApexCli.this.updateCompleter(reader);
        }
    }

    private class KillAppCommand
    implements Command {
        private KillAppCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            if (args.length == 1) {
                if (ApexCli.this.currentApp == null) {
                    throw new CliException("No application selected");
                }
                try {
                    ApexCli.this.yarnClient.killApplication(ApexCli.this.currentApp.getApplicationId());
                    ApexCli.this.currentApp = null;
                }
                catch (YarnException e) {
                    throw new CliException("Failed to kill " + ApexCli.this.currentApp.getApplicationId(), e);
                }
                if (ApexCli.this.consolePresent) {
                    System.out.println("Kill app requested");
                }
                return;
            }
            ApplicationReport app = null;
            int i = 0;
            try {
                while (++i < args.length) {
                    app = ApexCli.this.getApplication(args[i]);
                    if (app == null && (app = ApexCli.this.getApplicationByName(args[i])) == null) {
                        throw new CliException("Streaming application with id or name " + args[i] + " is not found.");
                    }
                    ApexCli.this.yarnClient.killApplication(app.getApplicationId());
                    if (app != ApexCli.this.currentApp) continue;
                    ApexCli.this.currentApp = null;
                }
                if (ApexCli.this.consolePresent) {
                    System.out.println("Kill app requested");
                }
            }
            catch (YarnException e) {
                throw new CliException("Failed to kill " + (app == null || app.getApplicationId() == null ? "unknown application" : app.getApplicationId()) + ". Aborting killing of any additional applications.", e);
            }
            catch (NumberFormatException nfe) {
                throw new CliException("Invalid application Id " + args[i], nfe);
            }
        }
    }

    private class ListAppsCommand
    implements Command {
        private ListAppsCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            try {
                JSONArray jsonArray = new JSONArray();
                List appList = ApexCli.this.getApplicationList();
                Collections.sort(appList, new Comparator<ApplicationReport>(){

                    @Override
                    public int compare(ApplicationReport o1, ApplicationReport o2) {
                        return o1.getApplicationId().getId() - o2.getApplicationId().getId();
                    }
                });
                int totalCnt = 0;
                int runningCnt = 0;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
                block2: for (ApplicationReport ar : appList) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("startTime", (Object)sdf.format(new Date(ar.getStartTime())));
                    jsonObj.put("id", ar.getApplicationId().getId());
                    jsonObj.put("name", (Object)ar.getName());
                    jsonObj.put("state", (Object)ar.getYarnApplicationState().name());
                    jsonObj.put("trackingUrl", (Object)ar.getTrackingUrl());
                    jsonObj.put("finalStatus", (Object)ar.getFinalApplicationStatus());
                    JSONArray tags = new JSONArray();
                    for (String tag : ar.getApplicationTags()) {
                        tags.put((Object)tag);
                    }
                    jsonObj.put("tags", (Object)tags);
                    ++totalCnt;
                    if (ar.getYarnApplicationState() == YarnApplicationState.RUNNING) {
                        ++runningCnt;
                    }
                    if (args.length > 1) {
                        if (StringUtils.isNumeric((String)args[1])) {
                            if (!jsonObj.getString("id").equals(args[1])) continue;
                            jsonArray.put((Object)jsonObj);
                            break;
                        }
                        Iterator keys = jsonObj.keys();
                        while (keys.hasNext()) {
                            if (!jsonObj.get((String)keys.next()).toString().toLowerCase().contains(args[1].toLowerCase())) continue;
                            jsonArray.put((Object)jsonObj);
                            continue block2;
                        }
                        continue;
                    }
                    jsonArray.put((Object)jsonObj);
                }
                ApexCli.this.printJson(jsonArray, "apps");
                if (ApexCli.this.consolePresent) {
                    System.out.println(runningCnt + " active, total " + totalCnt + " applications.");
                }
            }
            catch (Exception ex) {
                throw new CliException("Failed to retrieve application list", ex);
            }
        }
    }

    private class ShutdownAppCommand
    implements Command {
        private ShutdownAppCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApplicationReport[] apps;
            if (args.length == 1) {
                if (ApexCli.this.currentApp == null) {
                    throw new CliException("No application selected");
                }
                apps = new ApplicationReport[]{ApexCli.this.currentApp};
            } else {
                apps = new ApplicationReport[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    apps[i - 1] = ApexCli.this.getApplication(args[i]);
                    if (apps[i - 1] != null) continue;
                    throw new CliException("Streaming application with id " + args[i] + " is not found.");
                }
            }
            for (ApplicationReport app : apps) {
                try {
                    JSONObject response = ApexCli.this.getResource(new StramAgent.StramUriSpec().path("shutdown"), app, new WebServicesClient.WebServicesHandler<JSONObject>(){

                        @Override
                        public JSONObject process(WebResource.Builder webResource, Class<JSONObject> clazz) {
                            return (JSONObject)((WebResource.Builder)webResource.accept(new String[]{"application/json"})).post(clazz, (Object)new JSONObject());
                        }
                    });
                    if (ApexCli.this.consolePresent) {
                        System.out.println("Shutdown requested: " + response);
                    }
                    ApexCli.this.currentApp = null;
                }
                catch (Exception e) {
                    throw new CliException("Failed to request shutdown for appid " + app.getApplicationId().toString(), e);
                }
            }
        }
    }

    private class GetConfigParameterCommand
    implements Command {
        private GetConfigParameterCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            PrintStream os = ApexCli.this.getOutputPrintStream();
            if (args.length == 1) {
                TreeMap sortedMap = new TreeMap();
                for (Map.Entry entry : ApexCli.this.conf) {
                    sortedMap.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : sortedMap.entrySet()) {
                    os.println((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            } else {
                String value = ApexCli.this.conf.get(args[1]);
                if (value != null) {
                    os.println(value);
                }
            }
            ApexCli.this.closeOutputPrintStream(os);
        }
    }

    private class LaunchCommand
    implements Command {
        private LaunchCommand() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ConnectCommand
    implements Command {
        private ConnectCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            ApexCli.this.currentApp = ApexCli.this.getApplication(args[1]);
            if (ApexCli.this.currentApp == null) {
                throw new CliException("Streaming application with id " + args[1] + " is not found.");
            }
            LOG.debug("Selected {} with tracking url {}", (Object)ApexCli.this.currentApp.getApplicationId(), (Object)ApexCli.this.currentApp.getTrackingUrl());
            ApexCli.this.getResource("info", ApexCli.this.currentApp);
            if (ApexCli.this.consolePresent) {
                System.out.println("Connected to application " + ApexCli.this.currentApp.getApplicationId());
            }
        }
    }

    private class EchoCommand
    implements Command {
        private EchoCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    System.out.print(" ");
                }
                System.out.print(args[i]);
            }
            System.out.println();
        }
    }

    private class HelpCommand
    implements Command {
        private HelpCommand() {
        }

        @Override
        public void execute(String[] args, ConsoleReader reader) throws Exception {
            PrintStream os = ApexCli.this.getOutputPrintStream();
            if (args.length < 2) {
                os.println("GLOBAL COMMANDS EXCEPT WHEN CHANGING LOGICAL PLAN:\n");
                ApexCli.this.printHelp(ApexCli.this.globalCommands, os);
                os.println();
                os.println("COMMANDS WHEN CONNECTED TO AN APP (via connect <appid>) EXCEPT WHEN CHANGING LOGICAL PLAN:\n");
                ApexCli.this.printHelp(ApexCli.this.connectedCommands, os);
                os.println();
                os.println("COMMANDS WHEN CHANGING LOGICAL PLAN (via begin-logical-plan-change):\n");
                ApexCli.this.printHelp(ApexCli.this.logicalPlanChangeCommands, os);
                os.println();
            } else if (args[1].equals("help")) {
                ApexCli.this.printHelp("help", (CommandSpec)ApexCli.this.globalCommands.get("help"), os);
            } else {
                boolean valid = false;
                CommandSpec cs = (CommandSpec)ApexCli.this.globalCommands.get(args[1]);
                if (cs != null) {
                    os.println("This usage is valid except when changing logical plan");
                    ApexCli.this.printHelp(args[1], cs, os);
                    os.println();
                    valid = true;
                }
                if ((cs = (CommandSpec)ApexCli.this.connectedCommands.get(args[1])) != null) {
                    os.println("This usage is valid when connected to an app except when changing logical plan");
                    ApexCli.this.printHelp(args[1], cs, os);
                    os.println();
                    valid = true;
                }
                if ((cs = (CommandSpec)ApexCli.this.logicalPlanChangeCommands.get(args[1])) != null) {
                    os.println("This usage is only valid when changing logical plan (via begin-logical-plan-change)");
                    ApexCli.this.printHelp(args[1], cs, os);
                    os.println();
                    valid = true;
                }
                if (!valid) {
                    os.println("Help for \"" + args[1] + "\" does not exist.");
                }
            }
            ApexCli.this.closeOutputPrintStream(os);
        }
    }

    private static final class MyFileNameCompleter
    extends FileNameCompleter {
        private MyFileNameCompleter() {
        }

        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            int result = super.complete(buffer, cursor, candidates);
            if (candidates.isEmpty()) {
                candidates.add("");
                result = cursor;
            }
            return result;
        }
    }

    private static final class MyNullCompleter
    implements Completer {
        public static final MyNullCompleter INSTANCE = new MyNullCompleter();

        private MyNullCompleter() {
        }

        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            candidates.add("");
            return cursor;
        }
    }

    static class CliException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CliException(String msg, Throwable cause) {
            super(msg, cause);
        }

        CliException(String msg) {
            super(msg);
        }
    }

    private static class OptionsCommandSpec
    extends CommandSpec {
        Options options;

        OptionsCommandSpec(Command command, Arg[] requiredArgs, Arg[] optionalArgs, String description, Options options) {
            super(command, requiredArgs, optionalArgs, description);
            this.options = options;
        }

        @Override
        void verifyArguments(String[] args) throws CliException {
            try {
                args = new PosixParser().parse(this.options, args).getArgs();
                super.verifyArguments(args);
            }
            catch (Exception ex) {
                throw new CliException("Command parameter error");
            }
        }

        @Override
        void printUsage(String cmd) {
            super.printUsage(cmd + (this.options == null ? "" : " [options]"));
            if (this.options != null) {
                System.out.println("Options:");
                HelpFormatter formatter = new HelpFormatter();
                PrintWriter pw = new PrintWriter(System.out);
                formatter.printOptions(pw, 80, this.options, 4, 4);
                pw.flush();
            }
        }
    }

    private static class CommandSpec {
        Command command;
        Arg[] requiredArgs;
        Arg[] optionalArgs;
        String description;

        CommandSpec(Command command, Arg[] requiredArgs, Arg[] optionalArgs, String description) {
            this.command = command;
            this.requiredArgs = requiredArgs;
            this.optionalArgs = optionalArgs;
            this.description = description;
        }

        void verifyArguments(String[] args) throws CliException {
            int minArgs = 0;
            int maxArgs = 0;
            if (this.requiredArgs != null) {
                minArgs = this.requiredArgs.length;
                maxArgs = this.requiredArgs.length;
            }
            if (this.optionalArgs != null) {
                for (Arg arg : this.optionalArgs) {
                    if (arg instanceof VarArg) {
                        maxArgs = Integer.MAX_VALUE;
                        break;
                    }
                    ++maxArgs;
                }
            }
            if (args.length - 1 < minArgs || args.length - 1 > maxArgs) {
                throw new CliException("Command parameter error");
            }
        }

        void printUsage(String cmd) {
            System.err.print("Usage: " + cmd);
            if (this.requiredArgs != null) {
                for (Arg arg : this.requiredArgs) {
                    System.err.print(" <" + arg + ">");
                }
            }
            if (this.optionalArgs != null) {
                for (Arg arg : this.optionalArgs) {
                    if (arg instanceof VarArg) {
                        System.err.print(" [<" + arg + "> ... ]");
                        continue;
                    }
                    System.err.print(" [<" + arg + ">]");
                }
            }
            System.err.println();
        }
    }

    private static class CommandArg
    extends Arg {
        CommandArg(String name) {
            super(name);
        }
    }

    private static class VarArg
    extends Arg {
        VarArg(String name) {
            super(name);
        }
    }

    private static class FileArg
    extends Arg {
        FileArg(String name) {
            super(name);
        }
    }

    private static class Arg {
        final String name;

        Arg(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static interface Command {
        public void execute(String[] var1, ConsoleReader var2) throws Exception;
    }

    public class Tokenizer {
        private void appendToCommandBuffer(List<String> commandBuffer, StringBuffer buf, boolean potentialEmptyArg) {
            if (potentialEmptyArg || buf.length() > 0) {
                commandBuffer.add(buf.toString());
                buf.setLength(0);
            }
        }

        private List<String> startNewCommand(LinkedList<List<String>> resultBuffer) {
            String first;
            List<String> lastCommand;
            ArrayList<String> newCommand = new ArrayList<String>();
            if (!resultBuffer.isEmpty() && (lastCommand = resultBuffer.peekLast()).size() == 1 && (first = lastCommand.get(0)).matches("^[A-Za-z][A-Za-z0-9]*=.*")) {
                int equalSign = first.indexOf(61);
                ApexCli.this.variableMap.put(first.substring(0, equalSign), first.substring(equalSign + 1));
                resultBuffer.removeLast();
            }
            resultBuffer.add(newCommand);
            return newCommand;
        }

        public List<String[]> tokenize(String commandLine) {
            LinkedList<List<String>> resultBuffer = new LinkedList<List<String>>();
            List<String> commandBuffer = this.startNewCommand(resultBuffer);
            if (commandLine != null) {
                boolean bl;
                if ((commandLine = ApexCli.ltrim(commandLine)).startsWith("#")) {
                    return null;
                }
                int len = commandLine.length();
                boolean insideQuotes = false;
                boolean bl2 = false;
                StringBuffer buf = new StringBuffer(commandLine.length());
                for (int i = 0; i < len; ++i) {
                    char c = commandLine.charAt(i);
                    if (c == '\"') {
                        bl = true;
                        insideQuotes = !insideQuotes;
                        continue;
                    }
                    if (c == '\\') {
                        if (len <= i + 1) continue;
                        switch (commandLine.charAt(i + 1)) {
                            case 'n': {
                                buf.append("\n");
                                break;
                            }
                            case 't': {
                                buf.append("\t");
                                break;
                            }
                            case 'r': {
                                buf.append("\r");
                                break;
                            }
                            case 'b': {
                                buf.append("\b");
                                break;
                            }
                            case 'f': {
                                buf.append("\f");
                                break;
                            }
                            default: {
                                buf.append(commandLine.charAt(i + 1));
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (insideQuotes) {
                        buf.append(c);
                        continue;
                    }
                    if (c == '$') {
                        StringBuilder variableName = new StringBuilder(32);
                        if (len > i + 1) {
                            if (commandLine.charAt(i + 1) == '{') {
                                ++i;
                                while (len > i + 1) {
                                    char ch = commandLine.charAt(i + 1);
                                    if (ch != '}') {
                                        variableName.append(ch);
                                    }
                                    ++i;
                                    if (ch != '}') {
                                        if (len > i + 1) continue;
                                        throw new CliException("Parse error: unmatched brace");
                                    }
                                    break;
                                }
                            } else {
                                if (commandLine.charAt(i + 1) == '?') {
                                    ++i;
                                    buf.append(lastCommandError ? "1" : "0");
                                    continue;
                                }
                                while (len > i + 1) {
                                    char ch = commandLine.charAt(i + 1);
                                    if (variableName.length() > 0 && ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                                        variableName.append(ch);
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            if (variableName.length() == 0) {
                                buf.append(c);
                                continue;
                            }
                            String value = (String)ApexCli.this.variableMap.get(variableName.toString());
                            if (value == null) continue;
                            buf.append(value);
                            continue;
                        }
                        buf.append(c);
                        continue;
                    }
                    if (c == ';') {
                        this.appendToCommandBuffer(commandBuffer, buf, bl);
                        commandBuffer = this.startNewCommand(resultBuffer);
                        continue;
                    }
                    if (Character.isWhitespace(c)) {
                        this.appendToCommandBuffer(commandBuffer, buf, bl);
                        bl = false;
                        if (len <= i + 1 || commandLine.charAt(i + 1) != '#') continue;
                        break;
                    }
                    buf.append(c);
                }
                this.appendToCommandBuffer(commandBuffer, buf, bl);
            }
            this.startNewCommand(resultBuffer);
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (List list : resultBuffer) {
                String[] commandArray = new String[list.size()];
                result.add(list.toArray(commandArray));
            }
            return result;
        }
    }

    private static class FileLineReader
    extends ConsoleReader {
        private final BufferedReader br;

        FileLineReader(String fileName) throws IOException {
            fileName = ApexCli.expandFileName(fileName, true);
            this.br = new BufferedReader(new FileReader(fileName));
        }

        public String readLine(String prompt) throws IOException {
            return this.br.readLine();
        }

        public String readLine(String prompt, Character mask) throws IOException {
            return this.br.readLine();
        }

        public String readLine(Character mask) throws IOException {
            return this.br.readLine();
        }

        public void close() throws IOException {
            this.br.close();
        }
    }
}

