/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.client.DTConfiguration;
import com.datatorrent.stram.client.StramAppLauncher;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPackage
extends JarFile {
    public static final String ATTRIBUTE_DT_ENGINE_VERSION = "DT-Engine-Version";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_NAME = "DT-App-Package-Name";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_VERSION = "DT-App-Package-Version";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_GROUP_ID = "DT-App-Package-Group-Id";
    public static final String ATTRIBUTE_CLASS_PATH = "Class-Path";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_DISPLAY_NAME = "DT-App-Package-Display-Name";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_DESCRIPTION = "DT-App-Package-Description";
    private final String appPackageName;
    private final String appPackageVersion;
    private final String appPackageGroupId;
    private final String dtEngineVersion;
    private final String appPackageDescription;
    private final String appPackageDisplayName;
    private final ArrayList<String> classPath = new ArrayList();
    private final File directory;
    private final List<AppInfo> applications = new ArrayList<AppInfo>();
    private final List<String> appJars = new ArrayList<String>();
    private final List<String> appJsonFiles = new ArrayList<String>();
    private final List<String> appPropertiesFiles = new ArrayList<String>();
    private final Set<String> requiredProperties = new TreeSet<String>();
    private final Map<String, String> defaultProperties = new TreeMap<String, String>();
    private final Set<String> configs = new TreeSet<String>();
    private final File resourcesDirectory;
    private final boolean cleanOnClose;
    private static final Logger LOG = LoggerFactory.getLogger(AppPackage.class);

    public AppPackage(File file) throws IOException, ZipException {
        this(file, false);
    }

    public AppPackage(File file, File contentFolder, boolean processAppDirectory) throws IOException, ZipException {
        super(file);
        if (contentFolder != null) {
            FileUtils.forceMkdir((File)contentFolder);
            this.cleanOnClose = false;
        } else {
            this.cleanOnClose = true;
            contentFolder = Files.createTempDirectory("dt-appPackage-", new FileAttribute[0]).toFile();
        }
        this.directory = contentFolder;
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            throw new IOException("Not a valid app package. MANIFEST.MF is not present.");
        }
        Attributes attr = manifest.getMainAttributes();
        this.appPackageName = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_NAME);
        this.appPackageVersion = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_VERSION);
        this.appPackageGroupId = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_GROUP_ID);
        this.dtEngineVersion = attr.getValue(ATTRIBUTE_DT_ENGINE_VERSION);
        this.appPackageDisplayName = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_DISPLAY_NAME);
        this.appPackageDescription = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_DESCRIPTION);
        String classPathString = attr.getValue(ATTRIBUTE_CLASS_PATH);
        if (this.appPackageName == null || this.appPackageVersion == null || classPathString == null) {
            throw new IOException("Not a valid app package.  App Package Name or Version or Class-Path is missing from MANIFEST.MF");
        }
        this.classPath.addAll(Arrays.asList(StringUtils.split((String)classPathString, (String)" ")));
        AppPackage.extractToDirectory(this.directory, file);
        File confDirectory = new File(this.directory, "conf");
        if (confDirectory.exists()) {
            this.processConfDirectory(confDirectory);
        }
        this.resourcesDirectory = new File(this.directory, "resources");
        File propertiesXml = new File(this.directory, "META-INF/properties.xml");
        if (propertiesXml.exists()) {
            this.processPropertiesXml(propertiesXml, null);
        }
        if (processAppDirectory) {
            this.processAppDirectory(false);
        }
    }

    private void processAppProperties() {
        for (AppInfo app : this.applications) {
            app.requiredProperties.addAll(this.requiredProperties);
            app.defaultProperties.putAll(this.defaultProperties);
            File appPropertiesXml = new File(this.directory, "META-INF/properties-" + app.name + ".xml");
            if (!appPropertiesXml.exists()) continue;
            this.processPropertiesXml(appPropertiesXml, app);
        }
    }

    public AppPackage(File file, boolean processAppDirectory) throws IOException, ZipException {
        this(file, null, processAppDirectory);
    }

    public static void extractToDirectory(File directory, File appPackageFile) throws ZipException {
        ZipFile zipFile = new ZipFile(appPackageFile);
        if (zipFile.isEncrypted()) {
            throw new ZipException("Encrypted app package not supported yet");
        }
        directory.mkdirs();
        zipFile.extractAll(directory.getAbsolutePath());
    }

    public static void createAppPackageFile(File fileToBeCreated, File directory) throws ZipException {
        ZipFile zipFile = new ZipFile(fileToBeCreated);
        ZipParameters params = new ZipParameters();
        params.setIncludeRootFolder(false);
        zipFile.addFolder(directory, params);
    }

    public File tempDirectory() {
        return this.directory;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.cleanOnClose) {
            this.cleanContent();
        }
    }

    public void cleanContent() throws IOException {
        FileUtils.deleteDirectory((File)this.directory);
        LOG.debug("App Package {}-{} folder {} is removed", new Object[]{this.appPackageName, this.appPackageVersion, this.directory.getAbsolutePath()});
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public String getAppPackageVersion() {
        return this.appPackageVersion;
    }

    public String getAppPackageGroupId() {
        return this.appPackageGroupId;
    }

    public String getAppPackageDescription() {
        return this.appPackageDescription;
    }

    public String getAppPackageDisplayName() {
        return this.appPackageDisplayName;
    }

    public String getDtEngineVersion() {
        return this.dtEngineVersion;
    }

    public List<String> getClassPath() {
        return Collections.unmodifiableList(this.classPath);
    }

    public Collection<String> getConfigs() {
        return Collections.unmodifiableCollection(this.configs);
    }

    public File resourcesDirectory() {
        return this.resourcesDirectory;
    }

    public List<AppInfo> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public List<String> getAppJars() {
        return Collections.unmodifiableList(this.appJars);
    }

    public List<String> getAppJsonFiles() {
        return Collections.unmodifiableList(this.appJsonFiles);
    }

    public List<String> getAppPropertiesFiles() {
        return Collections.unmodifiableList(this.appPropertiesFiles);
    }

    public Set<String> getRequiredProperties() {
        return Collections.unmodifiableSet(this.requiredProperties);
    }

    public Map<String, String> getDefaultProperties() {
        return Collections.unmodifiableMap(this.defaultProperties);
    }

    public void processAppDirectory(boolean skipJars) {
        File[] files;
        File dir = new File(this.directory, "app");
        this.applications.clear();
        Configuration config = new Configuration();
        ArrayList<String> absClassPath = new ArrayList<String>(this.classPath);
        for (int i = 0; i < absClassPath.size(); ++i) {
            String path = (String)absClassPath.get(i);
            if (path.startsWith("/")) continue;
            absClassPath.set(i, this.directory + "/" + path);
        }
        config.set("_apex.libjars", StringUtils.join(absClassPath, (char)','));
        for (File entry : files = dir.listFiles()) {
            if (!entry.getName().endsWith(".jar") || skipJars) continue;
            this.appJars.add(entry.getName());
            try {
                StramAppLauncher stramAppLauncher = new StramAppLauncher(entry, config);
                stramAppLauncher.loadDependencies();
                List<StramAppLauncher.AppFactory> appFactories = stramAppLauncher.getBundledTopologies();
                for (StramAppLauncher.AppFactory appFactory : appFactories) {
                    String appName = stramAppLauncher.getLogicalPlanConfiguration().getAppAlias(appFactory.getName());
                    if (appName == null) {
                        appName = appFactory.getName();
                    }
                    AppInfo appInfo = new AppInfo(appName, entry.getName(), "class");
                    appInfo.displayName = appFactory.getDisplayName();
                    try {
                        appInfo.dag = appFactory.createApp(stramAppLauncher.getLogicalPlanConfiguration());
                        appInfo.dag.validate();
                    }
                    catch (Throwable ex) {
                        appInfo.error = ex.getMessage();
                        appInfo.errorStackTrace = ExceptionUtils.getStackTrace((Throwable)ex);
                    }
                    this.applications.add(appInfo);
                }
            }
            catch (Exception ex) {
                LOG.error("Caught exception trying to process {}", (Object)entry.getName(), (Object)ex);
            }
        }
        for (String appJar : this.appJars) {
            absClassPath.add(new File(dir, appJar).getAbsolutePath());
        }
        config.set("_apex.libjars", StringUtils.join(absClassPath, (char)','));
        for (File entry : files = dir.listFiles()) {
            if (entry.getName().endsWith(".json")) {
                this.appJsonFiles.add(entry.getName());
                AppInfo appInfo = StramClientUtils.jsonFileToAppInfo(entry, config);
                if (appInfo == null) continue;
                this.applications.add(appInfo);
                continue;
            }
            if (entry.getName().endsWith(".properties")) {
                this.appPropertiesFiles.add(entry.getName());
                try {
                    StramAppLauncher.PropertyFileAppFactory appFactory = new StramAppLauncher.PropertyFileAppFactory(entry);
                    StramAppLauncher stramAppLauncher = new StramAppLauncher(entry.getName(), config);
                    stramAppLauncher.loadDependencies();
                    AppInfo appInfo = new AppInfo(appFactory.getName(), entry.getName(), "properties");
                    appInfo.displayName = appFactory.getDisplayName();
                    try {
                        appInfo.dag = appFactory.createApp(stramAppLauncher.getLogicalPlanConfiguration());
                        appInfo.dag.validate();
                    }
                    catch (Throwable t) {
                        appInfo.error = t.getMessage();
                        appInfo.errorStackTrace = ExceptionUtils.getStackTrace((Throwable)t);
                    }
                    this.applications.add(appInfo);
                }
                catch (Exception ex) {
                    LOG.error("Caught exceptions trying to process {}", (Object)entry.getName(), (Object)ex);
                }
                continue;
            }
            if (entry.getName().endsWith(".jar")) continue;
            LOG.warn("Ignoring file {} with unknown extension in app directory", (Object)entry.getName());
        }
        this.processAppProperties();
    }

    private void processConfDirectory(File dir) {
        File[] files;
        for (File entry : files = dir.listFiles()) {
            if (!entry.getName().endsWith(".xml")) continue;
            this.configs.add(entry.getName());
        }
    }

    private void processPropertiesXml(File file, AppInfo app) {
        DTConfiguration config = new DTConfiguration();
        try {
            config.loadFile(file);
            for (Map.Entry<String, String> entry : config) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) {
                    if (app == null) {
                        this.requiredProperties.add(key);
                        continue;
                    }
                    app.requiredProperties.add(key);
                    continue;
                }
                if (app == null) {
                    this.defaultProperties.put(key, value);
                    continue;
                }
                app.requiredProperties.remove(key);
                app.defaultProperties.put(key, value);
            }
        }
        catch (Exception ex) {
            LOG.warn("Ignoring META_INF/properties.xml because of error", (Throwable)ex);
        }
    }

    public static class AppInfo {
        public final String name;
        public final String file;
        public final String type;
        public String displayName;
        public LogicalPlan dag;
        public String error;
        public String errorStackTrace;
        public Set<String> requiredProperties = new TreeSet<String>();
        public Map<String, String> defaultProperties = new TreeMap<String, String>();

        public AppInfo(String name, String file, String type) {
            this.name = name;
            this.file = file;
            this.type = type;
        }
    }
}

