/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResolvers {
    public static final String SCHEME_MANIFEST = "manifest";
    public static final String SCHEME_MVN = "mvn";

    public List<Resolver> createResolvers(String resolverConfig) {
        String[] specs = resolverConfig.split(",");
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>(specs.length);
        for (String s : specs) {
            String[] comps = (s = s.trim()).split(":");
            if (comps.length == 0) {
                throw new IllegalArgumentException(String.format("Invalid resolver spec %s in %s", s, resolverConfig));
            }
            if (SCHEME_MANIFEST.equals(comps[0])) {
                if (comps.length < 2) {
                    throw new IllegalArgumentException(String.format("Missing repository path in manifest resolver spec %s in %s", s, resolverConfig));
                }
                File baseDir = new File(comps[1]);
                resolvers.add(new ManifestResolver(baseDir));
                continue;
            }
            if (SCHEME_MVN.equals(comps[0])) {
                MavenResolver mvnr = new MavenResolver();
                if (comps.length > 1) {
                    mvnr.userHome = comps[1];
                }
                resolvers.add(mvnr);
                continue;
            }
            throw new NotImplementedException("Unknown resolver scheme " + comps[0]);
        }
        return resolvers;
    }

    public static class MavenResolver
    implements Resolver {
        private static final Logger LOG = LoggerFactory.getLogger(MavenResolver.class);
        private String userHome;

        @Override
        public void resolve(JarFileContext jfc) throws IOException {
            File pomFile;
            File baseDir = jfc.cacheDir;
            baseDir.mkdirs();
            File pomCrcFile = new File(baseDir, "pom.xml.crc");
            File cpFile = new File(baseDir, "mvn-classpath");
            long pomCrc = 0L;
            String cp = null;
            if (cpFile.exists()) {
                try (DataInputStream dis = new DataInputStream(new FileInputStream(pomCrcFile));){
                    pomCrc = dis.readLong();
                    cp = FileUtils.readFileToString((File)cpFile, (String)"UTF-8");
                }
                catch (Exception e) {
                    LOG.error("Cannot read CRC from {}", (Object)pomCrcFile);
                }
            }
            FileUtils.deleteDirectory((File)baseDir);
            if (jfc.pomEntry != null) {
                File pomDst = new File(baseDir, "pom.xml");
                FileUtils.copyInputStreamToFile((InputStream)jfc.jarFile.getInputStream(jfc.pomEntry), (File)pomDst);
                if (pomCrc != jfc.pomEntry.getCrc()) {
                    LOG.info("CRC of " + jfc.pomEntry.getName() + " changed, invalidating cached classpath.");
                    cp = null;
                    pomCrc = jfc.pomEntry.getCrc();
                }
            }
            if ((pomFile = new File(baseDir, "pom.xml")).exists()) {
                if (cp == null) {
                    cp = this.generateClassPathFromPom(pomFile, cpFile, jfc);
                }
                if (cp != null) {
                    String[] pathList;
                    try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(pomCrcFile));){
                        dos.writeLong(pomCrc);
                    }
                    FileUtils.writeStringToFile((File)cpFile, (String)cp, (boolean)false);
                    for (String path : pathList = StringUtils.splitByWholeSeparator((String)cp, (String)":")) {
                        jfc.urls.add(new File(path).toURI().toURL());
                    }
                }
            }
        }

        private String generateClassPathFromPom(File pomFile, File cpFile, JarFileContext jfc) throws IOException {
            LOG.info("Generating classpath via mvn from " + pomFile);
            LOG.info("java.home: " + System.getProperty("java.home"));
            String dt_home = StringUtils.isEmpty((String)this.userHome) ? "" : " -Duser.home=" + this.userHome;
            String cmd = "mvn dependency:build-classpath" + dt_home + " -q -Dmdep.outputFile=" + cpFile.getAbsolutePath() + " -f " + pomFile;
            LOG.debug("Executing: {}", (Object)cmd);
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
            ProcessWatcher pw = new ProcessWatcher(p);
            InputStream output = p.getInputStream();
            while (!pw.isFinished()) {
                IOUtils.copy((InputStream)output, (Writer)jfc.consoleOutput);
            }
            if (pw.rc != 0) {
                throw new RuntimeException("Failed to run: " + cmd + " (exit code " + pw.rc + ")" + "\n" + jfc.consoleOutput.toString());
            }
            String cp = FileUtils.readFileToString((File)cpFile);
            return cp;
        }

        public static class ProcessWatcher
        implements Runnable {
            private final Process p;
            private volatile boolean finished = false;
            private volatile int rc;

            public ProcessWatcher(Process p) {
                this.p = p;
                new Thread(this).start();
            }

            public boolean isFinished() {
                return this.finished;
            }

            @Override
            public void run() {
                try {
                    this.rc = this.p.waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.finished = true;
            }
        }
    }

    public static class ManifestResolver
    implements Resolver {
        private static final Logger LOG = LoggerFactory.getLogger(ManifestResolver.class);
        public static final Attributes.Name ATTR_NAME = Attributes.Name.CLASS_PATH;
        public final File baseDir;

        public ManifestResolver(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        public void resolve(JarFileContext jfc) throws IOException {
            String jarClasspath = jfc.jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (jarClasspath != null) {
                String[] jars;
                LOG.debug("Using manifest attribute {} to resolve dependencies", (Object)Attributes.Name.CLASS_PATH);
                for (String jar : jars = jarClasspath.split(" ")) {
                    File f = new File(this.baseDir, jar);
                    if (!f.exists()) continue;
                    jfc.urls.add(f.getAbsoluteFile().toURI().toURL());
                }
            }
        }
    }

    static interface Resolver {
        public void resolve(JarFileContext var1) throws IOException;
    }

    public static class JarFileContext {
        File filePath;
        File cacheDir;
        final JarFile jarFile;
        final StringWriter consoleOutput;
        JarEntry pomEntry;
        LinkedHashSet<URL> urls = new LinkedHashSet();

        public JarFileContext(JarFile file, StringWriter consoleOutput) {
            this.jarFile = file;
            this.consoleOutput = consoleOutput;
        }
    }
}

