/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.client.AppPackage;
import com.datatorrent.stram.client.DTConfiguration;
import com.datatorrent.stram.client.StramClientUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPackage
extends JarFile
implements Closeable {
    public static final String ATTRIBUTE_DT_CONF_PACKAGE_NAME = "DT-Conf-Package-Name";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_NAME = "DT-App-Package-Name";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_GROUP_ID = "DT-App-Package-Group-Id";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_MIN_VERSION = "DT-App-Package-Min-Version";
    public static final String ATTRIBUTE_DT_APP_PACKAGE_MAX_VERSION = "DT-App-Package-Max-Version";
    public static final String ATTRIBUTE_DT_CONF_PACKAGE_DESCRIPTION = "DT-Conf-Package-Description";
    public static final String ATTRIBUTE_CLASS_PATH = "Class-Path";
    public static final String ATTRIBUTE_FILES = "Files";
    private final String configPackageName;
    private final String appPackageName;
    private final String appPackageGroupId;
    private final String appPackageMinVersion;
    private final String appPackageMaxVersion;
    private final String configPackageDescription;
    private final ArrayList<String> classPath = new ArrayList();
    private final ArrayList<String> files = new ArrayList();
    private final String directory;
    private final Map<String, String> properties = new TreeMap<String, String>();
    private final Map<String, Map<String, String>> appProperties = new TreeMap<String, Map<String, String>>();
    private final List<AppPackage.AppInfo> applications = new ArrayList<AppPackage.AppInfo>();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigPackage.class);

    public ConfigPackage(File file) throws IOException, ZipException {
        super(file);
        ZipFile zipFile;
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            throw new IOException("Not a valid config package. MANIFEST.MF is not present.");
        }
        Attributes attr = manifest.getMainAttributes();
        this.configPackageName = attr.getValue(ATTRIBUTE_DT_CONF_PACKAGE_NAME);
        this.appPackageName = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_NAME);
        this.appPackageGroupId = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_GROUP_ID);
        this.appPackageMinVersion = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_MIN_VERSION);
        this.appPackageMaxVersion = attr.getValue(ATTRIBUTE_DT_APP_PACKAGE_MAX_VERSION);
        this.configPackageDescription = attr.getValue(ATTRIBUTE_DT_CONF_PACKAGE_DESCRIPTION);
        String classPathString = attr.getValue(ATTRIBUTE_CLASS_PATH);
        String filesString = attr.getValue(ATTRIBUTE_FILES);
        if (this.configPackageName == null) {
            throw new IOException("Not a valid config package.  DT-Conf-Package-Name is missing from MANIFEST.MF");
        }
        if (!StringUtils.isBlank((CharSequence)classPathString)) {
            this.classPath.addAll(Arrays.asList(StringUtils.split((String)classPathString, (String)" ")));
        }
        if (!StringUtils.isBlank((CharSequence)filesString)) {
            this.files.addAll(Arrays.asList(StringUtils.split((String)filesString, (String)" ")));
        }
        if ((zipFile = new ZipFile(file)).isEncrypted()) {
            throw new ZipException("Encrypted conf package not supported yet");
        }
        File newDirectory = Files.createTempDirectory("dt-configPackage-", new FileAttribute[0]).toFile();
        newDirectory.mkdirs();
        this.directory = newDirectory.getAbsolutePath();
        zipFile.extractAll(this.directory);
        this.processPropertiesXml();
        this.processAppDirectory(new File(this.directory, "app"));
    }

    public List<AppPackage.AppInfo> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public String tempDirectory() {
        return this.directory;
    }

    @Override
    public void close() throws IOException {
        super.close();
        FileUtils.deleteDirectory((File)new File(this.directory));
    }

    public String getConfigPackageName() {
        return this.configPackageName;
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public String getAppPackageGroupId() {
        return this.appPackageGroupId;
    }

    public String getAppPackageMinVersion() {
        return this.appPackageMinVersion;
    }

    public String getAppPackageMaxVersion() {
        return this.appPackageMaxVersion;
    }

    public String getConfigPackageDescription() {
        return this.configPackageDescription;
    }

    public List<String> getClassPath() {
        return Collections.unmodifiableList(this.classPath);
    }

    public List<String> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public Map<String, String> getProperties(String appName) {
        if (appName == null || !this.appProperties.containsKey(appName)) {
            return this.properties;
        }
        return this.appProperties.get(appName);
    }

    private void processAppDirectory(File dir) {
        File[] files;
        if (!dir.exists()) {
            return;
        }
        Configuration config = new Configuration();
        ArrayList<String> absClassPath = new ArrayList<String>(this.classPath);
        for (int i = 0; i < absClassPath.size(); ++i) {
            String path = (String)absClassPath.get(i);
            if (path.startsWith("/")) continue;
            absClassPath.set(i, this.directory + "/" + path);
        }
        config.set("_apex.libjars", StringUtils.join(absClassPath, (char)','));
        for (File entry : files = dir.listFiles()) {
            AppPackage.AppInfo appInfo;
            if (!entry.getName().endsWith(".json") || (appInfo = StramClientUtils.jsonFileToAppInfo(entry, config)) == null) continue;
            this.applications.add(appInfo);
        }
    }

    private void processPropertiesXml() {
        File dir = new File(this.directory, "META-INF");
        File p = new File(dir, "properties.xml");
        if (p.exists()) {
            ConfigPackage.parsePropertiesXml(p, this.properties);
        }
        for (File file : dir.listFiles()) {
            String name = file.getName();
            if (name.length() <= 15 || !name.startsWith("properties-") || !name.endsWith(".xml")) continue;
            String appName = name.substring(11, name.length() - 4);
            TreeMap<String, String> dp = new TreeMap<String, String>(this.properties);
            ConfigPackage.parsePropertiesXml(file, dp);
            this.appProperties.put(appName, dp);
        }
    }

    private static void parsePropertiesXml(File file, Map<String, String> properties) {
        DTConfiguration config = new DTConfiguration();
        try {
            config.loadFile(file);
            for (Map.Entry<String, String> entry : config) {
                String key = entry.getKey();
                String value = entry.getValue();
                properties.put(key, value);
            }
        }
        catch (Exception ex) {
            LOG.warn("Ignoring {} because of error", (Object)ex, (Object)file.getName());
        }
    }
}

