/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.BooleanUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DTConfiguration
implements Iterable<Map.Entry<String, String>> {
    private final Map<String, ValueEntry> map = new LinkedHashMap<String, ValueEntry>();
    private static final Logger LOG = LoggerFactory.getLogger(DTConfiguration.class);

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ValueEntry> entry : this.map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().value);
        }
        return result.entrySet().iterator();
    }

    public void writeToFile(File file, Scope scope, String comment) throws IOException {
        Document doc;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = new Date();
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        Element rootElement = doc.createElement("configuration");
        rootElement.appendChild(doc.createComment(" WARNING: Do not edit this file. Your changes will be overwritten. "));
        rootElement.appendChild(doc.createComment(" Written by dtgateway on " + sdf.format(date)));
        rootElement.appendChild(doc.createComment(" " + comment + " "));
        doc.appendChild(rootElement);
        for (Map.Entry<String, ValueEntry> entry : this.map.entrySet()) {
            ValueEntry valueEntry = entry.getValue();
            if (scope != null && valueEntry.scope != scope) continue;
            Element property = doc.createElement("property");
            rootElement.appendChild(property);
            Element name = doc.createElement("name");
            name.appendChild(doc.createTextNode(entry.getKey()));
            property.appendChild(name);
            Element value = doc.createElement("value");
            value.appendChild(doc.createTextNode(valueEntry.value));
            property.appendChild(value);
            if (valueEntry.description != null) {
                Element description = doc.createElement("description");
                description.appendChild(doc.createTextNode(valueEntry.description));
                property.appendChild(description);
            }
            if (!valueEntry.isFinal) continue;
            Element isFinal = doc.createElement("final");
            isFinal.appendChild(doc.createTextNode("true"));
            property.appendChild(isFinal);
        }
        rootElement.appendChild(doc.createComment(" WARNING: Do not edit this file. Your changes will be overwritten. "));
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
    }

    public void writeToFile(File file, String comment) throws IOException {
        this.writeToFile(file, null, comment);
    }

    public void loadFile(File file, Scope defaultScope) throws IOException, ParserConfigurationException, SAXException, ConfigException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        Element documentElement = doc.getDocumentElement();
        if (!documentElement.getNodeName().equals("configuration")) {
            throw new ConfigException("Root element needs to be \"configuration\"");
        }
        if (doc.hasChildNodes()) {
            NodeList propertyNodes = documentElement.getChildNodes();
            for (int i = 0; i < propertyNodes.getLength(); ++i) {
                Node propertyNode = propertyNodes.item(i);
                if (propertyNode.getNodeType() != 1) continue;
                if (propertyNode.getNodeName().equals("property")) {
                    this.processPropertyNode((Element)propertyNode, defaultScope);
                    continue;
                }
                LOG.warn("Ignoring unknown element {}", (Object)propertyNode.getNodeName());
            }
        }
    }

    public void loadFile(File file) throws IOException, ParserConfigurationException, SAXException, ConfigException {
        this.loadFile(file, Scope.TRANSIENT);
    }

    private void processPropertyNode(Element propertyNode, Scope defaultScope) {
        NodeList nodeList = propertyNode.getElementsByTagName("name");
        if (nodeList.getLength() == 0 || nodeList.item(0).getTextContent().isEmpty()) {
            LOG.warn("Name element not found, ignoring property entry");
            return;
        }
        String name = nodeList.item(0).getTextContent().trim();
        ValueEntry valueEntry = new ValueEntry();
        nodeList = propertyNode.getElementsByTagName("value");
        valueEntry.value = nodeList.getLength() == 0 ? null : nodeList.item(0).getTextContent().trim();
        nodeList = propertyNode.getElementsByTagName("description");
        if (nodeList.getLength() > 0) {
            valueEntry.description = nodeList.item(0).getTextContent().trim();
        }
        if ((nodeList = propertyNode.getElementsByTagName("final")).getLength() > 0) {
            valueEntry.isFinal = BooleanUtils.toBoolean((String)nodeList.item(0).getTextContent());
        }
        valueEntry.scope = defaultScope;
        if (this.map.containsKey(name) && this.map.get((Object)name).isFinal) {
            LOG.warn("Trying to override final property {}, ignoring property entry", (Object)name);
            return;
        }
        this.map.put(name, valueEntry);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public String get(String key) {
        ValueEntry value = this.map.get(key);
        return value == null ? null : value.value;
    }

    public String getDescription(String key) {
        ValueEntry value = this.map.get(key);
        return value == null ? null : value.description;
    }

    public Scope getScope(String key) {
        ValueEntry value = this.map.get(key);
        return value == null ? Scope.TRANSIENT : value.scope;
    }

    public Integer getInteger(String key) {
        String value = this.get(key);
        return value == null ? null : Integer.valueOf(value);
    }

    public Long getLong(String key) {
        String value = this.get(key);
        return value == null ? null : Long.valueOf(value);
    }

    public Float getFloat(String key) {
        String value = this.get(key);
        return value == null ? null : Float.valueOf(value);
    }

    public Double getDouble(String key) {
        String value = this.get(key);
        return value == null ? null : Double.valueOf(value);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public ValueEntry setInternal(String key, String value) {
        ValueEntry valueEntry;
        if (this.map.containsKey(key)) {
            valueEntry = this.map.get(key);
            valueEntry.value = value;
        } else {
            valueEntry = new ValueEntry();
            valueEntry.scope = DTConfiguration.isLocalKey(key) ? Scope.LOCAL : Scope.TRANSIENT;
            this.map.put(key, valueEntry);
        }
        return valueEntry;
    }

    public ValueEntry set(String key, String value, Scope scope, String description) throws ConfigException {
        ValueEntry valueEntry;
        if (this.map.containsKey(key)) {
            valueEntry = this.map.get(key);
            if (valueEntry.isFinal) {
                throw new ConfigException("Cannot set final property " + key);
            }
        } else {
            valueEntry = new ValueEntry();
        }
        valueEntry.value = value;
        valueEntry.description = description;
        valueEntry.scope = DTConfiguration.isLocalKey(key) ? Scope.LOCAL : scope;
        this.map.put(key, valueEntry);
        return valueEntry;
    }

    public static boolean isLocalKey(String key) {
        return key.equals("dt.dfsRootDirectory") || key.equals("dt.gateway.listenAddress") || key.equals("dt.configStatus") || key.equals("dt.version") || key.equals("dt." + LogicalPlan.GATEWAY_CONNECT_ADDRESS.getName());
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, ValueEntry> entry : this.map.entrySet()) {
            try {
                JSONObject jsonValue = new JSONObject();
                jsonValue.put("value", (Object)entry.getValue().value);
                if (entry.getValue().description != null) {
                    jsonValue.put("description", (Object)entry.getValue().description);
                }
                jsonValue.put("scope", (Object)entry.getValue().scope);
                json.put(entry.getKey(), (Object)jsonValue);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        return json;
    }

    public JSONObject toJSONObject(String key) {
        JSONObject json = new JSONObject();
        ValueEntry valueEntry = this.map.get(key);
        if (valueEntry != null) {
            try {
                json = new JSONObject();
                json.put("value", (Object)valueEntry.value);
                if (valueEntry.description != null) {
                    json.put("description", (Object)valueEntry.description);
                }
                if (valueEntry.scope == Scope.LOCAL) {
                    json.put("scope", (Object)valueEntry.scope);
                }
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
            return json;
        }
        return null;
    }

    public static class ConfigException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConfigException(String message) {
            super(message);
        }
    }

    public static class ValueEntry {
        public String value;
        public boolean isFinal = false;
        public Scope scope = Scope.TRANSIENT;
        public String description;
    }

    public static enum Scope {
        GLOBAL,
        LOCAL,
        USER,
        TRANSIENT;

    }
}

