/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import java.util.Set;
import java.util.TreeSet;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class PermissionsInfo {
    private final Set<String> readOnlyRoles = new TreeSet<String>();
    private final Set<String> readOnlyUsers = new TreeSet<String>();
    private final Set<String> readWriteRoles = new TreeSet<String>();
    private final Set<String> readWriteUsers = new TreeSet<String>();
    private boolean readOnlyEveryone = false;
    private boolean readWriteEveryone = false;

    public PermissionsInfo() {
    }

    public PermissionsInfo(JSONObject json) throws JSONException {
        int i;
        JSONArray users;
        JSONObject readOnly = json.optJSONObject("readOnly");
        JSONObject readWrite = json.optJSONObject("readWrite");
        if (readOnly != null) {
            JSONArray roles;
            users = readOnly.optJSONArray("users");
            if (users != null) {
                for (int i2 = 0; i2 < users.length(); ++i2) {
                    this.readOnlyUsers.add(users.getString(i2));
                }
            }
            if ((roles = readOnly.optJSONArray("roles")) != null) {
                for (i = 0; i < roles.length(); ++i) {
                    this.readOnlyRoles.add(roles.getString(i));
                }
            }
            this.readOnlyEveryone = readOnly.optBoolean("everyone", false);
        }
        if (readWrite != null) {
            JSONArray roles;
            users = readWrite.optJSONArray("users");
            if (users != null) {
                for (int i3 = 0; i3 < users.length(); ++i3) {
                    this.readWriteUsers.add(users.getString(i3));
                }
            }
            if ((roles = readWrite.optJSONArray("roles")) != null) {
                for (i = 0; i < roles.length(); ++i) {
                    this.readWriteRoles.add(roles.getString(i));
                }
            }
            this.readWriteEveryone = readWrite.optBoolean("everyone", false);
        }
    }

    public void addReadOnlyRole(String role) {
        this.readOnlyRoles.add(role);
    }

    public void removeReadOnlyRole(String role) {
        this.readOnlyRoles.remove(role);
    }

    public void addReadOnlyUser(String user) {
        this.readOnlyUsers.add(user);
    }

    public void removeReadOnlyUser(String user) {
        this.readOnlyUsers.remove(user);
    }

    public void setReadOnlyEveryone(boolean readOnlyEveryone) {
        this.readOnlyEveryone = readOnlyEveryone;
    }

    public void addReadWriteRole(String role) {
        this.readWriteRoles.add(role);
    }

    public void removeReadWriteRole(String role) {
        this.readWriteRoles.remove(role);
    }

    public void addReadWriteUser(String user) {
        this.readWriteRoles.add(user);
    }

    public void removeReadWriteUser(String user) {
        this.readWriteUsers.remove(user);
    }

    public void setReadWriteEveryone(boolean readWriteEveryone) {
        this.readWriteEveryone = readWriteEveryone;
    }

    public boolean canRead(String userName, Set<String> roles) {
        if (this.canWrite(userName, roles)) {
            return true;
        }
        if (this.readOnlyEveryone) {
            return true;
        }
        if (this.readOnlyUsers.contains(userName)) {
            return true;
        }
        for (String role : roles) {
            if (!this.readOnlyRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean canWrite(String userName, Set<String> roles) {
        if (this.readWriteEveryone) {
            return true;
        }
        if (this.readWriteUsers.contains(userName)) {
            return true;
        }
        for (String role : roles) {
            if (!this.readWriteRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public JSONObject toJSONObject() {
        JSONObject result = new JSONObject();
        JSONObject readOnly = new JSONObject();
        JSONObject readWrite = new JSONObject();
        try {
            readOnly.put("users", (Object)new JSONArray(this.readOnlyUsers));
            readOnly.put("roles", (Object)new JSONArray(this.readOnlyRoles));
            readOnly.put("everyone", this.readOnlyEveryone);
            readWrite.put("users", (Object)new JSONArray(this.readWriteUsers));
            readWrite.put("roles", (Object)new JSONArray(this.readWriteRoles));
            readWrite.put("everyone", this.readWriteEveryone);
            result.put("readOnly", (Object)readOnly);
            result.put("readWrite", (Object)readWrite);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }
}

