/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.common.util.ObjectMapperString;
import com.datatorrent.stram.client.FSPartFileAgent;
import com.datatorrent.stram.client.StramAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.ser.std.ToStringSerializer;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatsAgent
extends FSPartFileAgent {
    private static final Logger LOG = LoggerFactory.getLogger(StatsAgent.class);

    public StatsAgent(StramAgent stramAgent) {
        super(stramAgent);
    }

    public String getOperatorStatsDirectory(String appId, String opName) {
        return this.getStatsDirectory(appId) + "/" + "operators" + "/" + opName;
    }

    public String getContainerStatsDirectory(String appId) {
        return this.getStatsDirectory(appId) + "/" + "containers";
    }

    public String getStatsDirectory(String appId) {
        String appPath = this.stramAgent.getAppPath(appId);
        if (appPath == null) {
            return null;
        }
        return appPath + "/" + "stats";
    }

    @Override
    protected StatsIndexLine parseIndexLine(String line) throws JSONException {
        StatsIndexLine info = new StatsIndexLine();
        if (line.startsWith("E")) {
            info.isEndLine = true;
            return info;
        }
        line = line.trim();
        int cursor = 2;
        int cursor2 = line.indexOf(58, cursor);
        info.partFile = line.substring(cursor, cursor2);
        cursor = cursor2 + 1;
        cursor2 = line.indexOf(58, cursor);
        String timeRange = line.substring(cursor, cursor2);
        String[] tmp = timeRange.split("-");
        info.startTime = Long.valueOf(tmp[0]);
        info.endTime = Long.valueOf(tmp[1]);
        cursor = cursor2 + 1;
        info.count = Long.valueOf(line.substring(cursor));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ContainersInfo getContainersInfo(String appId) {
        FSPartFileAgent.IndexFileBufferedReader ifbr;
        BufferedReader br;
        ContainersInfo info;
        block15: {
            ContainersInfo containersInfo;
            block14: {
                info = new ContainersInfo();
                info.appId = appId;
                info.containers = new HashMap<Integer, ContainerInfo>();
                String dir = this.getContainerStatsDirectory(appId);
                if (dir == null) {
                    return null;
                }
                Path path = new Path(dir);
                br = null;
                ifbr = null;
                try {
                    StatsIndexLine indexLine;
                    FileStatus fileStatus = this.stramAgent.getFileSystem().getFileStatus(path);
                    if (!fileStatus.isDirectory()) {
                        ContainersInfo containersInfo2 = null;
                        return containersInfo2;
                    }
                    br = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "meta.txt"))));
                    String line = br.readLine();
                    if (!line.equals("1.0")) {
                        containersInfo = null;
                        IOUtils.closeQuietly((Reader)br);
                        break block14;
                    }
                    while ((line = br.readLine()) != null) {
                        int cursor = line.indexOf(58);
                        int index = Integer.valueOf(line.substring(0, cursor));
                        JSONObject json = new JSONObject(line.substring(cursor + 1));
                        ContainerInfo containerInfo = new ContainerInfo();
                        containerInfo.host = json.getString("host");
                        containerInfo.jvmName = json.getString("jvmName");
                        containerInfo.id = json.getString("id");
                        containerInfo.memoryMBAllocated = json.getInt("memoryMBAllocated");
                        info.containers.put(index, containerInfo);
                    }
                    ifbr = new FSPartFileAgent.IndexFileBufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "index.txt"))), dir);
                    while ((indexLine = (StatsIndexLine)ifbr.readIndexLine()) != null) {
                        if (indexLine.isEndLine) {
                            info.ended = true;
                            continue;
                        }
                        info.count += indexLine.count;
                        if (info.startTime == 0L || info.startTime > indexLine.startTime) {
                            info.startTime = indexLine.startTime;
                        }
                        if (info.endTime != 0L && info.endTime >= indexLine.endTime) continue;
                        info.endTime = indexLine.endTime;
                    }
                    IOUtils.closeQuietly((Reader)br);
                    break block15;
                }
                catch (Exception ex) {
                    LOG.warn("Got exception when reading containers info", (Throwable)ex);
                    ContainersInfo containersInfo3 = null;
                    return containersInfo3;
                }
            }
            IOUtils.closeQuietly(ifbr);
            return containersInfo;
        }
        IOUtils.closeQuietly((Reader)ifbr);
        return info;
        finally {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(ifbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperatorsInfo getOperatorsInfo(String appId, String opName) {
        FSPartFileAgent.IndexFileBufferedReader ifbr;
        BufferedReader br;
        OperatorsInfo info;
        block15: {
            OperatorsInfo operatorsInfo;
            block14: {
                info = new OperatorsInfo();
                info.appId = appId;
                info.operatorName = opName;
                info.operatorIds = new ArrayList<Integer>();
                String dir = this.getOperatorStatsDirectory(appId, opName);
                if (dir == null) {
                    return null;
                }
                Path path = new Path(dir);
                br = null;
                ifbr = null;
                try {
                    StatsIndexLine indexLine;
                    FileStatus fileStatus = this.stramAgent.getFileSystem().getFileStatus(path);
                    if (!fileStatus.isDirectory()) {
                        OperatorsInfo operatorsInfo2 = null;
                        return operatorsInfo2;
                    }
                    br = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "meta.txt"))));
                    String line = br.readLine();
                    if (!line.equals("1.0")) {
                        operatorsInfo = null;
                        IOUtils.closeQuietly(ifbr);
                        break block14;
                    }
                    while ((line = br.readLine()) != null) {
                        JSONObject json = new JSONObject(line);
                        info.operatorIds.add(json.getInt("id"));
                    }
                    ifbr = new FSPartFileAgent.IndexFileBufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "index.txt"))), dir);
                    while ((indexLine = (StatsIndexLine)ifbr.readIndexLine()) != null) {
                        if (indexLine.isEndLine) {
                            info.ended = true;
                            continue;
                        }
                        info.count += indexLine.count;
                        if (info.startTime == 0L || info.startTime > indexLine.startTime) {
                            info.startTime = indexLine.startTime;
                        }
                        if (info.endTime != 0L && info.endTime >= indexLine.endTime) continue;
                        info.endTime = indexLine.endTime;
                    }
                    IOUtils.closeQuietly((Reader)ifbr);
                    break block15;
                }
                catch (Exception ex) {
                    LOG.warn("Got exception when reading operators info", (Throwable)ex);
                    OperatorsInfo operatorsInfo3 = null;
                    return operatorsInfo3;
                }
            }
            IOUtils.closeQuietly((Reader)br);
            return operatorsInfo;
        }
        IOUtils.closeQuietly((Reader)br);
        return info;
        finally {
            IOUtils.closeQuietly(ifbr);
            IOUtils.closeQuietly(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperatorStatsInfo> getOperatorsStats(String appId, String opName, Long startTime, Long endTime) {
        ArrayList<OperatorStatsInfo> result = new ArrayList<OperatorStatsInfo>();
        String dir = this.getOperatorStatsDirectory(appId, opName);
        if (dir == null) {
            return null;
        }
        FSPartFileAgent.IndexFileBufferedReader ifbr = null;
        try {
            BufferedReader partBr;
            StatsIndexLine indexLine;
            ifbr = new FSPartFileAgent.IndexFileBufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "index.txt"))), dir);
            String lastProcessPartFile = null;
            while ((indexLine = (StatsIndexLine)ifbr.readIndexLine()) != null) {
                if (indexLine.isEndLine) continue;
                lastProcessPartFile = indexLine.partFile;
                if (startTime != null && startTime > indexLine.endTime) continue;
                if (endTime != null && endTime < indexLine.startTime) {
                    ArrayList<OperatorStatsInfo> arrayList = result;
                    IOUtils.closeQuietly((Reader)ifbr);
                    return arrayList;
                }
                partBr = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, indexLine.partFile))));
                Throwable throwable = null;
                try {
                    this.processOperatorPartFile(partBr, startTime, endTime, result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partBr == null) continue;
                    if (throwable != null) {
                        try {
                            partBr.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    partBr.close();
                }
            }
            partBr = null;
            try {
                String extraPartFile = StatsAgent.getNextPartFile(lastProcessPartFile);
                if (extraPartFile != null) {
                    partBr = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, extraPartFile))));
                    this.processOperatorPartFile(partBr, startTime, endTime, result);
                }
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly(partBr);
            }
            IOUtils.closeQuietly((Reader)ifbr);
        }
        catch (Exception ex) {
            LOG.warn("Got exception when reading operators stats", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(ifbr);
        }
        return result;
    }

    private void processOperatorPartFile(BufferedReader partBr, Long startTime, Long endTime, List<OperatorStatsInfo> result) throws IOException {
        String partLine;
        while ((partLine = partBr.readLine()) != null) {
            OperatorStatsInfo os = new OperatorStatsInfo();
            int cursor = 0;
            int cursor2 = partLine.indexOf(58, cursor);
            os.operatorId = Integer.valueOf(partLine.substring(cursor, cursor2));
            cursor = cursor2 + 1;
            cursor2 = partLine.indexOf(58, cursor);
            os.timestamp = Long.valueOf(partLine.substring(cursor, cursor2));
            cursor = cursor2 + 1;
            os.stats = new ObjectMapperString(partLine.substring(cursor));
            if (startTime != null && os.timestamp < startTime || endTime != null && os.timestamp > endTime) continue;
            result.add(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerStatsInfo> getContainersStats(String appId, Long startTime, Long endTime) {
        ArrayList<ContainerStatsInfo> result = new ArrayList<ContainerStatsInfo>();
        String dir = this.getContainerStatsDirectory(appId);
        if (dir == null) {
            return null;
        }
        BufferedReader br = null;
        String lastProcessPartFile = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, "index.txt"))));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("F:")) continue;
                StatsIndexLine indexLine = this.parseIndexLine(line);
                lastProcessPartFile = indexLine.partFile;
                if (startTime != null && startTime > indexLine.endTime) continue;
                if (endTime != null && endTime < indexLine.startTime) {
                    ArrayList<ContainerStatsInfo> arrayList = result;
                    IOUtils.closeQuietly((Reader)br);
                    return arrayList;
                }
                BufferedReader partBr = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, indexLine.partFile))));
                Throwable throwable = null;
                try {
                    this.processContainerPartFile(partBr, startTime, endTime, result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partBr == null) continue;
                    if (throwable != null) {
                        try {
                            partBr.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    partBr.close();
                }
            }
            BufferedReader partBr = null;
            try {
                String extraPartFile = StatsAgent.getNextPartFile(lastProcessPartFile);
                if (extraPartFile != null) {
                    partBr = new BufferedReader(new InputStreamReader((InputStream)this.stramAgent.getFileSystem().open(new Path(dir, extraPartFile))));
                    this.processContainerPartFile(partBr, startTime, endTime, result);
                }
            }
            catch (Exception exception) {
            }
            finally {
                IOUtils.closeQuietly(partBr);
            }
            IOUtils.closeQuietly((Reader)br);
        }
        catch (Exception ex) {
            LOG.warn("Got exception when reading containers stats", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(br);
        }
        return result;
    }

    private void processContainerPartFile(BufferedReader partBr, Long startTime, Long endTime, List<ContainerStatsInfo> result) throws IOException {
        String partLine;
        while ((partLine = partBr.readLine()) != null) {
            ContainerStatsInfo cs = new ContainerStatsInfo();
            int cursor = 0;
            int cursor2 = partLine.indexOf(58, cursor);
            cs.containerId = Integer.valueOf(partLine.substring(cursor, cursor2));
            cursor = cursor2 + 1;
            cursor2 = partLine.indexOf(58, cursor);
            cs.timestamp = Long.valueOf(partLine.substring(cursor, cursor2));
            cursor = cursor2 + 1;
            cs.stats = new ObjectMapperString(partLine.substring(cursor));
            if (startTime != null && cs.timestamp < startTime || endTime != null && cs.timestamp > endTime) continue;
            result.add(cs);
        }
    }

    public static class ContainerStatsInfo {
        public int containerId;
        @JsonSerialize(using=ToStringSerializer.class)
        public long timestamp;
        public ObjectMapperString stats;
    }

    public static class OperatorStatsInfo {
        public int operatorId;
        @JsonSerialize(using=ToStringSerializer.class)
        public long timestamp;
        public ObjectMapperString stats;
    }

    private static class StatsIndexLine
    extends FSPartFileAgent.IndexLine {
        @JsonSerialize(using=ToStringSerializer.class)
        public long startTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long endTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long count;

        private StatsIndexLine() {
        }
    }

    public static class OperatorsInfo {
        public String appId;
        public String operatorName;
        public List<Integer> operatorIds;
        @JsonSerialize(using=ToStringSerializer.class)
        public long startTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long endTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long count;
        public boolean ended;
    }

    public static class ContainersInfo {
        public String appId;
        public Map<Integer, ContainerInfo> containers;
        @JsonSerialize(using=ToStringSerializer.class)
        public long startTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long endTime;
        @JsonSerialize(using=ToStringSerializer.class)
        public long count;
        public boolean ended;
    }

    public static class ContainerInfo {
        public String id;
        public String jvmName;
        public String host;
        public int memoryMBAllocated;
    }
}

