/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.datatorrent.stram.client.FSAgent;
import com.datatorrent.stram.client.PermissionsInfo;
import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.client.WebServicesVersionConversion;
import com.datatorrent.stram.util.HeaderClientFilter;
import com.datatorrent.stram.util.LRUCache;
import com.datatorrent.stram.util.WebServicesClient;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramAgent
extends FSAgent {
    private static final int MAX_REDIRECTS = 5;
    private static final int STRAM_WEBSERVICE_RETRIES = 1;
    private static final Logger LOG = LoggerFactory.getLogger(StramAgent.class);
    protected String resourceManagerWebappAddress;
    private final Map<String, StramWebServicesInfo> webServicesInfoMap = new LRUCache<String, StramWebServicesInfo>(100, true);
    protected String defaultStramRoot = null;
    protected Configuration conf;

    public StramAgent(FileSystem fs, Configuration conf) {
        super(fs);
        this.conf = conf;
    }

    public void setDefaultStramRoot(String dir) {
        this.defaultStramRoot = dir;
    }

    private synchronized void deleteCachedWebServicesInfo(String appid) {
        this.webServicesInfoMap.remove(appid);
    }

    private synchronized void setCachedWebServicesInfo(String appid, StramWebServicesInfo info) {
        this.webServicesInfoMap.put(appid, info);
    }

    private synchronized StramWebServicesInfo getCachedWebServicesInfo(String appid) {
        return this.webServicesInfoMap.get(appid);
    }

    private StramWebServicesInfo getWebServicesInfo(String appid) {
        StramWebServicesInfo info = this.getCachedWebServicesInfo(appid);
        if ((info == null || this.checkSecExpiredToken(appid, info)) && (info = this.retrieveWebServicesInfo(appid)) != null) {
            this.setCachedWebServicesInfo(appid, info);
        }
        return info;
    }

    public String getWebServicesVersion(String appid) {
        StramWebServicesInfo info = this.getWebServicesInfo(appid);
        return info == null ? null : info.version;
    }

    public PermissionsInfo getPermissionsInfo(String appid) {
        StramWebServicesInfo info = this.getWebServicesInfo(appid);
        return info == null ? null : info.permissionsInfo;
    }

    private UriBuilder getStramWebURIBuilder(WebServicesClient webServicesClient, String appid) throws WebServicesVersionConversion.IncompatibleVersionException {
        webServicesClient.getClient().setFollowRedirects(Boolean.valueOf(true));
        webServicesClient.clearFilters();
        StramWebServicesInfo info = this.getWebServicesInfo(appid);
        UriBuilder ub = null;
        if (info != null) {
            String url = !info.appMasterTrackingUrl.startsWith("http://") && !info.appMasterTrackingUrl.startsWith("https://") ? "http://" + info.appMasterTrackingUrl : info.appMasterTrackingUrl;
            ub = UriBuilder.fromUri((String)url).path("/ws").path("v2").path("stram");
            WebServicesVersionConversion.Converter versionConverter = WebServicesVersionConversion.getConverter(info.version);
            if (versionConverter != null) {
                WebServicesVersionConversion.VersionConversionFilter versionConversionFilter = new WebServicesVersionConversion.VersionConversionFilter(versionConverter);
                webServicesClient.addFilter(versionConversionFilter);
            }
            if (info.securityInfo != null) {
                webServicesClient.addFilter(info.securityInfo.secClientFilter);
            }
        }
        return ub;
    }

    public void invalidateStramWebResource(String appid) {
        this.deleteCachedWebServicesInfo(appid);
    }

    public <T> T issueStramWebRequest(WebServicesClient webServiceClient, String appId, StramUriSpec stramUriSpec, Class<T> clazz, WebServicesClient.WebServicesHandler<T> handler) throws AppNotFoundException, IOException, WebServicesVersionConversion.IncompatibleVersionException {
        int retries = 1;
        while (true) {
            try {
                UriBuilder ub = this.getStramWebURIBuilder(webServiceClient, appId);
                if (ub == null) {
                    throw new AppNotFoundException(appId);
                }
                for (String path : stramUriSpec.getPaths()) {
                    ub = ub.path(path);
                }
                for (Map.Entry entry : stramUriSpec.getQueryParams().entries()) {
                    ub = ub.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                }
                return webServiceClient.process(webServiceClient.getClient().resource(ub.build(new Object[0])).accept(new String[]{"application/json"}), clazz, handler);
            }
            catch (ClientHandlerException ex) {
                if (retries-- > 0) {
                    this.invalidateStramWebResource(appId);
                    continue;
                }
                throw ex;
            }
            catch (IOException ex) {
                if (retries-- > 0) {
                    this.invalidateStramWebResource(appId);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public JSONObject issueStramWebRequest(WebServicesClient webServiceClient, String appId, StramUriSpec stramUriSpec, WebServicesClient.WebServicesHandler<JSONObject> handler) throws AppNotFoundException, IOException, WebServicesVersionConversion.IncompatibleVersionException {
        return this.issueStramWebRequest(webServiceClient, appId, stramUriSpec, JSONObject.class, handler);
    }

    public JSONObject issueStramWebGetRequest(WebServicesClient webServiceClient, String appId, String resourcePath) throws AppNotFoundException, IOException, WebServicesVersionConversion.IncompatibleVersionException {
        return this.issueStramWebRequest(webServiceClient, appId, new StramUriSpec().path(resourcePath), new WebServicesClient.GetWebServicesHandler<JSONObject>());
    }

    public String getAppsRoot() {
        return this.defaultStramRoot == null ? StramClientUtils.getDTDFSRootDir(this.fileSystem, this.conf) + "/" + "apps" : this.defaultStramRoot;
    }

    public String getAppPath(String appId) {
        StramWebServicesInfo info = this.getWebServicesInfo(appId);
        return info == null ? this.getAppsRoot() + "/" + appId : info.appPath;
    }

    public String getUser(String appid) {
        StramWebServicesInfo info = this.getWebServicesInfo(appid);
        return info == null ? null : info.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StramWebServicesInfo retrieveWebServicesInfo(String appId) {
        String url;
        String trackingUrl;
        YarnClient yarnClient = YarnClient.createYarnClient();
        try {
            yarnClient.init(this.conf);
            yarnClient.start();
            ApplicationReport ar = yarnClient.getApplicationReport(ConverterUtils.toApplicationId((String)appId));
            if (ar == null) {
                LOG.warn("YARN does not have record for this application {}", (Object)appId);
                StramWebServicesInfo stramWebServicesInfo = null;
                return stramWebServicesInfo;
            }
            if (ar.getYarnApplicationState() != YarnApplicationState.RUNNING) {
                LOG.debug("Application {} is not running (state: {})", (Object)appId, (Object)ar.getYarnApplicationState());
                StramWebServicesInfo stramWebServicesInfo = null;
                return stramWebServicesInfo;
            }
            trackingUrl = ar.getTrackingUrl();
            url = !trackingUrl.startsWith("http://") && !trackingUrl.startsWith("https://") ? "http://" + trackingUrl : trackingUrl;
            if (StringUtils.isBlank((CharSequence)url)) {
                LOG.error("Cannot get tracking url from YARN");
                StramWebServicesInfo stramWebServicesInfo = null;
                return stramWebServicesInfo;
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url + "/ws";
        }
        catch (Exception ex) {
            LOG.error("Cannot retrieve web services info", (Throwable)ex);
            trackingUrl = null;
            return trackingUrl;
        }
        finally {
            yarnClient.stop();
        }
        WebServicesClient webServicesClient = new WebServicesClient();
        try {
            JSONObject response;
            ClientResponse clientResponse;
            String secToken;
            block35: {
                secToken = null;
                int i = 0;
                do {
                    int index;
                    LOG.debug("Accessing url {}", (Object)url);
                    clientResponse = webServicesClient.process(url, ClientResponse.class, new WebServicesClient.GetWebServicesHandler());
                    String val = (String)clientResponse.getHeaders().getFirst((Object)"Refresh");
                    if (val == null || (index = val.indexOf("url=")) < 0) break block35;
                    url = val.substring(index + 4);
                } while (i++ <= 5);
                LOG.error("Cannot get web service info -- exceeded the max number of redirects");
                return null;
            }
            if (!UserGroupInformation.isSecurityEnabled()) {
                response = new JSONObject((String)clientResponse.getEntity(String.class));
            } else {
                if (UserGroupInformation.isSecurityEnabled()) {
                    for (NewCookie nc : clientResponse.getCookies()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cookie " + nc.getName() + " " + nc.getValue());
                        }
                        if (!nc.getName().equals("dt-client")) continue;
                        secToken = nc.getValue();
                    }
                }
                response = new JSONObject((String)clientResponse.getEntity(String.class));
            }
            String version = response.getString("version");
            response = webServicesClient.process(url + "/" + version + "/stram/info", JSONObject.class, new WebServicesClient.GetWebServicesHandler());
            String appMasterUrl = response.getString("appMasterTrackingUrl");
            String appPath = response.getString("appPath");
            String user = response.getString("user");
            JSONObject permissionsInfo = null;
            try (FSDataInputStream is = this.fileSystem.open(new Path(appPath, "permissions.json"));){
                permissionsInfo = new JSONObject(IOUtils.toString((InputStream)is));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return new StramWebServicesInfo(appMasterUrl, version, appPath, user, secToken, permissionsInfo);
        }
        catch (Exception ex) {
            LOG.warn("Cannot retrieve web service info for app {}", (Object)appId, (Object)ex);
            return null;
        }
    }

    private boolean checkSecExpiredToken(String appId, StramWebServicesInfo info) {
        boolean expired = false;
        if (info.securityInfo != null && info.securityInfo.isExpiredToken()) {
            this.invalidateStramWebResource(appId);
            expired = true;
        }
        return expired;
    }

    public static class StramUriSpec {
        private final List<String> paths = new ArrayList<String>();
        private final Multimap<String, Object> queryParams = HashMultimap.create();

        public StramUriSpec path(String elem) {
            this.paths.add(elem);
            return this;
        }

        public StramUriSpec queryParam(String name, Object ... values) {
            this.queryParams.putAll((Object)name, Arrays.asList(values));
            return this;
        }

        public StramUriSpec queryParam(Map<String, ? extends Object> map) {
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                this.queryParams.put((Object)entry.getKey(), entry.getValue());
            }
            return this;
        }

        List<String> getPaths() {
            return this.paths;
        }

        Multimap<String, Object> getQueryParams() {
            return this.queryParams;
        }
    }

    public static class AppNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String appId;

        public AppNotFoundException(String appId) {
            this.appId = appId;
        }

        @Override
        public String toString() {
            return "App id " + this.appId + " is not found";
        }
    }

    private static class SecurityInfo {
        public static final long DEFAULT_EXPIRY_INTERVAL = 3600000L;
        HeaderClientFilter secClientFilter;
        long expiryInterval = 3600000L;
        long issueTime = System.currentTimeMillis();

        SecurityInfo(String secToken) {
            this.secClientFilter = new HeaderClientFilter();
            this.secClientFilter.addCookie(new Cookie("dt-client", secToken));
        }

        boolean isExpiredToken() {
            return System.currentTimeMillis() - this.issueTime >= this.expiryInterval;
        }
    }

    private static class StramWebServicesInfo {
        String appMasterTrackingUrl;
        String version;
        String appPath;
        String user;
        SecurityInfo securityInfo;
        PermissionsInfo permissionsInfo;

        StramWebServicesInfo(String appMasterTrackingUrl, String version, String appPath, String user, String secToken, JSONObject permissionsInfo) {
            this.appMasterTrackingUrl = appMasterTrackingUrl;
            this.version = version;
            this.appPath = appPath;
            this.user = user;
            if (secToken != null) {
                this.securityInfo = new SecurityInfo(secToken);
            }
            try {
                this.permissionsInfo = permissionsInfo != null ? new PermissionsInfo(permissionsInfo) : null;
            }
            catch (JSONException ex) {
                LOG.error("Caught exception when processing permissions info", (Throwable)ex);
            }
        }
    }
}

