/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServicesVersionConversion {
    private static final Logger LOG = LoggerFactory.getLogger(WebServicesVersionConversion.class);

    public static boolean isVersionCompatible(String version) {
        int thisVersion;
        if (!version.startsWith("v")) {
            LOG.error("Version {} is invalid", (Object)version);
            return false;
        }
        int majorVersion = Integer.valueOf((version = version.substring(1)).split("\\.")[0]);
        if (majorVersion > (thisVersion = Integer.valueOf("v2".substring(1).split("\\.")[0]).intValue())) {
            LOG.warn("Future stram version {} is incompatible. Please upgrade the DataTorrent Gateway and/or CLI", (Object)majorVersion);
            return false;
        }
        return true;
    }

    public static Converter getConverter(String version) throws IncompatibleVersionException {
        if (!WebServicesVersionConversion.isVersionCompatible(version)) {
            throw new IncompatibleVersionException("Stram version " + version + " is incompatible with the current build (" + "v2" + ")");
        }
        if (version.equals("v1")) {
            return new Converter(){

                @Override
                public String convertCommandPath(String path) {
                    return path.replaceFirst("/ws/v2/", "/ws/v1/");
                }

                @Override
                public String convertResponse(String path, String response) {
                    return response;
                }
            };
        }
        return null;
    }

    public static class VersionConversionFilter
    extends ClientFilter {
        private final Converter converter;

        public VersionConversionFilter(Converter converter) {
            this.converter = converter;
        }

        public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
            URIBuilder uriBuilder = new URIBuilder(cr.getURI());
            String path = uriBuilder.getPath();
            uriBuilder.setPath(this.converter.convertCommandPath(path));
            try {
                cr.setURI(uriBuilder.build());
                ClientResponse response = this.getNext().handle(cr);
                String newEntity = this.converter.convertResponse(path, (String)response.getEntity(String.class));
                response.setEntityInputStream((InputStream)new ByteArrayInputStream(newEntity.getBytes()));
                return response;
            }
            catch (Exception ex) {
                throw new ClientHandlerException((Throwable)ex);
            }
        }
    }

    public static class IncompatibleVersionException
    extends Exception {
        IncompatibleVersionException(String message) {
            super(message);
        }
    }

    public static interface Converter {
        public String convertCommandPath(String var1);

        public String convertResponse(String var1, String var2);
    }
}

