/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.codec;

import com.datatorrent.netlet.util.Slice;
import com.datatorrent.stram.codec.StatefulStreamCodec;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatefulStreamCodec<T>
extends Kryo
implements StatefulStreamCodec<T> {
    private final Output data = new Output(4096, Integer.MAX_VALUE);
    private final Output state = new Output(4096, Integer.MAX_VALUE);
    private final Input input = new Input();
    final ClassResolver classResolver;
    final ArrayList<ClassIdPair> pairs;
    private static final Logger logger = LoggerFactory.getLogger(DefaultStatefulStreamCodec.class);

    public DefaultStatefulStreamCodec() {
        super((com.esotericsoftware.kryo.ClassResolver)new ClassResolver(), (ReferenceResolver)new MapReferenceResolver());
        this.register(Class.class);
        this.register(ClassIdPair.class);
        this.classResolver = (ClassResolver)this.getClassResolver();
        this.pairs = this.classResolver.pairs;
        this.classResolver.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fromDataStatePair(StatefulStreamCodec.DataStatePair dspair) {
        DefaultStatefulStreamCodec defaultStatefulStreamCodec;
        if (dspair.state != null) {
            try {
                this.input.setBuffer(dspair.state.buffer, dspair.state.offset, dspair.state.length);
                while (this.input.position() < this.input.limit()) {
                    ClassIdPair pair = (ClassIdPair)this.readClassAndObject(this.input);
                    this.classResolver.registerExplicit(pair);
                }
            }
            catch (Throwable th) {
                logger.error("Catastrophic Error: Execution halted due to Kryo exception!", th);
                defaultStatefulStreamCodec = this;
                synchronized (defaultStatefulStreamCodec) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException("Serialization State Error Halt Interrupted", ex);
                    }
                }
            }
            finally {
                dspair.state = null;
            }
        }
        this.input.setBuffer(dspair.data.buffer, dspair.data.offset, dspair.data.length);
        try {
            return this.readClassAndObject(this.input);
        }
        catch (Throwable th) {
            logger.error("Catastrophic Error: Execution halted due to Kryo exception!", th);
            defaultStatefulStreamCodec = this;
            synchronized (defaultStatefulStreamCodec) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException("Serialization Data Error Halt Interrupted", ex);
                }
            }
            return null;
        }
    }

    @Override
    public StatefulStreamCodec.DataStatePair toDataStatePair(T o) {
        byte[] bytes;
        StatefulStreamCodec.DataStatePair pair = new StatefulStreamCodec.DataStatePair();
        this.data.setPosition(0);
        this.writeClassAndObject(this.data, o);
        if (!this.pairs.isEmpty()) {
            this.state.setPosition(0);
            for (ClassIdPair cip : this.pairs) {
                this.writeClassAndObject(this.state, cip);
            }
            this.pairs.clear();
            bytes = this.state.toBytes();
            pair.state = new Slice(bytes, 0, bytes.length);
        }
        bytes = this.data.toBytes();
        pair.data = new Slice(bytes, 0, bytes.length);
        return pair;
    }

    public int getPartition(T o) {
        return o.hashCode();
    }

    @Override
    public void resetState() {
        this.classResolver.unregisterImplicitlyRegisteredTypes();
    }

    public Object fromByteArray(Slice fragment) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Slice toByteArray(T o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DefaultStatefulStreamCodec<T> newInstance() {
        try {
            return (DefaultStatefulStreamCodec)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to create new stateful streamcodec object", e);
        }
    }

    public static class ClassResolver
    extends DefaultClassResolver {
        int firstAvailableRegistrationId;
        int nextAvailableRegistrationId;
        final ArrayList<ClassIdPair> pairs = new ArrayList();

        public void unregister(int classId) {
            Registration registration = (Registration)this.idToRegistration.remove(classId);
            this.classToRegistration.remove((Object)registration.getType());
            this.getRegistration(Integer.TYPE);
        }

        public Registration registerImplicit(Class type) {
            while (this.getRegistration(this.nextAvailableRegistrationId) != null) {
                ++this.nextAvailableRegistrationId;
            }
            this.pairs.add(new ClassIdPair(this.nextAvailableRegistrationId, type.getName()));
            return this.register(new Registration(type, this.kryo.getDefaultSerializer(type), this.nextAvailableRegistrationId++));
        }

        public void registerExplicit(ClassIdPair pair) throws ClassNotFoundException {
            Class<?> type = Class.forName(pair.classname, false, Thread.currentThread().getContextClassLoader());
            this.register(new Registration(type, this.kryo.getDefaultSerializer(type), pair.id));
            if (this.nextAvailableRegistrationId <= pair.id) {
                this.nextAvailableRegistrationId = pair.id + 1;
            }
        }

        public void init() {
            this.nextAvailableRegistrationId = this.firstAvailableRegistrationId = this.kryo.getNextRegistrationId();
        }

        public void unregisterImplicitlyRegisteredTypes() {
            while (this.nextAvailableRegistrationId > this.firstAvailableRegistrationId) {
                this.unregister(--this.nextAvailableRegistrationId);
            }
        }
    }

    static class ClassIdPair {
        final int id;
        final String classname;

        ClassIdPair() {
            this.id = 0;
            this.classname = null;
        }

        ClassIdPair(int id, String classname) {
            this.id = id;
            this.classname = classname;
        }
    }
}

