/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.debug;

import com.datatorrent.api.Sink;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuxSink
implements Sink<Object> {
    Sink<Object>[] sinks;
    private int count;
    private static final Logger logger = LoggerFactory.getLogger(MuxSink.class);

    public MuxSink(Sink<Object> ... s) {
        this.sinks = s;
    }

    public MuxSink() {
        this.sinks = (Sink[])Array.newInstance(Sink.class, 0);
    }

    public void put(Object tuple) {
        ++this.count;
        int i = this.sinks.length;
        while (i-- > 0) {
            this.sinks[i].put(tuple);
        }
    }

    public void add(Sink<Object> ... s) {
        int i = this.sinks.length;
        this.sinks = Arrays.copyOf(this.sinks, i + s.length);
        for (Sink<Object> ss : s) {
            this.sinks[i++] = ss;
        }
    }

    public void remove(Sink<Object> s) {
        boolean found = false;
        int i = this.sinks.length;
        while (i-- > 0) {
            if (this.sinks[i] != s) continue;
            this.sinks[i] = null;
            found = true;
        }
        if (found) {
            Sink[] newInstance = (Sink[])Array.newInstance(Sink.class, this.sinks.length - 1);
            int i2 = 0;
            int j = this.sinks.length;
            while (j-- > 0) {
                if (this.sinks[j] == null) continue;
                newInstance[i2++] = this.sinks[j];
            }
            this.sinks = newInstance;
        }
    }

    public void remove(Sink<Object> ... s) {
        int found = 0;
        int i = s.length;
        block0: while (i-- > 0) {
            int j = this.sinks.length;
            while (j-- > 0) {
                if (s[i] != this.sinks[j]) continue;
                this.sinks[j] = null;
                ++found;
                continue block0;
            }
        }
        Sink[] newInstance = (Sink[])Array.newInstance(Sink.class, this.sinks.length - found);
        int i2 = 0;
        int j = this.sinks.length;
        while (j-- > 0) {
            if (this.sinks[j] == null) continue;
            newInstance[i2++] = this.sinks[j];
        }
        this.sinks = newInstance;
    }

    public Sink<Object>[] getSinks() {
        return Arrays.copyOf(this.sinks, this.sinks.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(boolean reset) {
        try {
            int n = this.count;
            return n;
        }
        finally {
            if (reset) {
                this.count = 0;
            }
        }
    }
}

