/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.engine;

import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Sink;
import com.datatorrent.api.Stats;
import com.datatorrent.stram.engine.Node;
import com.datatorrent.stram.engine.OperatorContext;
import com.datatorrent.stram.engine.SweepableReservoir;
import com.datatorrent.stram.tuple.Tuple;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputNode
extends Node<InputOperator> {
    private final ArrayList<SweepableReservoir> deferredInputConnections = new ArrayList();
    protected SweepableReservoir controlTuples;
    long lastCheckpointWindowId = -1L;
    private static final Logger logger = LoggerFactory.getLogger(InputNode.class);

    public InputNode(InputOperator operator, OperatorContext context) {
        super(operator, context);
    }

    @Override
    public void connectInputPort(String port, SweepableReservoir reservoir) {
        if ("input".equals(port)) {
            if (this.controlTuples == null) {
                this.controlTuples = reservoir;
            } else {
                this.deferredInputConnections.add(reservoir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        long maxSpinMillis = ((Integer)this.context.getValue(OperatorContext.SPIN_MILLIS)).intValue();
        long spinMillis = 0L;
        boolean handleIdleTime = this.operator instanceof Operator.IdleTimeHandler;
        boolean insideApplicationWindow = this.applicationWindowCount != 0;
        boolean doCheckpoint = false;
        boolean insideStreamingWindow = false;
        this.calculateNextCheckpointWindow();
        try {
            block11: while (this.alive) {
                Tuple t = this.controlTuples.sweep();
                if (t == null) {
                    if (insideStreamingWindow) {
                        int i$;
                        Sink cs;
                        int generatedTuples = 0;
                        Sink[] arr$ = this.sinks;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; generatedTuples -= cs.getCount(false), ++i$) {
                            cs = arr$[i$];
                        }
                        ((InputOperator)this.operator).emitTuples();
                        arr$ = this.sinks;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$; generatedTuples += cs.getCount(false), ++i$) {
                            cs = arr$[i$];
                        }
                        if (generatedTuples == 0) {
                            if (handleIdleTime) {
                                ((Operator.IdleTimeHandler)this.operator).handleIdleTime();
                                continue;
                            }
                            Thread.sleep(spinMillis);
                            spinMillis = Math.min(spinMillis + 1L, maxSpinMillis);
                            continue;
                        }
                        spinMillis = 0L;
                        continue;
                    }
                    Thread.sleep(0L);
                    continue;
                }
                this.controlTuples.remove();
                switch (t.getType()) {
                    case BEGIN_WINDOW: {
                        int i = this.sinks.length;
                        while (i-- > 0) {
                            this.sinks[i].put((Object)t);
                        }
                        ++this.controlTupleCount;
                        this.currentWindowId = t.getWindowId();
                        insideStreamingWindow = true;
                        if (this.applicationWindowCount == 0) {
                            insideApplicationWindow = true;
                            ((InputOperator)this.operator).beginWindow(this.currentWindowId);
                        }
                        ((InputOperator)this.operator).emitTuples();
                        continue block11;
                    }
                    case END_WINDOW: {
                        insideStreamingWindow = false;
                        if (++this.applicationWindowCount == this.APPLICATION_WINDOW_COUNT) {
                            insideApplicationWindow = false;
                            ((InputOperator)this.operator).endWindow();
                            this.applicationWindowCount = 0;
                        }
                        this.endWindowEmitTime = System.currentTimeMillis();
                        int i = this.sinks.length;
                        while (i-- > 0) {
                            this.sinks[i].put((Object)t);
                        }
                        ++this.controlTupleCount;
                        if (doCheckpoint) {
                            this.dagCheckpointOffsetCount = (this.dagCheckpointOffsetCount + 1) % this.DAG_CHECKPOINT_WINDOW_COUNT;
                        }
                        if (++this.checkpointWindowCount == this.CHECKPOINT_WINDOW_COUNT) {
                            this.checkpointWindowCount = 0;
                            if (doCheckpoint) {
                                this.checkpoint(this.currentWindowId);
                                this.lastCheckpointWindowId = this.currentWindowId;
                                doCheckpoint = false;
                            } else if (this.PROCESSING_MODE == Operator.ProcessingMode.EXACTLY_ONCE) {
                                this.checkpoint(this.currentWindowId);
                                this.lastCheckpointWindowId = this.currentWindowId;
                            }
                        }
                        Stats.OperatorStats stats = new Stats.OperatorStats();
                        this.reportStats(stats, this.currentWindowId);
                        if (!insideApplicationWindow) {
                            stats.metrics = this.collectMetrics();
                        }
                        this.handleRequests(this.currentWindowId);
                        continue block11;
                    }
                    case CHECKPOINT: {
                        this.dagCheckpointOffsetCount = 0;
                        if (this.lastCheckpointWindowId < this.currentWindowId) {
                            if (this.checkpointWindowCount == 0 && this.PROCESSING_MODE != Operator.ProcessingMode.EXACTLY_ONCE) {
                                this.checkpoint(this.currentWindowId);
                                this.lastCheckpointWindowId = this.currentWindowId;
                            } else {
                                doCheckpoint = true;
                            }
                        }
                        int i = this.sinks.length;
                        while (i-- > 0) {
                            this.sinks[i].put((Object)t);
                        }
                        ++this.controlTupleCount;
                        continue block11;
                    }
                    case END_STREAM: {
                        if (this.deferredInputConnections.isEmpty()) {
                            int i = this.sinks.length;
                            while (i-- > 0) {
                                this.sinks[i].put((Object)t);
                            }
                            ++this.controlTupleCount;
                            this.alive = false;
                            continue block11;
                        }
                        this.controlTuples = this.deferredInputConnections.remove(0);
                        continue block11;
                    }
                }
                int i = this.sinks.length;
                while (i-- > 0) {
                    this.sinks[i].put((Object)t);
                }
                ++this.controlTupleCount;
            }
        }
        catch (Operator.ShutdownException se) {
            logger.debug("Shutdown requested by the operator when alive = {}.", (Object)this.alive);
            this.alive = false;
        }
        catch (Throwable cause) {
            Throwable rootCause;
            InputNode stats = this;
            synchronized (stats) {
                if (this.alive) {
                    throw Throwables.propagate((Throwable)cause);
                }
            }
            for (rootCause = cause; rootCause != null && !(rootCause instanceof InterruptedException); rootCause = rootCause.getCause()) {
            }
            if (rootCause == null) {
                throw Throwables.propagate((Throwable)cause);
            }
            logger.debug("Ignoring InterruptedException after shutdown", cause);
        }
        if (insideApplicationWindow) {
            ((InputOperator)this.operator).endWindow();
            this.endWindowEmitTime = System.currentTimeMillis();
            if (++this.applicationWindowCount == this.APPLICATION_WINDOW_COUNT) {
                this.applicationWindowCount = 0;
            }
            if (this.lastCheckpointWindowId < this.currentWindowId && ++this.checkpointWindowCount == this.CHECKPOINT_WINDOW_COUNT) {
                this.checkpointWindowCount = 0;
                if (doCheckpoint || this.PROCESSING_MODE == Operator.ProcessingMode.EXACTLY_ONCE) {
                    this.checkpoint(this.currentWindowId);
                    this.lastCheckpointWindowId = this.currentWindowId;
                }
            }
            Stats.OperatorStats stats = new Stats.OperatorStats();
            this.reportStats(stats, this.currentWindowId);
            stats.metrics = this.collectMetrics();
            this.handleRequests(this.currentWindowId);
        }
    }
}

