/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.engine;

import com.datatorrent.api.Sink;
import com.datatorrent.netlet.util.CircularBuffer;
import com.datatorrent.stram.engine.SweepableReservoir;
import com.datatorrent.stram.tuple.Tuple;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MuxReservoir {
    private volatile SubReservoir[] reservoirs = new SubReservoir[0];
    private HashMap<String, SubReservoir> reservoirMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(MuxReservoir.class);

    public SweepableReservoir acquireReservoir(String id, int capacity) {
        SubReservoir r = this.reservoirMap.get(id);
        if (r == null) {
            r = new SubReservoir(capacity);
            this.reservoirMap.put(id, r);
            SubReservoir[] newReservoirs = new SubReservoir[this.reservoirs.length + 1];
            newReservoirs[this.reservoirs.length] = r;
            int i = this.reservoirs.length;
            while (i-- > 0) {
                newReservoirs[i] = this.reservoirs[i];
            }
            this.reservoirs = newReservoirs;
        }
        return r;
    }

    public SweepableReservoir releaseReservoir(String id) {
        SubReservoir r = this.reservoirMap.remove(id);
        if (r != null) {
            SubReservoir[] newReservoirs = new SubReservoir[this.reservoirs.length - 1];
            int j = 0;
            for (int i = 0; i < this.reservoirs.length; ++i) {
                if (this.reservoirs[i] == r) continue;
                newReservoirs[j++] = this.reservoirs[i];
            }
            this.reservoirs = newReservoirs;
        }
        return r;
    }

    protected abstract Queue getQueue();

    class SubReservoir
    extends CircularBuffer<Object>
    implements SweepableReservoir {
        int count;
        private Sink<Object> sink;

        SubReservoir(int capacity) {
            super(capacity);
        }

        @Override
        public int size(boolean dataTupleAware) {
            int size = this.size();
            if (dataTupleAware) {
                Iterator iterator = this.getFrozenIterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof Tuple)) continue;
                    --size;
                }
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Sink<Object> setSink(Sink<Object> sink) {
            try {
                Sink<Object> sink2 = this.sink;
                return sink2;
            }
            finally {
                this.sink = sink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tuple sweep() {
            Queue queue;
            int size = this.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    if (this.peekUnsafe() instanceof Tuple) {
                        this.count += i;
                        return (Tuple)this.peekUnsafe();
                    }
                    this.sink.put(this.pollUnsafe());
                }
                this.count += size;
            }
            Queue queue2 = queue = MuxReservoir.this.getQueue();
            synchronized (queue2) {
                Object o;
                if (queue.isEmpty()) {
                    return null;
                }
                int min = Integer.MAX_VALUE;
                int i = MuxReservoir.this.reservoirs.length;
                while (i-- > 0) {
                    if (MuxReservoir.this.reservoirs[i].remainingCapacity() >= min) continue;
                    min = MuxReservoir.this.reservoirs[i].remainingCapacity();
                }
                while (min-- > 0 && (o = queue.poll()) != null) {
                    int i2 = MuxReservoir.this.reservoirs.length;
                    while (i2-- > 0) {
                        MuxReservoir.this.reservoirs[i2].add(o);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCount(boolean reset) {
            try {
                int n = this.count;
                return n;
            }
            finally {
                if (reset) {
                    this.count = 0;
                }
            }
        }
    }
}

