/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.engine;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.Stats;
import com.datatorrent.api.StatsListener;
import com.datatorrent.netlet.util.CircularBuffer;
import com.datatorrent.stram.api.BaseContext;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorContext
extends BaseContext
implements Context.OperatorContext {
    private Thread thread;
    private long lastProcessedWindowId = -1L;
    private final int id;
    private final String name;
    private final CircularBuffer<Stats.OperatorStats> statsBuffer = new CircularBuffer(1024);
    private final CircularBuffer<StatsListener.OperatorRequest> requests = new CircularBuffer(1024);
    public final boolean stateless;
    private int windowsFromCheckpoint;
    private long idleTimeout = 1000L;
    private static final long serialVersionUID = 2013060671427L;
    private static final Logger logger = LoggerFactory.getLogger(Context.OperatorContext.class);

    public BlockingQueue<StatsListener.OperatorRequest> getRequests() {
        return this.requests;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public OperatorContext(int id, @NotNull String name, Attribute.AttributeMap attributes, Context parentContext) {
        super(attributes, parentContext);
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"operator name");
        this.stateless = (Boolean)super.getValue(Context.OperatorContext.STATELESS);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getWindowsFromCheckpoint() {
        return this.windowsFromCheckpoint;
    }

    public void setWindowsFromCheckpoint(int windowsFromCheckpoint) {
        this.windowsFromCheckpoint = windowsFromCheckpoint;
    }

    public final synchronized int drainStats(Collection<? super Stats.OperatorStats> stats) {
        return this.statsBuffer.drainTo(stats);
    }

    public final synchronized long getLastProcessedWindowId() {
        return this.lastProcessedWindowId;
    }

    public void report(Stats.OperatorStats stats, long windowId) {
        this.lastProcessedWindowId = windowId;
        stats.windowId = windowId;
        stats.counters = this.counters;
        this.counters = null;
        if (!this.statsBuffer.offer((Object)stats)) {
            this.statsBuffer.poll();
            this.statsBuffer.offer((Object)stats);
        }
    }

    public void request(StatsListener.OperatorRequest request) {
        this.requests.add((Object)request);
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }
}

