/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.engine;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.StreamCodec;
import com.datatorrent.netlet.EventLoop;
import com.datatorrent.stram.codec.DefaultStatefulStreamCodec;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamContext
extends Attribute.AttributeMap.DefaultAttributeMap
implements Context {
    public static final Attribute<InetSocketAddress> BUFFER_SERVER_ADDRESS = new Attribute(null, null);
    public static final Attribute<byte[]> BUFFER_SERVER_TOKEN = new Attribute(null, null);
    public static final Attribute<EventLoop> EVENT_LOOP = new Attribute(null, null);
    public static final Attribute<StreamCodec<?>> CODEC = new Attribute(new DefaultStatefulStreamCodec(), null);
    private String sourceId;
    private String sinkId;
    private long finishedWindowId;
    private int mask;
    private Set<Integer> partitions;
    private String id;
    private String portId;
    private static final long serialVersionUID = 201212042146L;
    private static final Logger logger;

    public Attribute.AttributeMap getAttributes() {
        return this;
    }

    public <T> T getValue(Attribute<T> key) {
        Object retvalue = this.get(key);
        if (retvalue == null) {
            return (T)key.defaultValue;
        }
        return (T)retvalue;
    }

    public InetSocketAddress getBufferServerAddress() {
        InetSocketAddress isa = (InetSocketAddress)this.get(BUFFER_SERVER_ADDRESS);
        return new InetSocketAddress(isa.getHostName(), isa.getPort());
    }

    public void setBufferServerAddress(InetSocketAddress isa) {
        this.put(BUFFER_SERVER_ADDRESS, isa);
    }

    public void setCounters(Object counters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void sendMetrics(Collection<String> metricNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPartitions(int mask, Set<Integer> partitionKeys) {
        this.mask = mask;
        this.partitions = partitionKeys == null ? null : Collections.unmodifiableSet(partitionKeys);
    }

    public int getPartitionMask() {
        return this.mask;
    }

    public Collection<Integer> getPartitions() {
        return this.partitions;
    }

    public StreamContext(String id) {
        this.id = id;
    }

    public long getFinishedWindowId() {
        return this.finishedWindowId;
    }

    public void setFinishedWindowId(long startingWindowId) {
        this.finishedWindowId = startingWindowId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String upstreamNodeId) {
        this.sourceId = upstreamNodeId;
    }

    public String getSinkId() {
        return this.sinkId;
    }

    public void setSinkId(String downstreamNodeId) {
        this.sinkId = downstreamNodeId;
    }

    public String getPortId() {
        return this.portId;
    }

    public void setPortId(String portId) {
        this.portId = portId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("sourceId", (Object)this.sourceId).append("sinkId", (Object)this.sinkId).toString();
    }

    static {
        Attribute.AttributeMap.AttributeInitializer.initialize(StreamContext.class);
        logger = LoggerFactory.getLogger(StreamContext.class);
    }

    public static enum State {
        UNDEFINED,
        OUTSIDE_WINDOW,
        INSIDE_WINDOW,
        TERMINATED;

    }
}

