/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.logical;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.NotNull;

public final class MetricAggregatorMeta
implements Serializable {
    private final AutoMetric.Aggregator aggregator;
    private final AutoMetric.DimensionsScheme dimensionsScheme;
    private static final long serialVersionUID = 201604271719L;

    protected MetricAggregatorMeta(AutoMetric.Aggregator aggregator, AutoMetric.DimensionsScheme dimensionsScheme) {
        this.aggregator = aggregator;
        this.dimensionsScheme = dimensionsScheme;
    }

    public AutoMetric.Aggregator getAggregator() {
        return this.aggregator;
    }

    public String[] getDimensionAggregatorsFor(String logicalMetricName) {
        if (this.dimensionsScheme == null) {
            return null;
        }
        return this.dimensionsScheme.getDimensionAggregationsFor(logicalMetricName);
    }

    public String[] getTimeBuckets() {
        if (this.dimensionsScheme == null) {
            return null;
        }
        return this.dimensionsScheme.getTimeBuckets();
    }

    static final class MetricsAggregatorProxy
    implements AutoMetric.Aggregator,
    Serializable {
        private final LogicalPlan.OperatorMeta om;
        private static final long serialVersionUID = 201512221830L;

        MetricsAggregatorProxy(@NotNull LogicalPlan.OperatorMeta om) {
            this.om = (LogicalPlan.OperatorMeta)Preconditions.checkNotNull((Object)om);
        }

        public Map<String, Object> aggregate(long windowId, Collection<AutoMetric.PhysicalMetricsContext> physicalMetrics) {
            return ((AutoMetric.Aggregator)this.om.getOperator()).aggregate(windowId, physicalMetrics);
        }
    }
}

