/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.logical;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.common.experimental.AppData;
import com.datatorrent.stram.ComponentContextPair;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;

public abstract class Operators {
    public static void describe(DAG.GenericOperator operator, OperatorDescriptor descriptor) {
        for (Class<?> c = operator.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                field.setAccessible(true);
                InputPortFieldAnnotation inputAnnotation = field.getAnnotation(InputPortFieldAnnotation.class);
                OutputPortFieldAnnotation outputAnnotation = field.getAnnotation(OutputPortFieldAnnotation.class);
                AppData.QueryPort adqAnnotation = field.getAnnotation(AppData.QueryPort.class);
                AppData.ResultPort adrAnnotation = field.getAnnotation(AppData.ResultPort.class);
                try {
                    Object portObject = field.get(operator);
                    if (portObject instanceof Operator.InputPort) {
                        descriptor.addInputPort((Operator.InputPort)portObject, field, inputAnnotation, adqAnnotation);
                    } else if (inputAnnotation != null) {
                        throw new IllegalArgumentException("port is not of type " + Operator.InputPort.class.getName() + ": " + field);
                    }
                    if (portObject instanceof Operator.OutputPort) {
                        descriptor.addOutputPort((Operator.OutputPort)portObject, field, outputAnnotation, adrAnnotation);
                        continue;
                    }
                    if (outputAnnotation == null) continue;
                    throw new IllegalArgumentException("port is not of type " + Operator.OutputPort.class.getName() + ": " + field);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class PortMappingDescriptor
    implements OperatorDescriptor {
        public final LinkedHashMap<String, PortContextPair<Operator.InputPort<?>>> inputPorts = new LinkedHashMap();
        public final LinkedHashMap<String, PortContextPair<Operator.OutputPort<?>>> outputPorts = new LinkedHashMap();

        @Override
        public void addInputPort(Operator.InputPort<?> port, Field field, InputPortFieldAnnotation portAnnotation, AppData.QueryPort adqAnnotation) {
            if (!this.inputPorts.containsKey(field.getName())) {
                this.inputPorts.put(field.getName(), new PortContextPair(port));
            }
        }

        @Override
        public void addOutputPort(Operator.OutputPort<?> port, Field field, OutputPortFieldAnnotation portAnnotation, AppData.ResultPort adrAnnotation) {
            if (!this.outputPorts.containsKey(field.getName())) {
                this.outputPorts.put(field.getName(), new PortContextPair(port));
            }
        }
    }

    public static class PortContextPair<PORT extends Operator.Port>
    extends ComponentContextPair<PORT, Context.PortContext> {
        public PortContextPair(PORT port, Context.PortContext context) {
            super(port, context);
        }

        public PortContextPair(PORT port) {
            super(port, null);
        }
    }

    public static interface OperatorDescriptor {
        public void addInputPort(Operator.InputPort<?> var1, Field var2, InputPortFieldAnnotation var3, AppData.QueryPort var4);

        public void addOutputPort(Operator.OutputPort<?> var1, Field var2, OutputPortFieldAnnotation var3, AppData.ResultPort var4);
    }
}

