/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.logical;

import com.datatorrent.api.Partitioner;
import com.datatorrent.api.StreamCodec;
import com.datatorrent.netlet.util.Slice;
import com.datatorrent.stram.plan.logical.DefaultKryoStreamCodec;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StreamCodecWrapperForPersistance<T>
implements StreamCodec<T>,
Serializable {
    private StreamCodec<Object> specifiedStreamCodec;
    public Map<LogicalPlan.InputPortMeta, Collection<Partitioner.PartitionKeys>> inputPortToPartitionMap;
    public Map<LogicalPlan.InputPortMeta, StreamCodec<Object>> codecsToMerge;
    private boolean operatorPartitioned;

    public StreamCodecWrapperForPersistance(Map<LogicalPlan.InputPortMeta, StreamCodec<Object>> inputStreamCodecs, StreamCodec<Object> specifiedStreamCodec) {
        this.codecsToMerge = inputStreamCodecs;
        this.setSpecifiedStreamCodec(specifiedStreamCodec);
        this.inputPortToPartitionMap = new HashMap<LogicalPlan.InputPortMeta, Collection<Partitioner.PartitionKeys>>();
    }

    public Object fromByteArray(Slice fragment) {
        return this.getSpecifiedStreamCodec().fromByteArray(fragment);
    }

    public Slice toByteArray(T o) {
        return this.getSpecifiedStreamCodec().toByteArray(o);
    }

    public int getPartition(T o) {
        return this.getSpecifiedStreamCodec().getPartition(o);
    }

    public boolean shouldCaptureEvent(T o) {
        for (Map.Entry<LogicalPlan.InputPortMeta, Collection<Partitioner.PartitionKeys>> entry : this.inputPortToPartitionMap.entrySet()) {
            StreamCodec<Object> codec = this.codecsToMerge.get(entry.getKey());
            Collection<Partitioner.PartitionKeys> partitionKeysList = entry.getValue();
            for (Partitioner.PartitionKeys keys : partitionKeysList) {
                if (keys.partitions == null || !keys.partitions.contains(keys.mask & codec.getPartition(o))) continue;
                return true;
            }
        }
        return false;
    }

    public StreamCodec<Object> getSpecifiedStreamCodec() {
        if (this.specifiedStreamCodec == null) {
            this.specifiedStreamCodec = new DefaultKryoStreamCodec<Object>();
        }
        return this.specifiedStreamCodec;
    }

    public void setSpecifiedStreamCodec(StreamCodec<Object> specifiedStreamCodec) {
        this.specifiedStreamCodec = specifiedStreamCodec;
    }

    public boolean isOperatorPartitioned() {
        return this.operatorPartitioned;
    }

    public void setOperatorPartitioned(boolean operatorPartitioned) {
        this.operatorPartitioned = operatorPartitioned;
    }
}

