/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.plan.physical;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.stram.StringCodecs;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import com.datatorrent.stram.plan.logical.LogicalPlanConfiguration;
import com.datatorrent.stram.plan.logical.Operators;
import com.datatorrent.stram.plan.physical.PTOperator;
import com.datatorrent.stram.plan.physical.PhysicalPlan;
import java.util.Collections;
import java.util.Map;
import javax.validation.ValidationException;

public class PlanModifier {
    private final LogicalPlan logicalPlan;
    private final PhysicalPlan physicalPlan;

    public PlanModifier(LogicalPlan logicalPlan) {
        this.logicalPlan = logicalPlan;
        this.physicalPlan = null;
        this.init();
    }

    public PlanModifier(PhysicalPlan plan) {
        this.physicalPlan = plan;
        this.logicalPlan = plan.getLogicalPlan();
        this.init();
    }

    private void init() {
        Map codecs = (Map)this.logicalPlan.getAttributes().get(Context.DAGContext.STRING_CODECS);
        if (codecs != null) {
            StringCodecs.loadConverters(codecs);
        }
    }

    public LogicalPlan.StreamMeta addSinks(String id, Operator.InputPort<?> ... sinks) {
        LogicalPlan.StreamMeta sm = this.logicalPlan.getStream(id);
        if (sm == null) {
            throw new AssertionError((Object)("Stream " + id + " is not found!"));
        }
        for (Operator.InputPort<?> sink : sinks) {
            sm.addSink((Operator.InputPort)sink);
            if (this.physicalPlan == null) continue;
            for (LogicalPlan.InputPortMeta ipm : sm.getSinks()) {
                if (ipm.getPortObject() != sink) continue;
                this.physicalPlan.connectInput(ipm);
            }
        }
        return sm;
    }

    public <T> LogicalPlan.StreamMeta addStream(String id, Operator.OutputPort<? extends T> source, Operator.InputPort<?> ... sinks) {
        LogicalPlan.StreamMeta sm = this.logicalPlan.getStream(id);
        if (sm != null) {
            if (sm.getSource().getOperatorMeta().getMeta((Operator.OutputPort)source) != sm.getSource()) {
                throw new AssertionError((Object)String.format("Stream %s already connected to %s", sm, sm.getSource()));
            }
        } else {
            DAG.StreamMeta newStream = this.logicalPlan.addStream(id, (Operator.OutputPort)source, new Operator.InputPort[0]);
            sm = newStream;
        }
        return this.addSinks(id, sinks);
    }

    public void addStream(String streamName, String sourceOperName, String sourcePortName, String targetOperName, String targetPortName) {
        LogicalPlan.OperatorMeta om = this.logicalPlan.getOperatorMeta(sourceOperName);
        if (om == null) {
            throw new ValidationException("Invalid operator name " + sourceOperName);
        }
        Operators.PortMappingDescriptor portMap = new Operators.PortMappingDescriptor();
        Operators.describe((DAG.GenericOperator)om.getOperator(), portMap);
        Operators.PortContextPair<Operator.OutputPort<?>> sourcePort = portMap.outputPorts.get(sourcePortName);
        if (sourcePort == null) {
            throw new AssertionError((Object)String.format("Invalid port %s (%s)", sourcePortName, om));
        }
        this.addStream(streamName, (Operator.OutputPort)sourcePort.component, this.getInputPort(targetOperName, targetPortName));
    }

    public void addSink(String streamName, String targetOperName, String targetPortName) {
        this.addSinks(streamName, this.getInputPort(targetOperName, targetPortName));
    }

    private LogicalPlan.OperatorMeta assertGetOperator(String operName) {
        LogicalPlan.OperatorMeta om = this.logicalPlan.getOperatorMeta(operName);
        if (om == null) {
            throw new AssertionError((Object)("Invalid operator name " + operName));
        }
        return om;
    }

    private Operator.InputPort<?> getInputPort(String operName, String portName) {
        LogicalPlan.OperatorMeta om = this.assertGetOperator(operName);
        Operators.PortMappingDescriptor portMap = new Operators.PortMappingDescriptor();
        Operators.describe((DAG.GenericOperator)om.getOperator(), portMap);
        Operators.PortContextPair<Operator.InputPort<?>> port = portMap.inputPorts.get(portName);
        if (port == null) {
            throw new AssertionError((Object)String.format("Invalid port %s (%s)", portName, om));
        }
        return (Operator.InputPort)port.component;
    }

    public void removeStream(String streamName) {
        LogicalPlan.StreamMeta sm = this.logicalPlan.getStream(streamName);
        if (sm == null) {
            return;
        }
        if (this.physicalPlan != null) {
            this.physicalPlan.removeLogicalStream(sm);
        }
        sm.remove();
    }

    public void addOperator(String name, Operator operator) {
        this.logicalPlan.addOperator(name, operator);
        if (this.physicalPlan != null) {
            LogicalPlan.OperatorMeta om = this.logicalPlan.getMeta(operator);
            this.physicalPlan.addLogicalOperator(om);
        }
    }

    public void removeOperator(String name) {
        LogicalPlan.OperatorMeta om = this.logicalPlan.getOperatorMeta(name);
        if (om == null) {
            return;
        }
        if (!om.getInputStreams().isEmpty()) {
            for (Map.Entry<LogicalPlan.InputPortMeta, LogicalPlan.StreamMeta> input : om.getInputStreams().entrySet()) {
                if (input.getValue().getSinks().size() != 1) continue;
                String msg = String.format("Operator %s connected to input streams %s", om.getName(), om.getInputStreams());
                throw new ValidationException(msg);
            }
        }
        if (!om.getOutputStreams().isEmpty()) {
            String msg = String.format("Operator %s connected to output streams %s", om.getName(), om.getOutputStreams());
            throw new ValidationException(msg);
        }
        this.logicalPlan.removeOperator(om.getOperator());
        if (this.physicalPlan != null) {
            this.physicalPlan.removeLogicalOperator(om);
        }
    }

    public void setOperatorProperty(String operatorName, String propertyName, String propertyValue) {
        LogicalPlan.OperatorMeta om = this.assertGetOperator(operatorName);
        if (this.physicalPlan != null) {
            for (PTOperator oper : this.physicalPlan.getOperators(om)) {
                if (this.physicalPlan.newOpers.containsKey(oper)) continue;
                throw new ValidationException("Properties can only be set on new operators: " + om + " " + propertyName + " " + propertyValue);
            }
        }
        Map<String, String> props = Collections.singletonMap(propertyName, propertyValue);
        LogicalPlanConfiguration.setOperatorProperties((DAG.GenericOperator)om.getOperator(), props);
    }

    public void applyChanges(PhysicalPlan.PlanContext physicalPlanContext) {
        this.physicalPlan.deployChanges();
    }
}

