/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.security;

import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.util.FSUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramUserLogin {
    private static final Logger LOG = LoggerFactory.getLogger(StramUserLogin.class);
    public static final String DT_AUTH_PREFIX = "dt.authentication.";
    public static final String DT_AUTH_PRINCIPAL = "dt.authentication.principal";
    public static final String DT_AUTH_KEYTAB = "dt.authentication.keytab";
    private static String principal;
    private static String keytab;

    public static void attemptAuthentication(Configuration conf) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            StramUserLogin.authenticate(conf);
        }
    }

    public static void authenticate(Configuration conf) throws IOException {
        String userPrincipal = conf.get(DT_AUTH_PRINCIPAL);
        String userKeytab = conf.get(DT_AUTH_KEYTAB);
        StramUserLogin.authenticate(userPrincipal, userKeytab);
    }

    public static void authenticate(String principal, String keytab) throws IOException {
        if (principal != null && !principal.isEmpty() && keytab != null && !keytab.isEmpty()) {
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                LOG.info("Login user {}", (Object)UserGroupInformation.getCurrentUser().getUserName());
                StramUserLogin.principal = principal;
                StramUserLogin.keytab = keytab;
            }
            catch (IOException ie) {
                LOG.error("Error login user with principal {}", (Object)principal, (Object)ie);
                throw ie;
            }
        }
    }

    public static long refreshTokens(long tokenLifeTime, String destinationDir, String destinationFile, final Configuration conf, String principal, String hdfsKeyTabFile, final Credentials credentials, InetSocketAddress rmAddress, final boolean renewRMToken) throws IOException {
        File keyTabFile;
        long expiryTime = System.currentTimeMillis() + tokenLifeTime;
        final String tokenRenewer = conf.get("yarn.resourcemanager.principal");
        if (tokenRenewer == null || tokenRenewer.length() == 0) {
            throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
        }
        try (FileSystem fs = FileSystem.newInstance((Configuration)conf);){
            keyTabFile = FSUtil.copyToLocalFileSystem(fs, destinationDir, destinationFile, hdfsKeyTabFile, conf);
        }
        if (principal == null) {
            principal = UserGroupInformation.getCurrentUser().getUserName();
        }
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keyTabFile.getAbsolutePath());
        try {
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    YarnClient yarnClient = null;
                    if (renewRMToken) {
                        yarnClient = YarnClient.createYarnClient();
                        yarnClient.init(conf);
                        yarnClient.start();
                    }
                    Credentials creds = new Credentials();
                    try (FileSystem fs1 = FileSystem.newInstance((Configuration)conf);){
                        fs1.addDelegationTokens(tokenRenewer, creds);
                        if (renewRMToken) {
                            new StramClientUtils.ClientRMHelper(yarnClient, conf).addRMDelegationToken(tokenRenewer, creds);
                        }
                    }
                    finally {
                        if (renewRMToken) {
                            yarnClient.stop();
                        }
                    }
                    credentials.addAll(creds);
                    return null;
                }
            });
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
        }
        catch (InterruptedException e) {
            LOG.error("Error while renewing tokens ", (Throwable)e);
            expiryTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            LOG.error("Error while renewing tokens ", (Throwable)e);
            expiryTime = System.currentTimeMillis();
        }
        LOG.debug("number of tokens: {}", (Object)credentials.getAllTokens().size());
        for (Token token : credentials.getAllTokens()) {
            LOG.debug("updated token: {}", (Object)token);
        }
        keyTabFile.delete();
        return expiryTime;
    }

    public static String getPrincipal() {
        return principal;
    }

    public static String getKeytab() {
        return keytab;
    }
}

