/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.security;

import com.datatorrent.stram.security.StramDelegationTokenIdentifier;
import com.datatorrent.stram.security.StramDelegationTokenManager;
import com.datatorrent.stram.security.StramWSPrincipal;
import com.datatorrent.stram.security.StramWSServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramWSFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(StramWSFilter.class);
    public static final String PROXY_HOST = "PROXY_HOST";
    public static final String PROXY_DELIMITER = ",";
    private static final long updateInterval = 300000L;
    public static final String CLIENT_COOKIE = "dt-client";
    private static final long DELEGATION_KEY_UPDATE_INTERVAL = 86400000L;
    private static final long DELEGATION_TOKEN_MAX_LIFETIME = 5400000L;
    private static final long DELEGATION_TOKEN_RENEW_INTERVAL = 5400000L;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = 1800000L;
    private static final String WEBAPP_PROXY_USER = "proxy-user";
    private String[] proxyHosts;
    private Set<String> proxyAddresses = null;
    private long lastUpdate;
    private StramDelegationTokenManager tokenManager;
    private AtomicInteger sequenceNumber;
    private String loginUser;

    public void init(FilterConfig conf) throws ServletException {
        String proxy = conf.getInitParameter(PROXY_HOST);
        this.proxyHosts = proxy.split(PROXY_DELIMITER);
        this.tokenManager = new StramDelegationTokenManager(86400000L, 5400000L, 5400000L, 1800000L);
        this.sequenceNumber = new AtomicInteger(0);
        try {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            if (ugi != null) {
                this.loginUser = ugi.getUserName();
            }
            this.tokenManager.startThreads();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getProxyAddresses() throws ServletException {
        long now = System.currentTimeMillis();
        StramWSFilter stramWSFilter = this;
        synchronized (stramWSFilter) {
            if (this.proxyAddresses == null || this.lastUpdate + 300000L >= now) {
                this.proxyAddresses = new HashSet<String>();
                for (String proxyHost : this.proxyHosts) {
                    try {
                        logger.debug("resolving proxy hostname {}", (Object)proxyHost);
                        for (InetAddress add : InetAddress.getAllByName(proxyHost)) {
                            logger.debug("proxy address is: {}", (Object)add.getHostAddress());
                            this.proxyAddresses.add(add.getHostAddress());
                        }
                        this.lastUpdate = now;
                    }
                    catch (UnknownHostException e) {
                        throw new ServletException("Could not locate " + proxyHost, (Throwable)e);
                    }
                }
            }
            return this.proxyAddresses;
        }
    }

    public void destroy() {
        this.tokenManager.stopThreads();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("This filter only works for HTTP/HTTPS");
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        String remoteAddr = httpReq.getRemoteAddr();
        String requestURI = httpReq.getRequestURI();
        boolean authenticate = true;
        String user = null;
        if (this.getProxyAddresses().contains(httpReq.getRemoteAddr())) {
            if (httpReq.getCookies() != null) {
                for (Cookie c : httpReq.getCookies()) {
                    if (!WEBAPP_PROXY_USER.equals(c.getName())) continue;
                    user = c.getValue();
                    break;
                }
            }
            if (requestURI.equals("/ws") && user != null) {
                String token = this.createClientToken(user, httpReq.getLocalAddr());
                logger.debug("{}: creating token {}", (Object)remoteAddr, (Object)token);
                Cookie cookie = new Cookie(CLIENT_COOKIE, token);
                httpResp.addCookie(cookie);
            } else {
                logger.info("{}: proxy access to URI {} by user {}, no cookie created", new Object[]{remoteAddr, requestURI, user});
            }
            authenticate = false;
        }
        if (authenticate) {
            Cookie cookie = null;
            if (httpReq.getCookies() != null) {
                for (Cookie c : httpReq.getCookies()) {
                    if (!c.getName().equals(CLIENT_COOKIE)) continue;
                    cookie = c;
                    break;
                }
            }
            boolean valid = false;
            if (cookie != null) {
                user = this.verifyClientToken(cookie.getValue(), remoteAddr);
                if (user != null) {
                    valid = true;
                } else {
                    logger.debug("{}: invalid cookie {}", (Object)remoteAddr, (Object)cookie.getValue());
                }
            } else {
                logger.debug("{}: cookie not found {}", (Object)remoteAddr, (Object)CLIENT_COOKIE);
            }
            if (!valid) {
                logger.debug("{}: auth failure", (Object)remoteAddr);
                httpResp.sendError(401);
                return;
            }
        }
        if (user == null) {
            logger.debug("{}: could not find user, so user principal will not be set", (Object)remoteAddr);
            chain.doFilter(req, resp);
        } else {
            StramWSPrincipal principal = new StramWSPrincipal(user);
            StramWSServletRequestWrapper requestWrapper = new StramWSServletRequestWrapper(httpReq, principal);
            chain.doFilter((ServletRequest)requestWrapper, resp);
        }
    }

    private String createClientToken(String username, String service) throws IOException {
        StramDelegationTokenIdentifier tokenIdentifier = new StramDelegationTokenIdentifier(new Text(username), new Text(this.loginUser), new Text());
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.tokenManager);
        token.setService(new Text(service));
        return token.encodeToUrlString();
    }

    private String verifyClientToken(String tokenstr, String cid) throws IOException {
        Token token = new Token();
        try {
            token.decodeFromUrlString(tokenstr);
        }
        catch (IOException e) {
            logger.debug("{}: error decoding token: {}", (Object)cid, (Object)e.getMessage());
            return null;
        }
        byte[] identifier = token.getIdentifier();
        byte[] password = token.getPassword();
        StramDelegationTokenIdentifier tokenIdentifier = new StramDelegationTokenIdentifier();
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(identifier));
        try {
            tokenIdentifier.readFields(input);
        }
        catch (IOException e) {
            logger.debug("{}: error decoding identifier: {}", (Object)cid, (Object)e.getMessage());
            return null;
        }
        try {
            this.tokenManager.verifyToken(tokenIdentifier, password);
        }
        catch (SecretManager.InvalidToken e) {
            logger.debug("{}: invalid token {}: {}", new Object[]{cid, tokenIdentifier, e.getMessage()});
            return null;
        }
        return tokenIdentifier.getOwner().toString();
    }
}

