/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.security;

import com.datatorrent.stram.client.StramClientUtils;
import com.datatorrent.stram.security.StramWSFilter;
import com.datatorrent.stram.util.ConfigUtils;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StramWSFilterInitializer
extends FilterInitializer {
    private static final Logger logger = LoggerFactory.getLogger(StramWSFilterInitializer.class);
    private static final String FILTER_NAME = "AM_PROXY_FILTER";
    private static final String FILTER_CLASS = StramWSFilter.class.getCanonicalName();

    public void initFilter(FilterContainer container, Configuration conf) {
        logger.debug("Conf {}", (Object)conf);
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> proxies = new ArrayList<String>();
        if (ConfigUtils.isRMHAEnabled(conf)) {
            for (String rmId : ConfigUtils.getRMHAIds(conf)) {
                proxies.add(this.getResolvedRMWebAppURLWithoutScheme(conf, rmId));
            }
            logger.info("HA proxy addresses {}", proxies);
        }
        if (proxies.isEmpty()) {
            proxies.add(this.getProxyHostAndPort(conf));
            logger.info("Proxy addresses {}", proxies);
        }
        StringBuilder proxyBr = new StringBuilder();
        for (String proxy : proxies) {
            if (proxyBr.length() != 0) {
                proxyBr.append(",");
            }
            String[] parts = proxy.split(":");
            proxyBr.append(parts[0]);
        }
        params.put("PROXY_HOST", proxyBr.toString());
        container.addFilter(FILTER_NAME, FILTER_CLASS, params);
    }

    public String getProxyHostAndPort(Configuration conf) {
        String addr = conf.get("yarn.web-proxy.address");
        logger.info("proxy address setting {}", (Object)addr);
        logger.debug("proxy setting sources {}", (Object[])conf.getPropertySources("yarn.web-proxy.address"));
        if (addr == null || addr.isEmpty()) {
            addr = this.getResolvedRMWebAppURLWithoutScheme(conf, null);
        }
        return addr;
    }

    public String getResolvedRMWebAppURLWithoutScheme(Configuration conf, String rmId) {
        InetSocketAddress socketAddress = StramClientUtils.getRMWebAddress(conf, rmId);
        return StramClientUtils.getSocketConnectString(socketAddress);
    }

    public String getResolvedRMWebAppURLWithoutScheme(Configuration conf, boolean sslEnabled, String rmId) {
        InetSocketAddress socketAddress = StramClientUtils.getRMWebAddress(conf, sslEnabled, rmId);
        return StramClientUtils.getSocketConnectString(socketAddress);
    }
}

