/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWritableAdapter
implements Writable,
Serializable {
    private static final long serialVersionUID = 201306061421L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractWritableAdapter.class);

    public void readFields(DataInput arg0) throws IOException {
        int len = arg0.readInt();
        byte[] bytes = new byte[len];
        arg0.readFully(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Map properties = (Map)ois.readObject();
            AccessibleObject[] fields = this.getClass().getFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject field = fields[i];
                String fieldName = ((Field)field).getName();
                if (!properties.containsKey(fieldName)) continue;
                ((Field)field).set(this, properties.get(fieldName));
            }
            ois.close();
        }
        catch (Exception e) {
            Path path = Files.createTempFile("apex-rpc-raw-dump-", ".ser", new FileAttribute[0]);
            logger.error("Failed to de-serialize {}. Writing raw data to {}.", new Object[]{this.getClass().getName(), path, e});
            Files.write(path, bytes, new OpenOption[0]);
            throw new IOException(e);
        }
    }

    public void write(DataOutput arg0) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            AccessibleObject[] fields = this.getClass().getFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject field = fields[i];
                if (Modifier.isStatic(((Field)field).getModifiers())) continue;
                String fieldName = ((Field)field).getName();
                Object fieldValue = ((Field)field).get(this);
                properties.put(fieldName, fieldValue);
            }
            oos.writeObject(properties);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        oos.flush();
        byte[] bytes = bos.toByteArray();
        arg0.writeInt(bytes.length);
        arg0.write(bytes);
        oos.close();
    }
}

