/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final String RM_HA_PREFIX = "yarn.resourcemanager.ha.";
    public static final String RM_HA_ENABLED = "yarn.resourcemanager.ha.enabled";
    public static final String RM_HA_IDS = "yarn.resourcemanager.ha.rm-ids";
    public static final String RM_HA_ID = "yarn.resourcemanager.ha.id";
    public static final boolean DEFAULT_RM_HA_ENABLED = false;
    private static String yarnLogDir;
    private static final Logger LOG;
    private static boolean rawContainerLogWarningPrinted;

    public static InetSocketAddress getRMAddress(YarnConfiguration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static String getRMUsername(Configuration conf) {
        String principal = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            principal = conf.get("yarn.resourcemanager.principal");
            int sindex = -1;
            if (principal != null && (sindex = principal.indexOf(47)) != -1) {
                principal = principal.substring(0, sindex);
            }
        }
        return principal;
    }

    public static boolean isSSLEnabled(Configuration conf) {
        return HttpConfig.Policy.HTTPS_ONLY == HttpConfig.Policy.fromString((String)conf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT));
    }

    public static String getSchemePrefix(Configuration conf) {
        if (ConfigUtils.isSSLEnabled(conf)) {
            return "https://";
        }
        return "http://";
    }

    @Deprecated
    public static String getSchemePrefix(YarnConfiguration conf) {
        return ConfigUtils.getSchemePrefix((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYarnLogDir() {
        if (yarnLogDir != null) {
            return yarnLogDir;
        }
        String value = System.getenv("YARN_LOG_DIR");
        try {
            if (value != null) {
                String string = value;
                return string;
            }
            String opts = System.getenv("YARN_OPTS");
            if (opts != null) {
                value = ConfigUtils.getDefineValue(opts, "yarn.log.dir");
                if (value != null) {
                    String string = value;
                    return string;
                }
                value = ConfigUtils.getDefineValue(opts, "hadoop.log.dir");
                if (value != null) {
                    String string = value;
                    return string;
                }
            }
            if ((opts = System.getenv("HADOOP_OPTS")) != null) {
                value = ConfigUtils.getDefineValue(opts, "yarn.log.dir");
                if (value != null) {
                    String string = value;
                    return string;
                }
                value = ConfigUtils.getDefineValue(opts, "hadoop.log.dir");
                if (value != null) {
                    String string = value;
                    return string;
                }
            }
            String string = value;
            return string;
        }
        finally {
            yarnLogDir = value;
        }
    }

    public static String getRawContainerLogsUrl(YarnConfiguration conf, String nodeHttpAddress, String appId, String containerId) {
        block5: {
            String logDirs = conf.get("yarn.nodemanager.log-dirs");
            if (logDirs.startsWith("${yarn.log.dir}")) {
                return ConfigUtils.getSchemePrefix(conf) + nodeHttpAddress + "/logs" + logDirs.substring("${yarn.log.dir}".length()) + "/" + appId + "/" + containerId;
            }
            try {
                String logDirsPath = new File(logDirs).getCanonicalPath();
                String yarnLogDirPath = new File(ConfigUtils.getYarnLogDir()).getCanonicalPath();
                if (logDirsPath.startsWith(yarnLogDirPath)) {
                    return ConfigUtils.getSchemePrefix(conf) + nodeHttpAddress + "/logs" + logDirsPath.substring(yarnLogDirPath.length()) + "/" + appId + "/" + containerId;
                }
                if (!rawContainerLogWarningPrinted) {
                    LOG.warn("Cannot determine the location of container logs because of incompatible node manager log location ({}) and yarn log location ({})", (Object)logDirsPath, (Object)yarnLogDirPath);
                    rawContainerLogWarningPrinted = true;
                }
            }
            catch (Exception ex) {
                if (rawContainerLogWarningPrinted) break block5;
                LOG.warn("Cannot determine the location of container logs because of error: ", (Throwable)ex);
                rawContainerLogWarningPrinted = true;
            }
        }
        return null;
    }

    public static boolean isRMHAEnabled(Configuration conf) {
        return conf.getBoolean(RM_HA_ENABLED, false);
    }

    public static Collection<String> getRMHAIds(Configuration conf) {
        return conf.getStringCollection(RM_HA_IDS);
    }

    private static String getDefineValue(String optString, String name) {
        int i = optString.indexOf("-D" + name + "=");
        if (i >= 0) {
            int j = optString.indexOf(32, i = i + name.length() + 3);
            if (j == -1) {
                return optString.substring(i);
            }
            return optString.substring(i, j);
        }
        return null;
    }

    static {
        LOG = LoggerFactory.getLogger(ConfigUtils.class);
        rawContainerLogWarningPrinted = false;
    }
}

