/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import com.datatorrent.stram.util.JSONSerializationProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSJsonLineFile
implements Closeable {
    private final ObjectMapper objectMapper;
    private final FSDataOutputStream os;
    private static final Logger LOG = LoggerFactory.getLogger(FSJsonLineFile.class);

    public FSJsonLineFile(FileContext fileContext, Path path, FsPermission permission) throws IOException {
        this.os = fileContext.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)permission)});
        this.objectMapper = new JSONSerializationProvider().getContext(null);
    }

    public synchronized void append(JSONObject json) throws IOException {
        this.os.writeBytes(json.toString() + "\n");
        this.os.hflush();
    }

    public synchronized void append(Object obj) throws IOException {
        this.os.writeBytes(this.objectMapper.writeValueAsString(obj) + "\n");
        this.os.hflush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

