/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.stram.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FSUtil.class);

    public static boolean copy(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        if (srcStatus.isDirectory()) {
            if (!FSUtil.mkdirs(dstFS, dst)) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FSUtil.copy(srcFS, contents[i], dstFS, new Path(dst, contents[i].getPath().getName()), deleteSource, overwrite, conf);
            }
        } else {
            try (FSDataInputStream in = srcFS.open(src);
                 FSDataOutputStream out = dstFS.create(dst, overwrite);){
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)true);
            }
        }
        if (srcStatus.isDirectory()) {
            dstFS.setPermission(dst, new FsPermission(511));
        } else {
            dstFS.setPermission(dst, new FsPermission(511));
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    public static void setPermission(FileSystem fs, Path dst, FsPermission permission) throws IOException {
        FileStatus[] contents = fs.listStatus(dst);
        for (int i = 0; i < contents.length; ++i) {
            fs.setPermission(contents[i].getPath(), permission);
        }
        fs.setPermission(dst, permission);
    }

    public static boolean mkdirs(FileSystem fs, Path dest) throws IOException {
        try {
            return fs.mkdirs(dest);
        }
        catch (IOException e) {
            if (!fs.exists(dest)) {
                throw e;
            }
            return false;
        }
    }

    public static File copyToLocalFileSystem(FileSystem fs, String destinationPath, String destinationFile, String dfsFile, Configuration conf) throws IOException {
        File destinationDir = new File(destinationPath);
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new RuntimeException("Unable to create local directory");
        }
        try (RawLocalFileSystem localFileSystem = new RawLocalFileSystem();){
            FsPermission permissions = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
            localFileSystem.setPermission(new Path(destinationDir.getAbsolutePath()), permissions);
            Path dfsFilePath = new Path(dfsFile);
            File localFile = new File(destinationDir, destinationFile);
            FileUtil.copy((FileSystem)fs, (Path)dfsFilePath, (File)localFile, (boolean)false, (Configuration)conf);
            permissions = new FsPermission(FsAction.READ, FsAction.NONE, FsAction.NONE);
            localFileSystem.setPermission(new Path(localFile.getAbsolutePath()), permissions);
            File file = localFile;
            return file;
        }
    }
}

